/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.io;

import android.media.AudioTrack;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.audiojack.io.PlayerAudioTrack;
import java.math.BigInteger;

public class UniJackCommandEncoder
extends PlayerAudioTrack {
    static final int kAUDIO_CHANNEL = 12;
    static final int kAUDIO_ENCODING = 3;

    @Override
    public AudioTrack getCommandAudioTrack(byte[] commandString) {
        byte[] cmdStream;
        short outputWaveDirection = this.config.getDirectionOutputWave();
        short powerupBeforeCmd = this.config.getPowerupLastBeforeCMD();
        int outputSampleRate = 48000;
        String cmdStr = Common.getHexStringFromBytes(commandString);
        String cmdBinStringToSend = this.binStringToCmdBinString(this.hexToBin(cmdStr));
        if (commandString != null) {
            cmdStream = commandString.length == 1 && commandString[0] == 0 ? this.createCommunicationWaveForSwipe(outputWaveDirection, outputSampleRate, powerupBeforeCmd) : (commandString.length == 1 && commandString[0] == 5 ? this.createCommunicationWaveForCancelSwipe(outputWaveDirection, outputSampleRate, powerupBeforeCmd) : this.createCommunicationWave(cmdBinStringToSend, outputWaveDirection, outputSampleRate, powerupBeforeCmd));
        } else {
            return null;
        }
        AudioTrack ret = new AudioTrack(3, outputSampleRate, 12, 3, cmdStream.length, 0);
        if (ret.write(cmdStream, 0, cmdStream.length) != cmdStream.length) {
            ret.release();
            throw new RuntimeException();
        }
        if (ret.getState() != 1) {
            throw new RuntimeException();
        }
        return ret;
    }

    private byte[] createCommunicationWaveForSwipe(int outputWaveDirection, int outputFrequency, int delay) {
        int outputLengthInMs = 1000;
        int cycleLength = outputFrequency / 1000 * 2;
        int totalLength = cycleLength * outputLengthInMs;
        totalLength = totalLength / cycleLength * cycleLength;
        byte[] ret = new byte[totalLength];
        int H = -1;
        int M = -128;
        int L = 1;
        if (outputWaveDirection == 0) {
            H = 1;
            L = -1;
        }
        for (int i = 0; i < totalLength; i += cycleLength) {
            for (int j = 0; j < cycleLength; j += 2) {
                if (j < cycleLength / 2) {
                    if (j == 0) {
                        ret[i + j] = M;
                        ret[i + j + 1] = M;
                        continue;
                    }
                    ret[i + j] = H;
                    ret[i + j + 1] = H;
                    continue;
                }
                if (j == cycleLength / 2) {
                    ret[i + j] = M;
                    ret[i + j + 1] = M;
                    continue;
                }
                ret[i + j] = L;
                ret[i + j + 1] = L;
            }
        }
        return ret;
    }

    private byte[] createCommunicationWaveForCancelSwipe(int outputWaveDirection, int outputFrequency, int delay) {
        int cycleLength = 12;
        int totalLength = 480000;
        byte[] ret = new byte[totalLength];
        int H = -1;
        int M = -128;
        int L = 1;
        if (outputWaveDirection == 0) {
            H = 1;
            L = -1;
        }
        for (int i = 0; i < totalLength; i += cycleLength) {
            for (int j = 0; j < cycleLength; j += 2) {
                if (j < cycleLength / 2) {
                    if (j == 0) {
                        ret[i + j] = M;
                        ret[i + j + 1] = M;
                        continue;
                    }
                    ret[i + j] = H;
                    ret[i + j + 1] = H;
                    continue;
                }
                if (j == cycleLength / 2) {
                    ret[i + j] = M;
                    ret[i + j + 1] = M;
                    continue;
                }
                ret[i + j] = L;
                ret[i + j + 1] = L;
            }
        }
        return ret;
    }

    private byte[] createCommunicationWave(String strData, int outputWaveDirection, int outputFrequency, int delay) {
        int i;
        int i2;
        byte H = -1;
        int M = -128;
        byte L = 1;
        if (outputWaveDirection == 0) {
            H = 1;
            L = -1;
        }
        int samplesPerMs = outputFrequency / 1000 * 2;
        int delayLength = 0;
        if (delay > 200) {
            delayLength = samplesPerMs * 300;
        }
        int squareWaveLength = samplesPerMs * 200;
        int pauseLength = samplesPerMs * 10;
        int delayEndLength = samplesPerMs * 20;
        int commandLength = strData.length() * 10 + 2 + delayEndLength;
        byte[] realBuffer = new byte[delayLength + squareWaveLength + 960 + commandLength];
        for (i2 = 0; i2 < delayLength; ++i2) {
            realBuffer[i2] = M;
        }
        for (i2 = delayLength; i2 < squareWaveLength + delayLength; i2 += 48) {
            for (int j = 0; j < 48; j += 2) {
                if (j < 24) {
                    if (j == 0) {
                        realBuffer[i2 + j] = M;
                        realBuffer[i2 + j + 1] = M;
                        continue;
                    }
                    realBuffer[i2 + j] = H;
                    realBuffer[i2 + j + 1] = H;
                    continue;
                }
                if (j == 24) {
                    realBuffer[i2 + j] = M;
                    realBuffer[i2 + j + 1] = M;
                    continue;
                }
                realBuffer[i2 + j] = L;
                realBuffer[i2 + j + 1] = L;
            }
        }
        for (i2 = delayLength + squareWaveLength; i2 < delayLength + squareWaveLength + pauseLength; ++i2) {
            realBuffer[i2] = M;
        }
        byte[] actualCmd = new byte[commandLength];
        for (int k = 0; k < 10; ++k) {
            actualCmd[k] = H;
        }
        for (i = 1; i < strData.length(); ++i) {
            int k;
            if (strData.charAt(i) == '0') {
                if (actualCmd[i * 10 - 1] == H) {
                    actualCmd[i * 10] = H;
                    actualCmd[i * 10 + 1] = H;
                } else if (actualCmd[i * 10 - 1] == L) {
                    actualCmd[i * 10] = M;
                    actualCmd[i * 10 + 1] = M;
                }
                for (k = i * 10 + 2; k < i * 10 + 10; ++k) {
                    actualCmd[k] = H;
                }
                continue;
            }
            if (strData.charAt(i) != '1') continue;
            if (actualCmd[i * 10 - 1] == L) {
                actualCmd[i * 10] = L;
                actualCmd[i * 10 + 1] = L;
            } else if (actualCmd[i * 10 - 1] == H) {
                actualCmd[i * 10] = M;
                actualCmd[i * 10 + 1] = M;
            }
            for (k = i * 10 + 2; k < i * 10 + 10; ++k) {
                actualCmd[k] = L;
            }
        }
        for (i = actualCmd.length - delayEndLength - 2; i < actualCmd.length; ++i) {
            actualCmd[i] = L;
        }
        System.arraycopy(actualCmd, 0, realBuffer, delayLength + squareWaveLength + pauseLength, commandLength);
        return realBuffer;
    }

    private String binStringToCmdBinString(String binString) {
        String result = "";
        for (int i = 0; i < binString.length(); i += 4) {
            String str = "0";
            for (int j = i + 3; j >= i; --j) {
                if (binString.charAt(j) == '0') {
                    str = str + "10";
                    continue;
                }
                if (binString.charAt(j) != '1') continue;
                str = str + "01";
            }
            str = str + "1";
            result = result + str;
        }
        return result;
    }

    private String hexToBin(String s) {
        String result = "";
        for (int i = 0; i < s.length() / 2; ++i) {
            String singleByte = new BigInteger(s.substring(i * 2, i * 2 + 2), 16).toString(2);
            while (singleByte.length() < 8) {
                singleByte = "0" + singleByte;
            }
            result = result + singleByte;
        }
        return result;
    }
}

