/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import android.media.AudioTrack;
import android.os.Build;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.StructConfigParameters;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.io.ToneType;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class AutoConfigTask
extends Task {
    private final boolean _cfg_readerSupportsCommand;
    private final List<StructConfigParameters> _cfg_templates;
    private StructConfigParameters _originalConfig;
    private Boolean _isLongCommandSupported = null;
    private IDT_Device.TaskExport _taskExport;
    private static final int[] recordSampList = Build.MANUFACTURER.equalsIgnoreCase("samsung") ? new int[]{48000, 44100, 22050} : new int[]{48000, 44100, 32000, 24000, 22050};
    private final byte[] resp_long = Common.base16Decode("023100064142434445464748494a4b4c4d4e4f505152535455565758595a6162636465666768696a6b6c6d6e6f707172737475760a2203");
    private final byte[] resp_long_um = Common.base16Decode("06024142434445464748494a4b4c4d4e4f505152535455565758595a6162636465666768696a6b6c6d6e6f70717273747576030d");

    public AutoConfigTask(TaskManager umMan, ReaderCommunication readerCommunication, boolean readerSupportsCommand, List<StructConfigParameters> templates, IDT_Device.TaskExport taskExport) {
        super(umMan, readerCommunication);
        this._taskExport = taskExport;
        this._cfg_readerSupportsCommand = readerSupportsCommand;
        this._cfg_templates = templates;
    }

    @Override
    protected boolean taskSetup() {
        this.tone_saveAndStop();
        if (this._ioManager != null) {
            this._originalConfig = this._ioManager.getConfigCopy();
        }
        return true;
    }

    @Override
    protected void taskCleanup() {
        if (this._ioManager != null) {
            this._ioManager.notifyTaskFinished();
            this._ioManager.setConfig(this._originalConfig);
        }
        this.tone_restore();
    }

    @Override
    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.AutoConfig;
    }

    @Override
    protected Runnable taskMain() {
        this.reportProgressPercent(0);
        this._ioManager.stopRecordThread();
        StructConfigParameters config = null;
        if (this._cfg_templates != null) {
            int count = 0;
            for (int templateI = 0; templateI < this._cfg_templates.size(); ++templateI) {
                StructConfigParameters template = this._cfg_templates.get(templateI);
                if (!this._cfg_readerSupportsCommand && template.getBaudRate() != 9600 || !Common.checkInputFrequencySupported(template.getFrequenceInput())) continue;
                if (Build.VERSION.SDK_INT == 8) {
                    template.setForceHeadsetPlug((short)1);
                }
                for (int vr = 1; vr >= 0; --vr) {
                    template.setUseVoiceRecognition((short)vr);
                    for (int dir = 1; dir >= 0; --dir) {
                        UMLog.i(this.TAG, "template: " + template.getModelNumber() + " (vr:" + vr + ", dir:" + dir + ")");
                        template.setDirectionOutputWave((short)dir);
                        int percent = ++count * 70 / this._cfg_templates.size() / 2 / 2;
                        if (percent == 0) {
                            percent = 1;
                        }
                        this.reportProgressPercent(percent);
                        FindParamRet templateRet = this.helper_testStability(template, template.getBaudRate());
                        if (templateRet.isCanceled) {
                            return null;
                        }
                        if (templateRet.config == null) continue;
                        config = templateRet.config;
                        break;
                    }
                    if (config != null) break;
                }
                if (config != null) break;
            }
        }
        if (config == null && !Common.fastSearch) {
            config = new StructConfigParameters();
            if (Build.VERSION.SDK_INT == 8) {
                config.setForceHeadsetPlug((short)1);
            }
            boolean supportedInputSampFound = false;
            for (int inputSamp : recordSampList) {
                if (!Common.checkInputFrequencySupported(inputSamp)) continue;
                config.setFrequenceInput(inputSamp);
                supportedInputSampFound = true;
                break;
            }
            if (!supportedInputSampFound) {
                UMLog.e(this.TAG, "aborted. Device does not support any input sampling rate");
                return null;
            }
            FindParamRet output = this.findParam_output(config);
            if (output.isCanceled) {
                return null;
            }
            config = output.config;
            if (config != null) {
                UMLog.i(this.TAG, "output parameters found");
                FindParamRet recordAndParseRet = this.findParam_recordAndParse(config);
                if (recordAndParseRet.isCanceled) {
                    return null;
                }
                config = recordAndParseRet.config;
            }
        }
        if (config != null) {
            UMLog.i(this.TAG, "profile found");
            if (this._originalConfig != null) {
                config.setSupportStatuses(this._originalConfig.getSupportStatuses());
            }
        }
        final StructConfigParameters config_f = config;
        return new Runnable(){

            @Override
            public void run() {
                if (config_f != null) {
                    try {
                        AutoConfigTask.this.saveConfigToFile(config_f);
                    }
                    catch (IOException ie) {
                        UMLog.e(AutoConfigTask.this.TAG, "***=== saveConfigToFile:" + ie.toString());
                    }
                    AutoConfigTask.this._umrMsg.autoConfigCompleted(config_f);
                } else {
                    AutoConfigTask.this._ioManager.stopRecordThread();
                    AutoConfigTask.this._umrMsg.timeout(25);
                }
            }
        };
    }

    private void saveConfigToFile(StructConfigParameters config) throws IOException {
        File dir = Common.getDir_externalOrSandbox(IDT_Device.context);
        UMLog.open(dir, "AutoConfig");
        UMLog.i("AutoConfig", config.toXMLString());
        UMLog.close();
    }

    private void reportProgressPercent(final int percent) {
        this.post(new Runnable(){

            @Override
            public void run() {
                AutoConfigTask.this._umrMsg.autoConfigProgress(percent);
            }
        });
    }

    private FindParamRet findParam_output(StructConfigParameters config) {
        int[] nArray;
        if (config == null) {
            config = new StructConfigParameters();
        }
        FindParamRet ret = new FindParamRet();
        ret.isCanceled = true;
        ret.config = null;
        short[] paramOutDir = new short[]{1, 0};
        if (Build.MANUFACTURER.equalsIgnoreCase("samsung")) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 48000;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 24000;
            nArray = nArray3;
            nArray3[1] = 48000;
        }
        int[] paramOutSamp = nArray;
        boolean found = false;
        int count = 0;
        block0: for (int iOutDir = 0; iOutDir < paramOutDir.length; ++iOutDir) {
            config.setDirectionOutputWave(paramOutDir[iOutDir]);
            for (int iOutSamp = 0; iOutSamp < paramOutSamp.length; ++iOutSamp) {
                byte[] byArray;
                IOManager.RPDResult r;
                if (AudioTrack.getMinBufferSize((int)paramOutSamp[iOutSamp], (int)12, (int)3) < 0) {
                    UMLog.i(this.TAG, "skipped unsupported output sampling rate: " + paramOutSamp[iOutSamp]);
                    continue;
                }
                config.setFrequenceOutput(paramOutSamp[iOutSamp]);
                AutoConfigTask.generateModelName(config);
                UMLog.i(this.TAG, config.getModelNumber());
                this._ioManager.setConfig(config);
                this.reportProgressPercent(70 + ++count * 20 / (paramOutDir.length * paramOutSamp.length));
                if (this._cfg_readerSupportsCommand) {
                    r = this._readerCommunication.sendCommand(Common.makeSetBaudAndLevelCommand(config, config.getBaudRate()), 2.0, this, this);
                } else {
                    this._tonePlayer.setPlayingTone(ToneType.T_2400Hz);
                    r = this._readerCommunication.sendCommand(null, 2.5, this, this);
                    this._tonePlayer.setPlayingTone(null);
                }
                if (r.isParsed()) {
                    byArray = r.data.get(0);
                } else {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 0;
                }
                byte[] returnedData = byArray;
                UMLog.i(this.TAG, "findParam_output:" + Common.getHexStringFromBytes(returnedData));
                if (r.isCanceledOrFailed()) {
                    return ret;
                }
                if (r.packetDetected) {
                    found = true;
                    break block0;
                }
                if (!this.safeWait(1.6)) continue;
                return ret;
            }
        }
        if (!found) {
            ret.isCanceled = false;
            return ret;
        }
        ret.isCanceled = false;
        ret.config = config;
        return ret;
    }

    private FindParamRet findParam_recordAndParse(StructConfigParameters config) {
        short[] sArray;
        IOManager.RPDResult r;
        config = config.clone();
        FindParamRet ret = new FindParamRet();
        ret.isCanceled = true;
        ret.config = null;
        UMLog.i(this.TAG, "set channel");
        int baudToTry = this._cfg_readerSupportsCommand ? 2400 : 9600;
        config.setBaudRate(baudToTry);
        this._ioManager.setConfig(config);
        if (this._cfg_readerSupportsCommand && (r = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG ? this._readerCommunication.sendCommand(Common.makeSetBaudCommand(config), 1.5, this, this) : (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK ? this._readerCommunication.sendCommand(Common.makeSetBaudCommandForUniJack(config), 1.5, this, this) : this._readerCommunication.sendCommand(Common.makeSetBaudAndLevelCommand(config, config.getBaudRate()), 2.5, this, this))).isCanceledOrFailed()) {
            return ret;
        }
        byte[] shuttleChannelList = new byte[]{48, 0};
        if (Build.VERSION.SDK_INT >= 7) {
            short[] sArray2 = new short[2];
            sArray2[0] = 1;
            sArray = sArray2;
            sArray2[1] = 0;
        } else {
            short[] sArray3 = new short[1];
            sArray = sArray3;
            sArray3[0] = 0;
        }
        short[] recordUseVrList = sArray;
        int[] recordSampList = AutoConfigTask.recordSampList;
        boolean found = false;
        int count = 0;
        block0: for (int shuttleChannelI = 0; shuttleChannelI < shuttleChannelList.length; ++shuttleChannelI) {
            config.setShuttleChannel(shuttleChannelList[shuttleChannelI]);
            UMLog.i(this.TAG, "LEVEL: " + shuttleChannelList[shuttleChannelI]);
            for (int recordSrcI = 0; recordSrcI < recordUseVrList.length; ++recordSrcI) {
                config.setUseVoiceRecognition(recordUseVrList[recordSrcI]);
                for (int recordSampI = 0; recordSampI < recordSampList.length; ++recordSampI) {
                    byte[] byArray;
                    if (!Common.checkInputFrequencySupported(recordSampList[recordSampI])) {
                        UMLog.i(this.TAG, "skipped unsupported input sampling rate: " + recordSampList[recordSampI]);
                        continue;
                    }
                    config.setFrequenceInput(recordSampList[recordSampI]);
                    AutoConfigTask.generateModelName(config);
                    UMLog.i(this.TAG, config.getModelNumber());
                    this._ioManager.setConfig(config);
                    this.reportProgressPercent(90 + ++count * 10 / (shuttleChannelList.length * recordUseVrList.length * recordSampList.length));
                    if (this._cfg_readerSupportsCommand) {
                        r = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG ? this._readerCommunication.sendCommand(Common.makeSetBaudCommand(config), 1.5, this, this) : (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK ? this._readerCommunication.sendCommand(Common.makeSetBaudCommandForUniJack(config), 1.5, this, this) : this._readerCommunication.sendCommand(Common.makeSetBaudAndLevelCommand(config, config.getBaudRate()), 2.5, this, this));
                    } else {
                        this._tonePlayer.setPlayingTone(ToneType.T_2400Hz);
                        r = this._readerCommunication.sendCommand(null, 2.5, this, this);
                        this._tonePlayer.setPlayingTone(null);
                    }
                    if (r.isParsed()) {
                        byArray = r.data.get(0);
                    } else {
                        byte[] byArray2 = new byte[1];
                        byArray = byArray2;
                        byArray2[0] = 0;
                    }
                    byte[] returnedData = byArray;
                    UMLog.i(this.TAG, "findParam_output:" + Common.getHexStringFromBytes(returnedData));
                    if (r.isCanceledOrFailed()) {
                        return ret;
                    }
                    if (r.isParsed()) {
                        FindParamRet fpr = this.findParam_highestStableBaud(config);
                        if (fpr.isCanceled) {
                            return ret;
                        }
                        if (fpr.config != null) {
                            config = fpr.config;
                            AutoConfigTask.generateModelName(config);
                            UMLog.i(this.TAG, "found stable profile: " + config.getModelNumber());
                            found = true;
                            break block0;
                        }
                    }
                    if (!this.safeWait(1.6)) continue;
                    return ret;
                }
            }
        }
        if (!found) {
            ret.isCanceled = false;
            return ret;
        }
        ret.isCanceled = false;
        ret.config = config;
        return ret;
    }

    private FindParamRet findParam_highestStableBaud(StructConfigParameters config) {
        config = config.clone();
        FindParamRet ret = new FindParamRet();
        ret.isCanceled = true;
        ret.config = null;
        if (this._cfg_readerSupportsCommand) {
            FindParamRet testBaudRet = this.helper_testStability(config, 4800);
            if (testBaudRet.isCanceled) {
                return ret;
            }
            if (testBaudRet.config != null) {
                testBaudRet = this.helper_testStability(config, 9600);
                if (testBaudRet.isCanceled) {
                    return ret;
                }
                config.setBaudRate(testBaudRet.config != null ? 9600 : 4800);
                ret.config = config;
                ret.isCanceled = false;
                return ret;
            }
            testBaudRet = this.helper_testStability(config, 2400);
            return testBaudRet;
        }
        FindParamRet testBaudRet = this.helper_testStability(config, 9600);
        return testBaudRet;
    }

    private Boolean helper_isLongCmdSupported() {
        UMLog.i(this.TAG, "helper_isLongCmdSupported 1");
        if (!this._cfg_readerSupportsCommand) {
            return false;
        }
        ReaderInfo.DEVICE_TYPE deviceType = this._taskExport.getReaderType();
        switch (deviceType) {
            case DEVICE_UNIMAG_PRO: 
            case DEVICE_VP3300_AJ: 
            case DEVICE_UNIPAY_I_V: {
                return false;
            }
            case DEVICE_UNIMAG: 
            case DEVICE_UNIPAY: 
            case DEVICE_UNIJACK: {
                return true;
            }
        }
        return false;
    }

    private FindParamRet helper_testStability(StructConfigParameters config, int baud) {
        IOManager.RPDResult r;
        String localTag = "Stability test: ";
        config = config.clone();
        FindParamRet ret = new FindParamRet();
        ret.isCanceled = true;
        ret.config = null;
        this._ioManager.setConfig(config);
        Boolean isLongCmdSupported = this.helper_isLongCmdSupported();
        if (this._cfg_readerSupportsCommand) {
            UMLog.i(this.TAG, "Stability test: for baud: " + baud);
            config.setBaudRate(baud);
            this._ioManager.setConfig(config);
            r = this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG ? this._readerCommunication.sendCommand(Common.makeSetBaudCommand(config), 1.5, this, this) : (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIJACK ? this._readerCommunication.sendCommand(Common.makeSetBaudCommandForUniJack(config), 1.5, this, this) : (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V ? this._readerCommunication.sendCommand(Common.makeSetBaudAndLevelCommand(config, config.getBaudRate()), 1.5, this, this) : this._readerCommunication.sendCommand(Common.makeSetBaudAndLevelCommand(config, config.getBaudRate()), 2.5, this, this)));
            if (r.isCanceledOrFailed()) {
                return ret;
            }
        } else {
            config.setBaudRate(9600);
            this._ioManager.setConfig(config);
            if (this.safeWait(2.0)) {
                return ret;
            }
        }
        for (int k = 1; k <= 3; ++k) {
            UMLog.i(this.TAG, "Stability test: trial " + k);
            short powerupLastBeforeCMD = 200;
            if (this._config != null) {
                powerupLastBeforeCMD = this._config.getPowerupLastBeforeCMD();
            }
            config.setPowerupLastBeforeCMD(powerupLastBeforeCMD);
            this._ioManager.setConfig(config);
            if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG) {
                r = this._readerCommunication.sendCommand(Common.base16Decode("0252200373"), 2.5, this, this);
            } else if (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_AJ || this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIPAY_I_V) {
                String command = Common.packageCommandForVendi("5669564F74656368320018010000B3CD");
                r = this._readerCommunication.sendCommand(Common.getBytesFromHexString(command), 2.0, this, this);
            } else {
                r = this._readerCommunication.sendCommand(Common.makeCommand("7D4600", powerupLastBeforeCMD), 2.0, this, this);
            }
            if (r.isCanceledOrFailed()) {
                return ret;
            }
            boolean parsed = this._cfg_readerSupportsCommand && isLongCmdSupported.booleanValue() ? (this._taskExport.getReaderType() == ReaderInfo.DEVICE_TYPE.DEVICE_UNIMAG ? r.isParsed() && r.matches(this.resp_long_um) : r.isParsed() && r.matches(this.resp_long)) : r.isParsed();
            if (!parsed) {
                UMLog.i(this.TAG, "Stability test: failed");
                ret.config = null;
                ret.isCanceled = false;
                return ret;
            }
            if (!this.safeWait(1.0)) continue;
            return ret;
        }
        UMLog.i(this.TAG, "Stability test: passed");
        ret.config = config;
        ret.isCanceled = false;
        return ret;
    }

    private static void generateModelName(StructConfigParameters config) {
        String profileName = "<outDir=" + config.getDirectionOutputWave() + ",psamp=" + config.getFrequenceOutput() + ",baud=" + config.getBaudRate() + ",rsamp=" + config.getFrequenceInput() + ",vr=" + config.getUseVoiceRecognition() + (config.getShuttleChannel() != 48 ? ",shuttleChannel" : "") + ">";
        config.setModelNumber(profileName);
    }

    private static class FindParamRet {
        public boolean isCanceled;
        public StructConfigParameters config;

        private FindParamRet() {
        }
    }
}

