/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.audiojack.tasks;

import com.idtechproducts.device.Common;
import com.idtechproducts.device.audiojack.ReaderCommunication;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.io.IOManager;
import com.idtechproducts.device.audiojack.tasks.Task;
import com.idtechproducts.device.audiojack.tasks.TaskManager;
import java.util.List;

public class SwipeTask
extends Task {
    private final double _timeoutIntervalSec;
    private byte[] _resp = null;

    public SwipeTask(TaskManager umMan, ReaderCommunication readerCommunication, double timeoutIntervalSec) {
        super(umMan, readerCommunication);
        this._timeoutIntervalSec = timeoutIntervalSec;
    }

    @Override
    public TaskManager.TaskType getType() {
        return TaskManager.TaskType.Swipe;
    }

    @Override
    protected void taskCleanup() {
        if (null != this._ioManager) {
            this._ioManager.notifyTaskFinished();
        }
    }

    @Override
    protected Runnable taskMain() {
        IOManager.RPDResult r = this._readerCommunication.waitResponse(this._timeoutIntervalSec, this, this);
        if (r.isCanceledOrFailed()) {
            return null;
        }
        if (r.isTimedOut()) {
            return new Runnable(){

                @Override
                public void run() {
                    SwipeTask.this._umrMsg.timeout(24);
                }
            };
        }
        return new Runnable(){

            @Override
            public void run() {
                if (SwipeTask.this._resp != null) {
                    UMLog.i(SwipeTask.this.TAG, "Response MSR Data - Runnable");
                    Common.Response.responesMSRData(SwipeTask.this._umrMsg, SwipeTask.this._resp);
                }
            }
        };
    }

    @Override
    public boolean processResponse(List<byte[]> response) {
        boolean stopParsing = this.isResponseValid(response);
        return stopParsing;
    }

    private boolean isResponseValid(List<byte[]> response) {
        for (byte[] respI : response) {
            UMLog.i(this.TAG, "got: " + Common.getByteArrDesc(respI));
            if (respI.length < 2) continue;
            if (Common.PUSType.parse(respI) != Common.PUSType.INVALID) {
                UMLog.i(this.TAG, "ignored PUS");
                continue;
            }
            if (13 == respI[respI.length - 1]) {
                this._resp = respI;
                return true;
            }
            if ((2 == respI[1] || 2 == respI[0]) && 3 == respI[respI.length - 1]) {
                this._resp = respI;
                return true;
            }
            UMLog.i(this.TAG, "ignored ill-formed swipe data");
        }
        return false;
    }

    @Override
    public void processSound() {
        UMLog.i(this.TAG, "swipe detected");
        this.post(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

