/*
 * Decompiled with CFR 0.152.
 */
package com.idtechproducts.device.bluetooth;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.IDTLCDData;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_Device;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.UMLog;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;
import com.idtechproducts.device.bluetooth.BluetoothControllerMsg;
import com.idtechproducts.device.bluetooth.IDTechBluetoothMsg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class BluetoothLEController
extends Activity {
    private static int MAXBUFFERSIZE = 4096;
    public static int device_BLE_Type = 2;
    public static boolean isVP8800 = false;
    private static final UUID SPS_SERVICE = UUID.fromString("00001820-0000-1000-8000-00805f9b34fb");
    private static final UUID SPS_CHARAC = UUID.fromString("00002A80-0000-1000-8000-00805f9b34fb");
    private static final UUID CCC = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private static UUID SERVICE_ISSC_PROPRIETARY = UUID.fromString("49535343-FE7D-4AE5-8FA9-9FAFD205E455");
    private static UUID SERVICE_ISSC_PROPRIETARY_VP3350 = UUID.fromString("0783b03e-8535-b5a0-7140-a304d2495cb7");
    private static UUID CHR_ISSC_READ = UUID.fromString("49535343-1E4D-4BD9-BA61-23C647249616");
    private static UUID CHR_ISSC_READ_VP3350 = UUID.fromString("0783b03e-8535-b5a0-7140-a304d2495cb8");
    private static UUID CHR_ISSC_WRITE = UUID.fromString("49535343-8841-43F4-A8D4-ECBE34729BB3");
    private static UUID CHR_ISSC_WRITE_VP3350 = UUID.fromString("0783b03e-8535-b5a0-7140-a304d2495cba");
    private static UUID CHR_ISSC_WRITE_VP3320 = UUID.fromString("49535343-6DAA-4D02-ABF6-19569ACA69FE");
    private static final int ENABLE_NOTIFICATION_VALUE = 22919;
    private static final int DISABLE_NOTIFICATION_VALUE = 22920;
    private static UUID SERVICE_ISSC_PROPRIETARY_LERD = UUID.fromString("01fffee7-ba5e-f4ee-5ca1-eb1e5e4b1ce0");
    private static UUID CHR_ISSC_READ_LERD = UUID.fromString("01fffec6-ba5e-f4ee-5ca1-eb1e5e4b1ce0");
    private static UUID CHR_ISSC_WRITE_LERD = UUID.fromString("01fffec8-ba5e-f4ee-5ca1-eb1e5e4b1ce0");
    private static UUID SERVICE_ISSC_PROPRIETARY_LERD_VP6800 = UUID.fromString("0000A002-0000-1000-8000-00805F9B34FB");
    private static UUID CHR_ISSC_READ_LERD_VP6800 = UUID.fromString("0000C306-0000-1000-8000-00805F9B34FB");
    private static UUID CHR_ISSC_WRITE_LERD_VP6800 = UUID.fromString("0000C304-0000-1000-8000-00805F9B34FB");
    private static UUID SPS_FLOW_CTRL_UUID = UUID.fromString("B95C49D2-04A3-4071-A0B5-35853EB08307");
    private static UUID SPS_SERVER_RX_UUID = UUID.fromString("BA5C49D2-04A3-4071-A0B5-35853EB08307");
    private static UUID SPS_SERVER_TX_UUID = UUID.fromString("B85C49D2-04A3-4071-A0B5-35853EB08307");
    int LEN_SLICE = 517;
    private static final String TAG = "BTLE_Controller";
    private static BluetoothDevice btleDevice = null;
    private static boolean connection = false;
    private Context ctx = null;
    private static IDTechBluetoothMsg _msg = null;
    private BluetoothControllerMsg _btMsg = null;
    private CheckDeviceThread checkThread;
    private BroadcastReceiver btleReceiver = null;
    private listenForDataOnThread listenThread;
    private static boolean btleEnabled = false;
    private int swipeTimeoutSec;
    private SwipeDataReceiver swipeThread;
    private byte[] swipeBuffer;
    private BluetoothGatt mGatt = null;
    private Object mutexNotifyDataReady = new Object();
    private List<byte[]> responseResults = new ArrayList<byte[]>();
    private List<byte[]> responseFrame = new ArrayList<byte[]>();
    private BluetoothGattCharacteristic characteristic = null;
    private boolean dataAvailable = false;
    private Object mutexNotifyConnection = new Object();
    private BluetoothGattService proprietary = null;
    private BluetoothGattCharacteristic mTransRead = null;
    private BluetoothGattCharacteristic mTransWrite = null;
    private Runnable enableNotifyHandler = new Runnable(){

        @Override
        public void run() {
            Log.i((String)BluetoothLEController.TAG, (String)"@@ delayed to enableNotification");
            BluetoothLEController.this.enableNotification();
            BluetoothLEController.this.connectionDone();
        }
    };
    private BroadcastReceiver BluetoothStateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction()) && intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1) == 10) {
                Log.e((String)"BluetoothStateReceiver", (String)"STATE_DISCONNECTED");
                connection = false;
                UMLog.i("BluetoothStateReceiver", "device_BLE_Type: " + device_BLE_Type + " btleFirstConnect: " + IDT_Device.btleFirstConnect + " btleFirstBypass: " + IDT_Device.btleFirstBypass);
                _msg.bt_onReceiveMsgDisconnected();
                if (BluetoothLEController.this.mGatt != null) {
                    BluetoothLEController.this.mGatt.close();
                    BluetoothLEController.this.mGatt = null;
                }
            }
        }
    };
    boolean characteristicChanged = false;
    private final BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            Log.d((String)"---BLE", (String)("onMtuChanged mtu=" + mtu + ",status=" + status));
            if (0 == status) {
                Log.e((String)"---tt", (String)"set MTU OK");
                BluetoothLEController.this.LEN_SLICE = mtu > 200 ? 200 : mtu;
                Log.d((String)"---BLE", (String)("Will Use mtu=" + BluetoothLEController.this.LEN_SLICE));
            }
        }

        public void onConnectionStateChange(final BluetoothGatt gatt, final int status, final int newState) {
            super.onConnectionStateChange(gatt, status, newState);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Log.i((String)"onConnectionStateChange", (String)("Status: " + status));
                    switch (newState) {
                        case 2: {
                            Log.i((String)"gattCallback", (String)"STATE_CONNECTED");
                            if (device_BLE_Type == 2) {
                                BluetoothLEController.this.setMTU(BluetoothLEController.this.LEN_SLICE);
                            }
                            connection = false;
                            BluetoothLEController.this.isConnectionDone = false;
                            gatt.discoverServices();
                            BluetoothLEController.this.responseResults.clear();
                            break;
                        }
                        case 0: {
                            Log.e((String)"gattCallback", (String)"STATE_DISCONNECTED");
                            UMLog.i("gattCallback", "device_BLE_Type: " + device_BLE_Type + " btleFirstConnect: " + IDT_Device.btleFirstConnect + " btleFirstBypass: " + IDT_Device.btleFirstBypass);
                            if ((device_BLE_Type == 1 && !IDT_Device.btleFirstConnect && !IDT_Device.btleFirstBypass || device_BLE_Type == 2) && connection) {
                                _msg.bt_onReceiveMsgDisconnected();
                            }
                            connection = false;
                            if (BluetoothLEController.this.mGatt != null) {
                                BluetoothLEController.this.mGatt.close();
                                BluetoothLEController.this.mGatt = null;
                            }
                            if (IDT_Device.btleFirstBypass) {
                                boolean bFindPairedDevice = false;
                                BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                                Set pairedDevices = mBluetoothAdapter.getBondedDevices();
                                if (btleDevice == null) {
                                    return;
                                }
                                String target = btleDevice.getName();
                                if (target == null) {
                                    target = "";
                                }
                                for (BluetoothDevice bt : pairedDevices) {
                                    try {
                                        if (bt == null || bt.getName() == null || !bt.getName().equals(target)) continue;
                                        bFindPairedDevice = true;
                                    }
                                    catch (Exception exception) {}
                                }
                                if (!bFindPairedDevice) break;
                                IDT_Device.btleFirstBypass = false;
                                BluetoothLEController.this.connectToDevice(btleDevice);
                                break;
                            }
                            if (isVP8800) break;
                            BluetoothLEController.this.connectToDevice(btleDevice);
                            break;
                        }
                        default: {
                            Log.e((String)"gattCallback", (String)"STATE_OTHER");
                        }
                    }
                }
            }).start();
        }

        public void onServicesDiscovered(final BluetoothGatt gatt, final int status) {
            super.onServicesDiscovered(gatt, status);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (device_BLE_Type == 1) {
                        List services = gatt.getServices();
                        Log.i((String)"onServicesDiscovered", (String)services.toString());
                        boolean done = false;
                        for (BluetoothGattService service : services) {
                            BluetoothLEController.this.characteristic = service.getCharacteristic(SPS_CHARAC);
                            if (BluetoothLEController.this.characteristic == null) continue;
                            Log.i((String)BluetoothLEController.TAG, (String)"##Got characteristic");
                            boolean ret = BluetoothLEController.this.mGatt.setCharacteristicNotification(BluetoothLEController.this.characteristic, true);
                            if (!ret) {
                                Log.i((String)BluetoothLEController.TAG, (String)"##Could not set characteristic");
                                continue;
                            }
                            BluetoothGattDescriptor descriptor = BluetoothLEController.this.characteristic.getDescriptor(CCC);
                            descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                            ret = BluetoothLEController.this.mGatt.writeDescriptor(descriptor);
                            if (!ret) break;
                            done = true;
                            break;
                        }
                        if (BluetoothLEController.this.characteristic == null) {
                            Log.i((String)BluetoothLEController.TAG, (String)"##Could not get characteristic");
                        }
                        if (done) {
                            BluetoothLEController.this.connectionDone();
                        }
                        if (IDT_Device.btleFirstConnect) {
                            IDT_Device.btleFirstConnect = false;
                        } else {
                            IDT_Device.btleReConnect = true;
                            _msg.bt_onReceiveMsgConnected();
                        }
                    } else if (device_BLE_Type == 2) {
                        boolean bFlag = false;
                        Log.i((String)"@@@@onServicesDiscovered", (String)("Status: " + status));
                        if (status == 0) {
                            int type = 0;
                            if (BluetoothLEController.this.proprietary == null) {
                                BluetoothLEController.this.proprietary = BluetoothLEController.this.mGatt.getService(SERVICE_ISSC_PROPRIETARY);
                                if (BluetoothLEController.this.proprietary != null) {
                                    type = 1;
                                }
                            }
                            if (BluetoothLEController.this.proprietary == null) {
                                BluetoothLEController.this.proprietary = BluetoothLEController.this.mGatt.getService(SERVICE_ISSC_PROPRIETARY_VP3350);
                                if (BluetoothLEController.this.proprietary != null) {
                                    type = 2;
                                }
                            }
                            if (BluetoothLEController.this.proprietary == null) {
                                BluetoothLEController.this.proprietary = BluetoothLEController.this.mGatt.getService(SERVICE_ISSC_PROPRIETARY_LERD);
                                if (BluetoothLEController.this.proprietary != null) {
                                    type = 3;
                                }
                            }
                            if (BluetoothLEController.this.proprietary == null) {
                                BluetoothLEController.this.proprietary = BluetoothLEController.this.mGatt.getService(SERVICE_ISSC_PROPRIETARY_LERD_VP6800);
                                if (BluetoothLEController.this.proprietary != null) {
                                    type = 4;
                                }
                            }
                            if (BluetoothLEController.this.proprietary == null) {
                                BluetoothLEController.this.proprietary = BluetoothLEController.this.mGatt.getService(SPS_FLOW_CTRL_UUID);
                                if (BluetoothLEController.this.proprietary != null) {
                                    type = 5;
                                }
                            }
                            if (BluetoothLEController.this.proprietary != null) {
                                if (type == 1) {
                                    if (BluetoothLEController.this.mTransWrite == null) {
                                        BluetoothLEController.this.mTransWrite = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_WRITE_VP3320);
                                    }
                                    if (BluetoothLEController.this.mTransWrite == null) {
                                        BluetoothLEController.this.mTransWrite = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_WRITE);
                                    }
                                    if (BluetoothLEController.this.mTransRead == null) {
                                        BluetoothLEController.this.mTransRead = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_READ);
                                    }
                                } else if (type == 2) {
                                    if (BluetoothLEController.this.mTransWrite == null) {
                                        BluetoothLEController.this.mTransWrite = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_WRITE_VP3350);
                                    }
                                    if (BluetoothLEController.this.mTransRead == null) {
                                        BluetoothLEController.this.mTransRead = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_READ_VP3350);
                                    }
                                } else if (type == 3) {
                                    if (BluetoothLEController.this.mTransWrite == null) {
                                        BluetoothLEController.this.mTransWrite = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_WRITE_LERD);
                                    }
                                    if (BluetoothLEController.this.mTransRead == null) {
                                        BluetoothLEController.this.mTransRead = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_READ_LERD);
                                    }
                                } else if (type == 4) {
                                    if (BluetoothLEController.this.mTransWrite == null) {
                                        BluetoothLEController.this.mTransWrite = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_WRITE_LERD_VP6800);
                                    }
                                    if (BluetoothLEController.this.mTransRead == null) {
                                        BluetoothLEController.this.mTransRead = BluetoothLEController.this.proprietary.getCharacteristic(CHR_ISSC_READ_LERD_VP6800);
                                    }
                                } else if (type == 5) {
                                    if (BluetoothLEController.this.mTransWrite == null) {
                                        BluetoothLEController.this.mTransWrite = BluetoothLEController.this.proprietary.getCharacteristic(SPS_SERVER_TX_UUID);
                                    }
                                    if (BluetoothLEController.this.mTransRead == null) {
                                        BluetoothLEController.this.mTransRead = BluetoothLEController.this.proprietary.getCharacteristic(SPS_SERVER_RX_UUID);
                                    }
                                }
                                Log.i((String)BluetoothLEController.TAG, (String)String.format("@@found Tx:%b, Rx:%b, ", BluetoothLEController.this.mTransWrite != null, BluetoothLEController.this.mTransRead != null));
                                if (BluetoothLEController.this.mTransRead != null && BluetoothLEController.this.mTransWrite != null) {
                                    try {
                                        Thread.sleep(500L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    BluetoothLEController.this.enableNotification();
                                    BluetoothLEController.this.connectionDone();
                                    if (IDT_Device.btleFirstConnect) {
                                        IDT_Device.btleFirstBypass = true;
                                        IDT_Device.btleFirstConnect = false;
                                    } else {
                                        if (BluetoothLEController.this.mGatt == null) {
                                            BluetoothLEController.this.proprietary = null;
                                            BluetoothLEController.this.mTransWrite = null;
                                            BluetoothLEController.this.mTransRead = null;
                                            return;
                                        }
                                        IDT_Device.btleReConnect = true;
                                        _msg.bt_onReceiveMsgConnected();
                                    }
                                }
                            } else {
                                Log.i((String)BluetoothLEController.TAG, (String)"Could not get characteristic");
                            }
                        }
                    }
                }
            }).start();
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            Log.i((String)BluetoothLEController.TAG, (String)("##Write = " + Common.getHexStringFromBytes(characteristic.getValue())));
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.i((String)BluetoothLEController.TAG, (String)("onDescriptorWrite " + status));
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            Log.i((String)BluetoothLEController.TAG, (String)("##Read = " + Common.getHexStringFromBytes(characteristic.getValue())));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            if (characteristic.getValue() == null) {
                Log.i((String)BluetoothLEController.TAG, (String)"##Data Received from BLE = NULL");
            } else {
                Log.i((String)BluetoothLEController.TAG, (String)("##Data Received from BLE = " + Common.getHexStringFromBytes(characteristic.getValue())));
            }
            3 var3_3 = this;
            synchronized (var3_3) {
                byte[] value = characteristic.getValue();
                if (value == null) {
                    Log.i((String)BluetoothLEController.TAG, (String)"## DATA Null - Exiting routine");
                    return;
                }
                if (value.length == 0) {
                    Log.i((String)BluetoothLEController.TAG, (String)"## DATA Length = 0 - Exiting routine");
                    return;
                }
                if (device_BLE_Type == 2 && value.length > 3 && value[0] == 86 && value[1] == 105 && value[2] == 86) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                BluetoothLEController.this.characteristicChanged = true;
                try {
                    Thread.sleep(15L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Log.i((String)BluetoothLEController.TAG, (String)("## Adding data to buffer = " + Common.getHexStringFromBytes(value)));
                BluetoothLEController.this.addReceivedData(value);
            }
        }
    };
    boolean startFrame = false;
    byte[] resData;
    boolean isConnectionDone = false;
    private boolean registered = false;
    private boolean cancelFlag = false;
    boolean inLoop = false;
    private static final int WRITE_TYPE_DEFAULT = 2;

    public BluetoothLEController(Context context, IDTechBluetoothMsg msg, BluetoothControllerMsg msg2) {
        this.ctx = context;
        _msg = msg;
        this._btMsg = msg2;
        this.swipeBuffer = new byte[1024];
        this.swipeTimeoutSec = 200;
    }

    private static boolean isBTEnabled() {
        return btleEnabled;
    }

    public boolean isConnected() {
        return connection;
    }

    public void setConnected(boolean connected) {
        connection = connected;
    }

    public static void setBluetoothDevice(BluetoothDevice btleDev) {
        btleDevice = btleDev;
    }

    public static BluetoothDevice getBluetoothDevice() {
        return btleDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initWithThread() {
        if (connection) {
            return true;
        }
        if (btleDevice == null) {
            return false;
        }
        this.connectToDevice(btleDevice);
        if (this.mutexNotifyConnection != null) {
            Object object = this.mutexNotifyConnection;
            synchronized (object) {
                try {
                    int i;
                    for (i = 0; i < 100; ++i) {
                        this.mutexNotifyConnection.wait(100L);
                        if (connection) break;
                    }
                    if (i == 100) {
                        return false;
                    }
                }
                catch (InterruptedException ie) {
                    return false;
                }
            }
        }
        return true;
    }

    private void enableNotification() {
        Log.i((String)TAG, (String)"##enableNotification");
        boolean set = false;
        if (this.mGatt == null) {
            Log.i((String)TAG, (String)("mGatt == null, set mTransRead notification: " + set));
            return;
        }
        set = this.mGatt.setCharacteristicNotification(this.mTransRead, true);
        Log.i((String)TAG, (String)("set mTransRead notification: " + set));
        for (BluetoothGattDescriptor dp : this.mTransRead.getDescriptors()) {
            dp.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            boolean success = this.mGatt.writeDescriptor(dp);
            Log.i((String)TAG, (String)("writing enable descriptor: " + success));
        }
    }

    private void connectToDevice(BluetoothDevice device) {
        if (this.mGatt == null && device != null) {
            IDT_Device.context.registerReceiver(this.BluetoothStateReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
            this.mGatt = device.connectGatt(this.ctx, false, this.gattCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addReceivedData(byte[] response) {
        if (this.mutexNotifyDataReady != null) {
            if (response == null || this.responseResults == null) {
                return true;
            }
            Object object = this.mutexNotifyDataReady;
            synchronized (object) {
                int i;
                this.responseResults.add(response);
                int size = this.responseResults.size();
                int totalCount = 0;
                for (i = 0; i < size; ++i) {
                    totalCount += this.responseResults.get(i).length;
                }
                this.resData = new byte[totalCount];
                totalCount = 0;
                for (i = 0; i < size; ++i) {
                    System.arraycopy(this.responseResults.get(i), 0, this.resData, totalCount, this.responseResults.get(i).length);
                    totalCount += this.responseResults.get(i).length;
                }
                if (totalCount >= 14 && this.resData[0] == 86) {
                    int dataLen = (this.resData[12] & 0xFF) << 8 | this.resData[13] & 0xFF;
                    int framelLen = 14 + dataLen + 2;
                    Log.d((String)TAG, (String)("## totalCount = " + totalCount + " , frameLen = " + framelLen + " dataLen = " + dataLen));
                    if (totalCount >= framelLen) {
                        if (totalCount == framelLen) {
                            this.responseFrame.add(this.resData);
                            this.responseResults.clear();
                            Log.d((String)TAG, (String)"## ---notifyAll=-----##");
                            this.dataAvailable = true;
                            this.mutexNotifyDataReady.notifyAll();
                        } else {
                            byte[] frameData = new byte[framelLen];
                            System.arraycopy(this.resData, 0, frameData, 0, framelLen);
                            this.responseFrame.add(frameData);
                            int redundantLen = totalCount - framelLen;
                            byte[] redundant = new byte[redundantLen];
                            System.arraycopy(this.resData, framelLen, redundant, 0, redundantLen);
                            this.responseFrame.add(redundant);
                            this.responseResults.clear();
                            Log.d((String)TAG, (String)"## ---notifyAll>-----##");
                            this.dataAvailable = true;
                            this.mutexNotifyDataReady.notifyAll();
                        }
                    }
                } else {
                    this.characteristicChanged = false;
                    listenForBLEDataOnThread listenThread = new listenForBLEDataOnThread();
                    listenThread.start();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionDone() {
        if (this.mutexNotifyConnection != null) {
            Object object = this.mutexNotifyConnection;
            synchronized (object) {
                connection = true;
                this.isConnectionDone = true;
                this.mutexNotifyConnection.notifyAll();
            }
        }
    }

    public void startCheckingConnection() {
        UMLog.i(TAG, "SDK starts monitoring if reader is connected.");
        this.checkThread = new CheckDeviceThread();
        this.checkThread.start();
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered(boolean isRegistered) {
        this.registered = isRegistered;
    }

    @SuppressLint(value={"InlinedApi"})
    public void registerReceiver() {
        UMLog.i(TAG, "Register a Broadcast receiver to get BluetoothDevice.ACTION_FOUND.");
        this.btleReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (!"android.bluetooth.device.action.FOUND".equals(action)) {
                    if ("android.bluetooth.device.action.ACL_CONNECTED".equals(action)) {
                        while (!BluetoothLEController.this.isConnectionDone) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        _msg.bt_onReceiveMsgConnected();
                    } else if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(action)) {
                        connection = false;
                        BluetoothLEController.this.isConnectionDone = false;
                        _msg.bt_onReceiveMsgDisconnected();
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        this.ctx.registerReceiver(this.btleReceiver, filter);
        this.registered = true;
    }

    public void registerReceiver(Handler scheduler) {
        UMLog.i(TAG, "Register a Broadcast receiver to get BluetoothDevice.ACTION_FOUND.");
        this.btleReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (!"android.bluetooth.device.action.FOUND".equals(action)) {
                    if ("android.bluetooth.device.action.ACL_CONNECTED".equals(action)) {
                        while (!BluetoothLEController.this.isConnectionDone) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        _msg.bt_onReceiveMsgConnected();
                    } else if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(action)) {
                        connection = false;
                        BluetoothLEController.this.isConnectionDone = false;
                        _msg.bt_onReceiveMsgDisconnected();
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        this.ctx.registerReceiver(this.btleReceiver, filter, null, scheduler);
        this.registered = true;
    }

    public void unregisterReceiver() {
        UMLog.i(TAG, "A Broadcast receiver unregistered.");
        this.ctx.unregisterReceiver(this.btleReceiver);
        this.close();
        this.registered = false;
    }

    public boolean enableSwipe() {
        return connection;
    }

    public boolean enableListen() {
        if (!connection) {
            return false;
        }
        UMLog.i(TAG, "SDK starts listening card data from reader.");
        this.listenThread = new listenForDataOnThread();
        this.listenThread.isRunning = true;
        this.listenThread.start();
        return true;
    }

    public boolean disableListen() {
        if (this.listenThread == null) {
            return false;
        }
        this.listenThread.isRunning = false;
        return true;
    }

    public boolean enableRead(int timeout, ResDataStruct respData) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read_autoPoll(byte[] buff) {
        if (this.mutexNotifyDataReady != null) {
            Object object = this.mutexNotifyDataReady;
            synchronized (object) {
                try {
                    int i;
                    this.mutexNotifyDataReady.wait(400L);
                    if (IDT_Device.isBurstModeOn && IDT_Device.isAutoPollOn && IDT_Device.isCommandRunning) {
                        return 0;
                    }
                    if (!this.dataAvailable) {
                        return 0;
                    }
                    this.dataAvailable = false;
                    if (this.responseFrame.size() <= 0) {
                        Log.i((String)TAG, (String)"## Auto Poll No Resp ");
                        return 0;
                    }
                    int size = this.responseFrame.size();
                    int totalCount = 0;
                    for (i = size - 1; i < size; ++i) {
                        totalCount += this.responseFrame.get(i).length;
                    }
                    totalCount = 0;
                    for (i = size - 1; i < size; ++i) {
                        System.arraycopy(this.responseFrame.get(i), 0, buff, totalCount, this.responseFrame.get(i).length);
                        totalCount += this.responseFrame.get(i).length;
                    }
                    this.responseFrame.clear();
                    Log.i((String)TAG, (String)("## Auto Poll Resp = " + Common.getHexStringFromBytes(buff)));
                    return totalCount;
                }
                catch (InterruptedException ie) {
                    return 0;
                }
            }
        }
        return 0;
    }

    private boolean readMessage_old(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        if (!connection) {
            return false;
        }
        this.dataAvailable = false;
        respData.resData = new byte[]{0};
        byte[] buff = new byte[MAXBUFFERSIZE];
        int res = 0;
        long timelimit = (long)(timeout * 1000) - (System.currentTimeMillis() - startTime);
        this.responseFrame.clear();
        if (ignoreLCDMsg && Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            int idx;
            while (true) {
                if ((timelimit = (long)(timeout * 1000) - (System.currentTimeMillis() - startTime)) <= 0L) {
                    return false;
                }
                if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                    IDT_Device.isTransactionRead = false;
                    IDT_Device.cancelTransaction = false;
                    Log.i((String)TAG, (String)"## Transaction Cancelled ");
                    return true;
                }
                res = this.read(buff, timelimit);
                if (res == -1) {
                    return true;
                }
                if (res <= 0) continue;
                idx = 0;
                while (res - idx > 13 && buff[10 + idx] == 97 && buff[11 + idx] == 1) {
                    int dataLen = (buff[12 + idx] & 0xFF) << 8 | buff[13 + idx] & 0xFF;
                    byte[] theData = new byte[dataLen + 16];
                    System.arraycopy(buff, idx, theData, 0, theData.length);
                    _msg.bt_onReceiveMsgLCD(theData);
                    idx += dataLen + 16;
                }
                if (res != idx) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                res = 0;
            }
            respData.resData = null;
            if (res - idx > 0) {
                respData.resData = new byte[res - idx];
                System.arraycopy(buff, idx, respData.resData, 0, respData.resData.length);
                UMLog.i("**BLE getResponse 1**", Common.base16Encode(respData.resData));
                _msg.bt_onReceiveMsgGetResponse(respData.resData);
                return true;
            }
            return false;
        }
        res = this.read(buff, timelimit);
        if (res == -1) {
            return true;
        }
        if (res > 0) {
            respData.resData = null;
            respData.resData = new byte[res];
            System.arraycopy(buff, 0, respData.resData, 0, res);
            UMLog.i("**BLE getResponse 2**", Common.base16Encode(respData.resData));
            _msg.bt_onReceiveMsgGetResponse(respData.resData);
            return true;
        }
        return false;
    }

    public boolean readMessage(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        int idx;
        if (!connection) {
            return false;
        }
        this.dataAvailable = false;
        respData.resData = new byte[]{0};
        byte[] buff = new byte[MAXBUFFERSIZE];
        int res = 0;
        long timelimit = (long)(timeout * 1000) - (System.currentTimeMillis() - startTime);
        this.responseFrame.clear();
        while (true) {
            if ((timelimit = (long)(timeout * 1000) - (System.currentTimeMillis() - startTime)) <= 0L) {
                return false;
            }
            if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                IDT_Device.isTransactionRead = false;
                IDT_Device.cancelTransaction = false;
                Log.i((String)TAG, (String)"## Transaction Cancelled ");
                return true;
            }
            res = this.read(buff, timelimit);
            if (res == -1) {
                return true;
            }
            if (res <= 0) continue;
            idx = 0;
            while (res - idx > 13 && buff[10 + idx] == 97 && (buff[11 + idx] == 1 || buff[11 + idx] == -1)) {
                int dataLen = (buff[12 + idx] & 0xFF) << 8 | buff[13 + idx] & 0xFF;
                if (buff[11 + idx] == 1) {
                    if (!ignoreLCDMsg) {
                        byte[] theData = new byte[dataLen + 16];
                        System.arraycopy(buff, idx, theData, 0, theData.length);
                        UMLog.i("**readMessage**", "before bt_onReceiveMsgLCD 1");
                        _msg.bt_onReceiveMsgLCD(theData);
                    }
                } else if (res - idx > 20 && buff[11 + idx] == -1) {
                    IDTLCDData lcdData = new IDTLCDData();
                    lcdData.screenID = buff[14 + idx] << 8 | buff[15 + idx];
                    lcdData.objectID = buff[16 + idx] << 8 | buff[17 + idx];
                    int chIdx = 18 + idx;
                    while (buff[chIdx] != 0) {
                        ++chIdx;
                    }
                    byte[] bytes = new byte[chIdx - (18 + idx)];
                    System.arraycopy(buff, 18 + idx, bytes, 0, bytes.length);
                    lcdData.screenName = new String(bytes);
                    int chIdx2 = ++chIdx;
                    while (buff[chIdx] != 0) {
                        ++chIdx;
                    }
                    bytes = new byte[chIdx - chIdx2];
                    System.arraycopy(buff, chIdx2, bytes, 0, bytes.length);
                    lcdData.objectName = new String(bytes);
                    if (dataLen > 4 + lcdData.screenName.length() + 1 + lcdData.objectName.length() + 1) {
                        lcdData.longPressed = buff[20 + idx + lcdData.screenName.length() + lcdData.objectName.length()];
                    }
                    UMLog.i("**readMessage**", "before bt_onReceiveMsgLCD 2");
                    _msg.bt_onReceiveMsgLcdData(lcdData);
                }
                idx += dataLen + 16;
            }
            if (res != idx) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            res = 0;
        }
        respData.resData = null;
        if (res - idx > 0) {
            respData.resData = new byte[res - idx];
            System.arraycopy(buff, idx, respData.resData, 0, respData.resData.length);
            UMLog.i("**BLE getResponse readMessage 3**", Common.base16Encode(respData.resData));
            _msg.bt_onReceiveMsgGetResponse(respData.resData);
            return true;
        }
        return false;
    }

    public boolean emv_readMessage(int timeout, long startTime, ResDataStruct respData, boolean ignoreLCDMsg) {
        int idx;
        if (!connection) {
            return false;
        }
        this.dataAvailable = false;
        respData.resData = new byte[]{0};
        byte[] buff = new byte[MAXBUFFERSIZE];
        int res = 0;
        long timelimit = (long)(timeout * 1000) - (System.currentTimeMillis() - startTime);
        this.responseFrame.clear();
        while (true) {
            if ((timelimit = (long)(timeout * 1000) - (System.currentTimeMillis() - startTime)) <= 0L && !IDT_Device.infiniteTimeout) {
                return false;
            }
            if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                IDT_Device.isTransactionRead = false;
                IDT_Device.cancelTransaction = false;
                Log.i((String)TAG, (String)"## Transaction Cancelled ");
                return true;
            }
            res = this.read(buff, timelimit);
            UMLog.i("**new emv_readMessage**", "res: " + res);
            if (res > 0) {
                byte[] temp = new byte[res];
                System.arraycopy(buff, 0, temp, 0, res);
                UMLog.i("**new emv_readMessage**", "temp: " + Common.base16Encode(temp));
            }
            if (res == -1) {
                return true;
            }
            if (res <= 0) continue;
            idx = 0;
            respData.ret = 0;
            respData.statusCode = 0;
            while (res - idx > 13 && buff[10 + idx] == 97 && (buff[11 + idx] == 1 || buff[11 + idx] == -1)) {
                int dataLen = (buff[12 + idx] & 0xFF) << 8 | buff[13 + idx] & 0xFF;
                if (buff[11 + idx] == 1) {
                    if (!ignoreLCDMsg) {
                        while (res - idx > 13 && buff[10 + idx] == 97 && (buff[11 + idx] == 1 || buff[11 + idx] == -1)) {
                            ++respData.ret;
                            dataLen = (buff[12 + idx] & 0xFF) << 8 | buff[13 + idx] & 0xFF;
                            idx += dataLen + 16;
                        }
                        if (res > idx) {
                            respData.statusCode = 1;
                        }
                        respData.resData = new byte[res];
                        System.arraycopy(buff, 0, respData.resData, 0, res);
                        UMLog.i("**readMessage respData.ret**", "(LCD count) " + respData.ret);
                        UMLog.i("**readMessage LCD Messages**", Common.base16Encode(respData.resData));
                        UMLog.i("**readMessage respData.statusCode**", "(Card Data Exist) " + respData.statusCode);
                        return true;
                    }
                } else if (res - idx > 20 && buff[11 + idx] == -1) {
                    IDTLCDData lcdData = new IDTLCDData();
                    lcdData.screenID = buff[14 + idx] << 8 | buff[15 + idx];
                    lcdData.objectID = buff[16 + idx] << 8 | buff[17 + idx];
                    int chIdx = 18 + idx;
                    while (buff[chIdx] != 0) {
                        ++chIdx;
                    }
                    byte[] bytes = new byte[chIdx - (18 + idx)];
                    System.arraycopy(buff, 18 + idx, bytes, 0, bytes.length);
                    lcdData.screenName = new String(bytes);
                    int chIdx2 = ++chIdx;
                    while (buff[chIdx] != 0) {
                        ++chIdx;
                    }
                    bytes = new byte[chIdx - chIdx2];
                    System.arraycopy(buff, chIdx2, bytes, 0, bytes.length);
                    lcdData.objectName = new String(bytes);
                    if (dataLen > 4 + lcdData.screenName.length() + 1 + lcdData.objectName.length() + 1) {
                        lcdData.longPressed = buff[20 + idx + lcdData.screenName.length() + lcdData.objectName.length()];
                    }
                    UMLog.i("**emv_readMessage**", "before bt_onReceiveMsgLcdData");
                    _msg.bt_onReceiveMsgLcdData(lcdData);
                }
                idx += dataLen + 16;
            }
            if (res != idx) break;
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            res = 0;
        }
        respData.resData = null;
        if (res - idx > 0) {
            respData.resData = new byte[res - idx];
            System.arraycopy(buff, idx, respData.resData, 0, respData.resData.length);
            UMLog.i("**BLE getResponse readMessage 4**", Common.base16Encode(respData.resData));
            _msg.bt_onReceiveMsgGetResponse(respData.resData);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read(byte[] buff, long timeLimit) {
        if (this.mutexNotifyDataReady != null) {
            Object object = this.mutexNotifyDataReady;
            synchronized (object) {
                try {
                    int i;
                    long times = timeLimit / 20L;
                    if (timeLimit % 20L != 0L) {
                        ++times;
                    }
                    if (times < 1L) {
                        times = 1L;
                    }
                    for (long i2 = 0L; i2 < times || IDT_Device.infiniteTimeout; ++i2) {
                        if (this.cancelFlag) {
                            this.cancelFlag = false;
                            this.writeRXCharacteristic_try3times(Common.grsiP2Command((byte)5, (byte)1, new byte[0]));
                        }
                        if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                                IDT_Device.isTransactionRead = false;
                                IDT_Device.cancelTransaction = false;
                            }
                            Log.i((String)TAG, (String)"## Transaction Cancelled ");
                            return -1;
                        }
                        this.mutexNotifyDataReady.wait(20L);
                        if (!this.dataAvailable) continue;
                        this.dataAvailable = false;
                        break;
                    }
                    if (this.responseFrame.size() <= 0) {
                        Log.i((String)TAG, (String)"## No Resp 1");
                        return 0;
                    }
                    int size = this.responseFrame.size();
                    int totalCount = 0;
                    for (i = 0; i < size; ++i) {
                        totalCount += this.responseFrame.get(i).length;
                    }
                    totalCount = 0;
                    for (i = 0; i < size; ++i) {
                        System.arraycopy(this.responseFrame.get(i), 0, buff, totalCount, this.responseFrame.get(i).length);
                        totalCount += this.responseFrame.get(i).length;
                    }
                    while (totalCount > 3 && (buff[0] == 2 && buff[1] == 2 && buff[2] == 91 && buff[3] == 47 || buff[0] == 2 && buff[1] == 3 && buff[2] == 75 && buff[3] == 14)) {
                        byte[] temp;
                        if (totalCount > 3 && buff[0] == 2 && buff[1] == 2 && buff[2] == 91 && buff[3] == 47) {
                            IDTMSRData card = new IDTMSRData();
                            card.result = 61093;
                            _msg.bt_onReceiveMsgCardData(card);
                            if ((totalCount -= 4) <= 0) {
                                Arrays.fill(buff, (byte)0);
                                return 0;
                            }
                            temp = new byte[totalCount];
                            System.arraycopy(buff, 4, temp, 0, totalCount);
                            Arrays.fill(buff, (byte)0);
                            System.arraycopy(temp, 0, buff, 0, totalCount);
                            continue;
                        }
                        if (totalCount <= 3 || buff[0] != 2 || buff[1] != 3 || buff[2] != 75 || buff[3] != 14) continue;
                        IDTMSRData card = new IDTMSRData();
                        card.result = 61094;
                        _msg.bt_onReceiveMsgCardData(card);
                        if ((totalCount -= 4) <= 0) {
                            Arrays.fill(buff, (byte)0);
                            return 0;
                        }
                        temp = new byte[totalCount];
                        System.arraycopy(buff, 4, temp, 0, totalCount);
                        Arrays.fill(buff, (byte)0);
                        System.arraycopy(temp, 0, buff, 0, totalCount);
                    }
                    this.responseFrame.clear();
                    return totalCount;
                }
                catch (InterruptedException ie) {
                    return 0;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read_idg(byte[] buff, long timeLimit) {
        if (this.mutexNotifyDataReady != null) {
            Object object = this.mutexNotifyDataReady;
            synchronized (object) {
                try {
                    int i;
                    long times = timeLimit / (long)(device_BLE_Type == 1 ? 100 : 20);
                    if (timeLimit % (long)(device_BLE_Type == 1 ? 100 : 20) != 0L) {
                        ++times;
                    }
                    if (times < 1L) {
                        times = 1L;
                    }
                    for (long i2 = 0L; i2 < times; ++i2) {
                        if (this.cancelFlag) {
                            this.cancelFlag = false;
                            this.writeRXCharacteristic_try3times(Common.grsiP2Command((byte)5, (byte)1, new byte[0]));
                        }
                        if (IDT_Device.isTransactionRead && (IDT_Device.emvCancelTransaction || IDT_Device.cancelTransaction)) {
                            if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                                IDT_Device.isTransactionRead = false;
                                IDT_Device.cancelTransaction = false;
                            }
                            Log.i((String)TAG, (String)"## Transaction Cancelled ");
                            return -1;
                        }
                        this.mutexNotifyDataReady.wait(device_BLE_Type == 1 ? 100 : 20);
                        if (!this.dataAvailable) continue;
                        this.dataAvailable = false;
                        break;
                    }
                    if (this.responseFrame.size() <= 0) {
                        Log.i((String)TAG, (String)"## No Resp 2");
                        return 0;
                    }
                    int size = this.responseFrame.size();
                    int totalCount = 0;
                    for (i = 0; i < size; ++i) {
                        totalCount += this.responseFrame.get(i).length;
                    }
                    totalCount = 0;
                    for (i = 0; i < size; ++i) {
                        System.arraycopy(this.responseFrame.get(i), 0, buff, totalCount, this.responseFrame.get(i).length);
                        totalCount += this.responseFrame.get(i).length;
                    }
                    while (totalCount > 3 && (buff[0] == 2 && buff[1] == 2 && buff[2] == 91 && buff[3] == 47 || buff[0] == 2 && buff[1] == 3 && buff[2] == 75 && buff[3] == 14)) {
                        byte[] temp;
                        if (totalCount > 3 && buff[0] == 2 && buff[1] == 2 && buff[2] == 91 && buff[3] == 47) {
                            IDTMSRData card = new IDTMSRData();
                            card.result = 61093;
                            _msg.bt_onReceiveMsgCardData(card);
                            if ((totalCount -= 4) <= 0) {
                                Arrays.fill(buff, (byte)0);
                                return 0;
                            }
                            temp = new byte[totalCount];
                            System.arraycopy(buff, 4, temp, 0, totalCount);
                            Arrays.fill(buff, (byte)0);
                            System.arraycopy(temp, 0, buff, 0, totalCount);
                            continue;
                        }
                        if (totalCount <= 3 || buff[0] != 2 || buff[1] != 3 || buff[2] != 75 || buff[3] != 14) continue;
                        IDTMSRData card = new IDTMSRData();
                        card.result = 61094;
                        _msg.bt_onReceiveMsgCardData(card);
                        if ((totalCount -= 4) <= 0) {
                            Arrays.fill(buff, (byte)0);
                            return 0;
                        }
                        temp = new byte[totalCount];
                        System.arraycopy(buff, 4, temp, 0, totalCount);
                        Arrays.fill(buff, (byte)0);
                        System.arraycopy(temp, 0, buff, 0, totalCount);
                    }
                    this.responseFrame.clear();
                    return totalCount;
                }
                catch (InterruptedException ie) {
                    return 0;
                }
            }
        }
        return 0;
    }

    public void disableSwipe() {
        UMLog.i(TAG, "disableSwipe SDK stops polling card data from reader.");
        if (this.swipeThread != null) {
            this.swipeThread.close();
        }
    }

    public void setTimeoutOfSwipeCard(int timeoutInSec) {
        UMLog.i(TAG, "Timeout for card swipe changed to " + timeoutInSec + " seconds.");
        this.swipeTimeoutSec = timeoutInSec;
    }

    public int cancelTransaction() {
        if (!this.inLoop) {
            return 10;
        }
        this.cancelFlag = true;
        return 0;
    }

    public byte[] sendCommand(byte[] command, int timeout) {
        if (!connection) {
            UMLog.i(TAG, "Failed to send a command: ");
            return null;
        }
        long startTime = System.currentTimeMillis();
        if (timeout == 0) {
            if (command[10] == 3 && (command[11] == 7 || command[11] == 2)) {
                timeout = 20;
            } else if (!IDT_Device.infiniteTimeout) {
                timeout = 5;
            }
        }
        byte[] responseData = null;
        byte[] buff = new byte[MAXBUFFERSIZE];
        int res = 0;
        this.responseResults.clear();
        this.responseFrame.clear();
        UMLog.i("**writeRXCharacteristic_try3times**", "command: " + Common.base16Encode(command));
        boolean bSd = this.writeRXCharacteristic_try3times(command);
        if (!bSd) {
            UMLog.e(TAG, "Failed to write the command.");
            return null;
        }
        this.dataAvailable = false;
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.inLoop = false;
        this.cancelFlag = false;
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            block38: {
                int idx;
                while (true) {
                    this.inLoop = true;
                    if (this.cancelFlag) {
                        this.cancelFlag = false;
                        UMLog.i("**BT sendCommand**", "Cancel Transaction");
                        this.writeRXCharacteristic_try3times(Common.grsiP2Command((byte)5, (byte)1, new byte[0]));
                    }
                    if (IDT_Device.cancelTransaction && command[10] == 2 && command[11] == 64) {
                        return null;
                    }
                    long timelimit = (long)(timeout * 1000 + 100) - (System.currentTimeMillis() - startTime);
                    UMLog.i("**read**", "timelimit: " + timelimit);
                    if (timelimit <= 0L && !IDT_Device.infiniteTimeout) break block38;
                    res = this.read(buff, timelimit);
                    if (res > 0) {
                        byte[] temp = new byte[res];
                        UMLog.i("**read**", "res: " + res);
                        System.arraycopy(buff, 0, temp, 0, res);
                        UMLog.i("**read buffer**", Common.base16Encode(temp));
                    } else if (res == -1 && command[10] == 2 && command[11] == 64) {
                        return null;
                    }
                    String AsyncUIMessage = "450055";
                    String MediaEvent = "0750DFEF3604";
                    if (res > 8) {
                        String strTemp = Common.base16Encode(buff);
                        while (strTemp.startsWith(AsyncUIMessage) || strTemp.startsWith(MediaEvent)) {
                            UMLog.i("**BT sendCommand**", "IDT_Device.readyForCardSwipe " + IDT_Device.readyForCardSwipe);
                            if (IDT_Device.readyForCardSwipe) {
                                boolean isMediaEvent = false;
                                if (strTemp.startsWith(MediaEvent)) {
                                    isMediaEvent = true;
                                }
                                int len = buff[4] + 7;
                                if (isMediaEvent) {
                                    len = 12;
                                }
                                boolean allzero = true;
                                for (int x = len; x < buff.length; ++x) {
                                    if (buff[x] == 0) continue;
                                    allzero = false;
                                    break;
                                }
                                if (!allzero) {
                                    byte[] temp = new byte[buff.length];
                                    System.arraycopy(buff, len, temp, 0, buff.length - len);
                                    Arrays.fill(buff, (byte)0);
                                    System.arraycopy(temp, 0, buff, 0, temp.length - len);
                                    strTemp = Common.base16Encode(buff);
                                    res -= len;
                                    continue;
                                }
                                Arrays.fill(buff, (byte)0);
                                timelimit = (long)(timeout * 1000 + 100) - (System.currentTimeMillis() - startTime);
                                this.inLoop = true;
                                this.cancelFlag = false;
                                res = this.read(buff, timelimit);
                                this.inLoop = false;
                                if (res > 0) {
                                    strTemp = Common.base16Encode(buff);
                                    continue;
                                }
                                strTemp = "";
                                continue;
                            }
                            responseData = null;
                            responseData = new byte[res];
                            System.arraycopy(buff, 0, responseData, 0, res);
                            UMLog.i("**BLE getResponse sendCommand 1**", Common.base16Encode(responseData));
                            _msg.bt_onReceiveMsgGetResponse(responseData);
                            return responseData;
                        }
                    }
                    if (res <= 0) continue;
                    idx = 0;
                    while (res - idx > 13) {
                        int dataLen = (buff[12 + idx] & 0xFF) << 8 | buff[13 + idx] & 0xFF;
                        if (res - idx > 20 && buff[10 + idx] == 97 && buff[11 + idx] == -1) {
                            IDTLCDData lcdData = new IDTLCDData();
                            lcdData.screenID = buff[14 + idx] << 8 | buff[15 + idx];
                            lcdData.objectID = buff[16 + idx] << 8 | buff[17 + idx];
                            int chIdx = 18 + idx;
                            while (buff[chIdx] != 0) {
                                ++chIdx;
                            }
                            byte[] bytes = new byte[chIdx - (18 + idx)];
                            System.arraycopy(buff, 18 + idx, bytes, 0, bytes.length);
                            lcdData.screenName = new String(bytes);
                            int chIdx2 = ++chIdx;
                            while (buff[chIdx] != 0) {
                                ++chIdx;
                            }
                            bytes = new byte[chIdx - chIdx2];
                            System.arraycopy(buff, chIdx2, bytes, 0, bytes.length);
                            lcdData.objectName = new String(bytes);
                            if (dataLen > 4 + lcdData.screenName.length() + 1 + lcdData.objectName.length() + 1) {
                                lcdData.longPressed = buff[20 + idx + lcdData.screenName.length() + lcdData.objectName.length()];
                            }
                            _msg.bt_onReceiveMsgLcdData(lcdData);
                            idx += dataLen + 16;
                            continue;
                        }
                        if (buff[10 + idx] == command[10]) break;
                        idx += dataLen + 16;
                    }
                    UMLog.i("**BT sendCommand**", "res " + res + " idx " + idx);
                    if (res == idx) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        res = 0;
                        continue;
                    }
                    responseData = null;
                    if (res - idx > 0) break;
                }
                responseData = new byte[res - idx];
                System.arraycopy(buff, idx, responseData, 0, responseData.length);
                UMLog.i("**BLE getResponse sendCommand 2**", Common.base16Encode(responseData));
                _msg.bt_onReceiveMsgGetResponse(responseData);
                this.inLoop = false;
                return responseData;
            }
            this.inLoop = false;
        } else {
            long timelimit = (long)(timeout * 1000 + 100) - (System.currentTimeMillis() - startTime);
            this.inLoop = true;
            this.cancelFlag = false;
            res = this.read(buff, timelimit);
            this.inLoop = false;
            String AsyncUIMessage = "450055";
            if (res > 8) {
                String strTemp = Common.base16Encode(buff);
                while (strTemp.startsWith(AsyncUIMessage) && IDT_Device.readyForCardSwipe) {
                    int len = buff[4] + 7;
                    boolean allzero = true;
                    for (int x = len; x < buff.length; ++x) {
                        if (buff[x] == 0) continue;
                        allzero = false;
                        break;
                    }
                    if (!allzero) {
                        byte[] temp = new byte[buff.length];
                        System.arraycopy(buff, len, temp, 0, buff.length - len);
                        Arrays.fill(buff, (byte)0);
                        System.arraycopy(temp, 0, buff, 0, temp.length - len);
                        strTemp = Common.base16Encode(buff);
                        res -= len;
                        continue;
                    }
                    Arrays.fill(buff, (byte)0);
                    timelimit = (long)(timeout * 1000 + 100) - (System.currentTimeMillis() - startTime);
                    this.inLoop = true;
                    this.cancelFlag = false;
                    res = this.read(buff, timelimit);
                    this.inLoop = false;
                    if (res > 0) {
                        strTemp = Common.base16Encode(buff);
                        continue;
                    }
                    strTemp = "";
                }
            }
            if (res > 0) {
                responseData = null;
                responseData = new byte[res];
                System.arraycopy(buff, 0, responseData, 0, res);
                UMLog.i("**BLE getResponse sendCommand 3**", Common.base16Encode(responseData));
                _msg.bt_onReceiveMsgGetResponse(responseData);
                return responseData;
            }
        }
        return null;
    }

    public byte[] sendCommandOnly(byte[] command, int timeout) {
        if (!connection) {
            UMLog.i(TAG, "Failed to send a command: ");
            return null;
        }
        if (timeout == 0) {
            timeout = 3;
        }
        this.responseResults.clear();
        this.responseFrame.clear();
        boolean bSd = this.writeRXCharacteristic_try3times(command);
        if (!bSd) {
            UMLog.e(TAG, "Failed to write the command.");
            return null;
        }
        return null;
    }

    public boolean write_raw_data(byte[] data, FirmwareUpdateToolMsg _umtMsg) {
        if (!connection) {
            UMLog.i(TAG, "Failed to write raw data not connected");
            return false;
        }
        this.responseResults.clear();
        this.responseFrame.clear();
        boolean bSd = this.writeRXCharacteristic_raw(data, _umtMsg);
        if (!bSd) {
            UMLog.e(TAG, "Failed to write raw data.");
            return false;
        }
        return true;
    }

    private byte[] sendCommandForRKI(byte[] command, int timeout) {
        if (!connection) {
            UMLog.i(TAG, "Failed to send a command: ");
            return null;
        }
        long startTime = System.currentTimeMillis();
        if (timeout == 0) {
            timeout = 5;
        }
        byte[] responseData = null;
        byte[] buff = new byte[2048];
        int res = 0;
        this.responseResults.clear();
        this.responseFrame.clear();
        boolean bSd = this.writeRXCharacteristic_try3times(command);
        if (!bSd) {
            UMLog.e(TAG, "Failed to write the command.");
            return null;
        }
        this.dataAvailable = false;
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long timelimit = (long)(timeout * 1000) - (System.currentTimeMillis() - startTime);
        res = this.read(buff, timelimit);
        if (res > 0) {
            int idx = 0;
            while (res - idx > 13) {
                int dataLen = (buff[12 + idx] & 0xFF) << 8 | buff[13 + idx] & 0xFF;
                if (res - idx > 20 && buff[10 + idx] == 97 && buff[11 + idx] == -1) {
                    IDTLCDData lcdData = new IDTLCDData();
                    lcdData.screenID = buff[14 + idx] << 8 | buff[15 + idx];
                    lcdData.objectID = buff[16 + idx] << 8 | buff[17 + idx];
                    int chIdx = 18 + idx;
                    while (buff[chIdx] != 0) {
                        ++chIdx;
                    }
                    byte[] bytes = new byte[chIdx - (18 + idx)];
                    System.arraycopy(buff, 18 + idx, bytes, 0, bytes.length);
                    lcdData.screenName = new String(bytes);
                    int chIdx2 = ++chIdx;
                    while (buff[chIdx] != 0) {
                        ++chIdx;
                    }
                    bytes = new byte[chIdx - chIdx2];
                    System.arraycopy(buff, chIdx2, bytes, 0, bytes.length);
                    lcdData.objectName = new String(bytes);
                    if (dataLen > 4 + lcdData.screenName.length() + 1 + lcdData.objectName.length() + 1) {
                        lcdData.longPressed = buff[20 + idx + lcdData.screenName.length() + lcdData.objectName.length()];
                    }
                    _msg.bt_onReceiveMsgLcdData(lcdData);
                    idx += dataLen + 16;
                    continue;
                }
                if (buff[10 + idx] == command[10]) break;
                idx += dataLen + 16;
            }
            responseData = null;
            if (res - idx > 0) {
                responseData = new byte[res - idx];
                System.arraycopy(buff, idx, responseData, 0, responseData.length);
                UMLog.i("**BLE getResponse sendCommandForRKI**", Common.base16Encode(responseData));
                _msg.bt_onReceiveMsgGetResponse(responseData);
            }
            return responseData;
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    private boolean setMTU(int mtu) {
        Log.d((String)"---BLE", (String)("setMTU " + mtu));
        if (Build.VERSION.SDK_INT >= 21 && mtu > 20) {
            boolean ret = this.mGatt.requestMtu(mtu);
            Log.d((String)"BLE", (String)("requestMTU " + mtu + " ret=" + ret));
            return ret;
        }
        return false;
    }

    private void writeRXCharacteristic(byte[] command) {
        block18: {
            block17: {
                if (command == null) {
                    return;
                }
                if (device_BLE_Type != 1) break block17;
                if (this.characteristic == null) {
                    Log.i((String)TAG, (String)"Characteristic not available!");
                    return;
                }
                this.LEN_SLICE = 20;
                int len = command.length;
                int count = len / this.LEN_SLICE;
                int mod = len % this.LEN_SLICE;
                if (mod > 0) {
                    ++count;
                } else if (mod == 0 && len == this.LEN_SLICE) {
                    count = 1;
                }
                Log.d((String)TAG, (String)("CMD =" + Common.getHexStringFromBytes(command)));
                for (int i = 0; i < count; ++i) {
                    int length = this.LEN_SLICE;
                    if (i == count - 1 && mod > 0) {
                        length = mod;
                    }
                    byte[] oneByte = new byte[length];
                    System.arraycopy(command, i * this.LEN_SLICE, oneByte, 0, length);
                    Log.d((String)TAG, (String)("Send " + i + " =" + Common.getHexStringFromBytes(oneByte)));
                    this.characteristic.setValue(oneByte);
                    boolean status = this.mGatt.writeCharacteristic(this.characteristic);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)TAG, (String)("write TXchar - status=" + status));
                }
                break block18;
            }
            if (device_BLE_Type != 2) break block18;
            if (this.mTransWrite == null) {
                Log.i((String)TAG, (String)"Characteristic not available!");
                return;
            }
            int LEN_SLICE = 150;
            int len = command.length;
            int count = len / LEN_SLICE;
            int mod = len % LEN_SLICE;
            if (mod > 0) {
                ++count;
            } else if (mod == 0 && len == LEN_SLICE) {
                count = 1;
            }
            Log.d((String)TAG, (String)("CMD =" + Common.getHexStringFromBytes(command)));
            for (int i = 0; i < count; ++i) {
                int length = LEN_SLICE;
                if (i == count - 1 && mod > 0) {
                    length = mod;
                }
                byte[] oneByte = new byte[length];
                System.arraycopy(command, i * LEN_SLICE, oneByte, 0, length);
                Log.d((String)TAG, (String)("Send " + i + " =" + Common.getHexStringFromBytes(oneByte)));
                this.mTransWrite.setValue(oneByte);
                boolean status = this.mGatt.writeCharacteristic(this.mTransWrite);
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Log.d((String)TAG, (String)("write TXchar - status=" + status));
            }
        }
    }

    private boolean writeRXCharacteristic_try3times(byte[] command) {
        if (command == null) {
            return false;
        }
        if (this.mGatt == null) {
            Log.e((String)TAG, (String)"mGatt not available!");
            return false;
        }
        try {
            if (device_BLE_Type == 1) {
                if (this.characteristic == null) {
                    Log.e((String)TAG, (String)"Characteristic not available!");
                    return false;
                }
                this.LEN_SLICE = 20;
                int len = command.length;
                int count = len / this.LEN_SLICE;
                int mod = len % this.LEN_SLICE;
                if (mod > 0) {
                    ++count;
                } else if (mod == 0 && len == this.LEN_SLICE) {
                    count = 1;
                }
                Log.d((String)TAG, (String)("CMD =" + Common.getHexStringFromBytes(command)));
                for (int i = 0; i < count; ++i) {
                    int length = this.LEN_SLICE;
                    if (i == count - 1 && mod > 0) {
                        length = mod;
                    }
                    byte[] oneByte = new byte[length];
                    System.arraycopy(command, i * this.LEN_SLICE, oneByte, 0, length);
                    Log.d((String)TAG, (String)("Send " + i + " =" + Common.getHexStringFromBytes(oneByte)));
                    this.characteristic.setValue(oneByte);
                    boolean status = false;
                    for (int k = 0; k < 3 && !(status = this.mGatt.writeCharacteristic(this.characteristic)); ++k) {
                        try {
                            Thread.sleep(50L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!status) {
                        Log.e((String)TAG, (String)"Send 3 times, all failed!");
                        return false;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)TAG, (String)("write TXchar - status=" + status));
                }
                return true;
            }
            if (device_BLE_Type == 2) {
                if (this.mTransWrite == null) {
                    Log.e((String)TAG, (String)"Characteristic not available!");
                    return false;
                }
                int LEN_SLICE = 150;
                int len = command.length;
                int count = len / LEN_SLICE;
                int mod = len % LEN_SLICE;
                if (mod > 0) {
                    ++count;
                } else if (mod == 0 && len == LEN_SLICE) {
                    count = 1;
                }
                Log.d((String)TAG, (String)("CMD =" + Common.getHexStringFromBytes(command)));
                for (int i = 0; i < count; ++i) {
                    int length = LEN_SLICE;
                    if (i == count - 1 && mod > 0) {
                        length = mod;
                    }
                    byte[] oneByte = new byte[length];
                    System.arraycopy(command, i * LEN_SLICE, oneByte, 0, length);
                    Log.d((String)TAG, (String)("Send " + i + " =" + Common.getHexStringFromBytes(oneByte)));
                    this.mTransWrite.setValue(oneByte);
                    boolean status = false;
                    for (int k = 0; k < 3 && !(status = this.mGatt.writeCharacteristic(this.mTransWrite)); ++k) {
                        try {
                            Thread.sleep(150L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!status) {
                        Log.e((String)TAG, (String)"Send 3 times, all failed!");
                        return false;
                    }
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)TAG, (String)("write TXchar - status=" + status));
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean writeRXCharacteristic_raw_default(byte[] data, FirmwareUpdateToolMsg _umtMsg) {
        if (data == null) {
            return false;
        }
        if (this.mGatt == null) {
            Log.e((String)TAG, (String)"mGatt not available!");
            return false;
        }
        try {
            if (device_BLE_Type == 2) {
                if (this.mTransWrite == null) {
                    Log.e((String)TAG, (String)"Characteristic not available!");
                    return false;
                }
                int LEN_SLICE = 244;
                this.setMTU(251);
                int len = data.length;
                int count = len / LEN_SLICE;
                int mod = len % LEN_SLICE;
                if (mod > 0) {
                    ++count;
                } else if (mod == 0 && len == LEN_SLICE) {
                    count = 1;
                }
                Log.d((String)TAG, (String)("DATA =" + Common.getHexStringFromBytes(data)));
                boolean status = false;
                for (int index = 0; index < count; ++index) {
                    int length = LEN_SLICE;
                    if (index == count - 1 && mod > 0) {
                        length = mod;
                    }
                    byte[] oneByte = new byte[length];
                    System.arraycopy(data, index * LEN_SLICE, oneByte, 0, length);
                    Log.d((String)TAG, (String)("Send " + index + " =" + Common.getHexStringFromBytes(oneByte)));
                    this.mTransWrite.setValue(oneByte);
                    status = this.mGatt.writeCharacteristic(this.mTransWrite);
                    if (!status) break;
                    try {
                        Thread.sleep(IDT_Device.device_getPackageDownloadDelay());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)TAG, (String)("write TXchar - status=" + status));
                    int percentage = (index + 1) / ((count + 1) / 100 == 0 ? 1 : (count + 1) / 100);
                    if (percentage > 100) {
                        percentage = 100;
                    }
                    _umtMsg.onReceiveMsgUpdateFirmwareProgress(percentage);
                }
                if (!status) {
                    return status;
                }
                byte[] buff = new byte[32];
                int r = this.read(buff, 100L);
                if (r > 0) {
                    Log.d((String)TAG, (String)("Response =" + Common.getHexStringFromBytes(buff)));
                    if (r > 12 && buff[0] == 86 && buff[1] == 105 && buff[10] == -57 && buff[11] != 0) {
                        return false;
                    }
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Log.d((String)TAG, (String)("write TXchar - status=" + status));
                return status;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean writeRXCharacteristic_raw(byte[] data, FirmwareUpdateToolMsg _umtMsg) {
        if (data == null) {
            return false;
        }
        if (this.mGatt == null) {
            Log.e((String)TAG, (String)"mGatt not available!");
            return false;
        }
        try {
            if (device_BLE_Type == 2) {
                if (this.mTransWrite == null) {
                    Log.e((String)TAG, (String)"Characteristic not available!");
                    return false;
                }
                int LEN_SLICE = 244;
                UMLog.i("**writeRXCharacteristic_raw**", "setMTU: 251");
                this.setMTU(251);
                int len = data.length;
                int count = len / LEN_SLICE;
                int mod = len % LEN_SLICE;
                if (mod > 0) {
                    ++count;
                } else if (mod == 0 && len == LEN_SLICE) {
                    count = 1;
                }
                Log.d((String)TAG, (String)("DATA =" + Common.getHexStringFromBytes(data)));
                boolean status = false;
                UMLog.i("**writeRXCharacteristic_raw**", "PackageDownloadStartIndex: " + IDT_Device.PackageDownloadStartIndex);
                for (int index = IDT_Device.PackageDownloadStartIndex; index < count; ++index) {
                    int length = LEN_SLICE;
                    if (index == count - 1 && mod > 0) {
                        length = mod;
                    }
                    byte[] oneByte = new byte[length];
                    System.arraycopy(data, index * LEN_SLICE, oneByte, 0, length);
                    Log.d((String)TAG, (String)("Send " + index + " =" + Common.getHexStringFromBytes(oneByte)));
                    this.mTransWrite.setValue(oneByte);
                    status = this.mGatt.writeCharacteristic(this.mTransWrite);
                    if (!status) break;
                    try {
                        Thread.sleep(IDT_Device.device_getPackageDownloadDelay());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)TAG, (String)("write TXchar - status=" + status));
                    int percentage = (index + 1) / ((count + 1) / 100 == 0 ? 1 : (count + 1) / 100);
                    if (percentage > 100) {
                        percentage = 100;
                    }
                    UMLog.i("**writeRXCharacteristic_raw**", "percentage: " + percentage + " index: " + index + " count: " + count);
                    _umtMsg.onReceiveMsgUpdateFirmwareProgress(percentage);
                }
                if (!status) {
                    UMLog.i("**writeRXCharacteristic_raw**", "write error");
                    return status;
                }
                byte[] buff = new byte[32];
                int r = this.read(buff, 7000L);
                if (r > 0) {
                    Log.d((String)TAG, (String)("Response =" + Common.getHexStringFromBytes(buff)));
                    UMLog.i("**writeRXCharacteristic_raw**", "Response =" + Common.getHexStringFromBytes(buff));
                    if (r > 12 && buff[0] == 86 && buff[1] == 105 && buff[10] == -57 && buff[11] != 0) {
                        return false;
                    }
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Log.d((String)TAG, (String)("write TXchar - status=" + status));
                return status;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String asciiBytesToString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] result = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = (char)bytes[i];
        }
        return new String(result);
    }

    public byte[] sendCommandFw(byte[] command) {
        return null;
    }

    private int readMSR(byte[] data) {
        if (!connection) {
            return 0;
        }
        return 0;
    }

    private boolean close() {
        if (connection || IDT_Device.btleDisconnect) {
            this.cancel();
            connection = false;
            btleDevice = null;
        }
        System.gc();
        return true;
    }

    private void cancel() {
        if (this.mGatt == null) {
            return;
        }
        if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
            this.connectionDone();
            try {
                Thread.sleep(60L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.mGatt.close();
        this.mGatt = null;
        connection = false;
    }

    private class listenForDataOnThread
    extends Thread {
        public boolean isRunning = true;

        private listenForDataOnThread() {
        }

        @Override
        public void run() {
            byte[] tmp = new byte[2048];
            while (this.isRunning) {
                if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                    if (IDT_Device.isCommandRunning || Common.getBootLoaderMode()) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                } else if (!IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || IDT_Device.isCommandRunning || Common.getBootLoaderMode()) {
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (IDT_Device.isBurstModeOn || !IDT_Device.isAutoPollOn || Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT && Common.getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_VP8800_BT) continue;
                    try {
                        Thread.sleep(900L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (IDT_Device.isCommandRunning) continue;
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT) {
                        if (IDT_Device.isMonitorCtlsData) {
                            IDTMSRData card = new IDTMSRData();
                            byte[] command = Common.getByteArray("5669564F7465636832000340000096E2");
                            byte[] data = BluetoothLEController.this.sendCommand(command, 1);
                            int len = 0;
                            if (data != null && data.length > 13) {
                                len = (data[12] & 0xFF) * 256 + (data[13] & 0xFF);
                            }
                            if (len > 7) {
                                Common.parseCardData3in1(data, card);
                                UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(data));
                                _msg.bt_onReceiveMsgCardData(card);
                                continue;
                            }
                            card.result = 61092;
                            _msg.bt_onReceiveMsgCardData(card);
                            continue;
                        }
                        IDTMSRData card = new IDTMSRData();
                        card.result = 61092;
                        _msg.bt_onReceiveMsgCardData(card);
                        continue;
                    }
                    IDTMSRData card = new IDTMSRData();
                    card.result = 61092;
                    _msg.bt_onReceiveMsgCardData(card);
                    continue;
                }
                IDT_Device.isCheckingNotification = true;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Arrays.fill(tmp, (byte)0);
                IDT_Device.isThreadReading = true;
                int length = BluetoothLEController.this.read_autoPoll(tmp);
                IDT_Device.isThreadReading = false;
                if (length > 0) {
                    if (length > 10) {
                        while (tmp[0] == 69 && tmp[1] == 0 && tmp[2] == 85 || tmp[0] == 7 && tmp[1] == 80 && tmp[2] == -33 && tmp[3] == -17 && tmp[4] == 54 && tmp[5] == 4 && tmp[6] == 3) {
                            boolean isCtlsLCDMsg = false;
                            if (tmp[0] == 69 && tmp[1] == 0 && tmp[2] == 85) {
                                length -= 11;
                                isCtlsLCDMsg = true;
                            } else {
                                length -= 12;
                                isCtlsLCDMsg = false;
                            }
                            if (length < 0) continue;
                            if (length > 0) {
                                byte[] temp = new byte[length];
                                System.arraycopy(tmp, isCtlsLCDMsg ? 11 : 12, temp, 0, length);
                                Arrays.fill(tmp, (byte)0);
                                System.arraycopy(temp, 0, tmp, 0, length);
                                continue;
                            }
                            Arrays.fill(tmp, (byte)0);
                        }
                        if (length <= 0) {
                            IDT_Device.isCheckingNotification = false;
                            continue;
                        }
                    }
                    if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                        UMLog.i("**listenForDataOnThread**", "read_autoPoll: " + Common.base16Encode(tmp) + "\n");
                        if (length > 12 && tmp[10] == 97 && tmp[11] == 1) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            IDT_Device.isCheckingNotification = false;
                            continue;
                        }
                        if (length > 12 && tmp[10] == -18 && tmp[11] == -16) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            IDT_Device.isCheckingNotification = false;
                            continue;
                        }
                        if (length > 20 && tmp[10] == 97 && tmp[11] == -1) {
                            int dataLen = tmp[12] << 8 | tmp[13];
                            IDTLCDData lcdData = new IDTLCDData();
                            lcdData.screenID = tmp[14] << 8 | tmp[15];
                            lcdData.objectID = tmp[16] << 8 | tmp[17];
                            int chIdx = 18;
                            while (tmp[chIdx] != 0) {
                                ++chIdx;
                            }
                            byte[] bytes = new byte[chIdx - 18];
                            System.arraycopy(tmp, 18, bytes, 0, bytes.length);
                            lcdData.screenName = new String(bytes);
                            int chIdx2 = ++chIdx;
                            while (tmp[chIdx] != 0) {
                                ++chIdx;
                            }
                            bytes = new byte[chIdx - chIdx2];
                            System.arraycopy(tmp, chIdx2, bytes, 0, bytes.length);
                            lcdData.objectName = new String(bytes);
                            if (dataLen > 4 + lcdData.screenName.length() + 1 + lcdData.objectName.length() + 1) {
                                lcdData.longPressed = tmp[20 + lcdData.screenName.length() + lcdData.objectName.length()];
                            }
                            _msg.bt_onReceiveMsgLcdData(lcdData);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            IDT_Device.isCheckingNotification = false;
                            continue;
                        }
                    } else if (Common.getDeviceType() == ReaderInfo.DEVICE_TYPE.DEVICE_VP3300_BT) {
                        if (length > 12 && tmp[10] == 2 && tmp[11] == -96) {
                            IDTMSRData card = new IDTMSRData();
                            card.result = 61088;
                            _msg.bt_onReceiveMsgCardData(card);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            IDT_Device.isCheckingNotification = false;
                            continue;
                        }
                        if (length > 12 && tmp[10] == -18 && tmp[11] == -16) {
                            IDTMSRData card = new IDTMSRData();
                            card.result = 61168;
                            _msg.bt_onReceiveMsgCardData(card);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            IDT_Device.isCheckingNotification = false;
                            continue;
                        }
                    }
                    byte[] data = new byte[length];
                    System.arraycopy(tmp, 0, data, 0, length);
                    IDTMSRData card = new IDTMSRData();
                    Common.processCTLSData(data, card);
                    UMLog.i("listenForDataOnThread", "got: " + Common.getByteArrDesc(data));
                    if (data.length != 2 || data[0] != 0) {
                        _msg.bt_onReceiveMsgCardData(card);
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                IDT_Device.isCheckingNotification = false;
            }
            BluetoothLEController.this.listenThread = null;
        }
    }

    private class listenForBLEDataOnThread
    extends Thread {
        private listenForBLEDataOnThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < 300L) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!BluetoothLEController.this.characteristicChanged) continue;
                BluetoothLEController.this.characteristicChanged = false;
                return;
            }
            if (BluetoothLEController.this.mutexNotifyDataReady != null) {
                Object object = BluetoothLEController.this.mutexNotifyDataReady;
                synchronized (object) {
                    BluetoothLEController.this.responseFrame.add(BluetoothLEController.this.resData);
                    BluetoothLEController.this.responseResults.clear();
                    Log.d((String)BluetoothLEController.TAG, (String)"## ---data notifyAll-----##");
                    BluetoothLEController.this.dataAvailable = true;
                    BluetoothLEController.this.mutexNotifyDataReady.notifyAll();
                }
            }
        }
    }

    private class CheckDeviceThread
    extends Thread {
        boolean res = false;

        private CheckDeviceThread() {
        }

        @Override
        public void run() {
            try {
                CheckDeviceThread.sleep(300L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            while (!this.res) {
                this.res = BluetoothLEController.this.initWithThread();
                try {
                    CheckDeviceThread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class SwipeDataReceiver
    extends Thread {
        private SwipeDataReceiver() {
        }

        @Override
        public void run() {
        }

        public void close() {
        }
    }
}

