/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import com.creditcall.chipdnamobile.CardSchemeID;
import com.creditcall.chipdnamobile.Fd;
import com.creditcall.chipdnamobile.MerchantAccount;
import com.creditcall.chipdnamobile.MerchantCardScheme;
import com.creditcall.chipdnamobile.ProcessTypeEnum;
import com.creditcall.chipdnamobile.ReceiptField;
import com.creditcall.chipdnamobile.ReceiptFieldInclusion;
import com.creditcall.chipdnamobile.TransactionDetails;
import com.creditcall.chipdnamobile.TransactionResultEnum;
import com.creditcall.chipdnamobile.TransactionTypeEnum;
import com.creditcall.chipdnamobile.UsReceiptData;
import java.util.ArrayList;
import java.util.HashMap;

class ChaseReceiptData
extends UsReceiptData {
    private static final long serialVersionUID = -6094704399926619257L;
    static String TQ = "6987C6A7-28C7-DB11-8109-0014222200E5";
    static String EL = "6987C6A7-28C7-DB11-8109-0014222200E5";
    static String cL = "37954670-5F04-4EB2-9C61-7EB9C85C6EE7";
    static String zv = "37954670-5F04-4EB2-9C61-7EB9C85C6EE7";

    ChaseReceiptData(TransactionDetails details) {
        super(details);
    }

    @Override
    protected void TQ(TransactionDetails transactionDetails) {
        super.TQ(transactionDetails);
        MerchantAccount merchantAccount = transactionDetails.F();
        MerchantCardScheme merchantCardScheme = merchantAccount.EL(CardSchemeID.EL(transactionDetails.q()));
        if (merchantCardScheme != null) {
            this.TQ("cem.receipt.card.scheme", new ReceiptField(null, merchantCardScheme.cL(), ReceiptFieldInclusion.Mandatory), "cem.receipt.nameandaddress");
        }
        if (transactionDetails.a() != TransactionResultEnum.Declined) {
            this.TQ("cem.receipt.agreement", new ReceiptField(null, (String)this.mr.get("AGREEMENT"), ReceiptFieldInclusion.Mandatory), "cem.receipt.datetime");
        }
        this.EL("cem.receipt.authmode");
        this.EL("cem.receipt.cvm");
        this.EL("cem.receipt.authcode");
        if (transactionDetails.n() == ProcessTypeEnum.MAG && transactionDetails.P()) {
            this.om.put("cem.receipt.transactionsource", new ReceiptField(null, (String)this.mr.get("FSWIPE"), ReceiptFieldInclusion.Mandatory));
        }
    }

    @Override
    protected HashMap<String, String> TQ() {
        HashMap<String, String> hashMap = super.TQ();
        hashMap.put("FSWIPE", "CHIP/MAG");
        hashMap.put("ICC", "CHIP");
        hashMap.put("SWIPE", "MAG");
        if (this.my.x()) {
            hashMap.put("AGREEMENT", "BY ENTERING A VERIFIED PIN, CARDHOLDER AGREES TO PAY ISSUER SUCH TOTAL IN ACCORDANCE WITH ISSUER'S AGREEMENT WITH CARDHOLDER");
        } else {
            hashMap.put("AGREEMENT", "\tI AGREE TO PAY ABOVE TOTAL AMOUNT ACCORDING TO CARD ISSUER AGREEMENT (MERCHANT AGREEMENT IF CREDIT VOUCHER)");
        }
        hashMap.put("Please sign below", "CARDHOLDER NAME");
        if (this.my.o() != TransactionTypeEnum.REFUND) {
            if (this.my.b() != null) {
                hashMap.put("APPROVED", "APPROVED [" + this.my.b() + "]");
            } else {
                hashMap.put("APPROVED", "APPROVED");
            }
        }
        if (this.my.a() == TransactionResultEnum.Declined && this.my.b() != null) {
            hashMap.put("SALE", "\nVOID SALE\n");
            hashMap.put("DECLINED", "APPROVED [" + this.my.b() + "]");
        }
        return hashMap;
    }

    @Override
    protected ArrayList<String> EL() {
        ArrayList<String> arrayList = super.EL();
        arrayList.add((String)this.mr.get("FSWIPE"));
        arrayList.add((String)this.mr.get("ICC"));
        arrayList.add((String)this.mr.get("Please sign below"));
        arrayList.add((String)this.mr.get("AGREEMENT"));
        arrayList.add((String)this.mr.get("APPROVED"));
        if (this.my.a() == TransactionResultEnum.Declined && this.my.b() != null) {
            arrayList.add((String)this.mr.get("SALE"));
            arrayList.add((String)this.mr.get("DECLINED"));
        }
        return arrayList;
    }

    @Override
    protected ArrayList<String> cL() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("0X95");
        arrayList.add("0X9B");
        arrayList.add("0X5F24");
        return arrayList;
    }

    @Override
    protected String TQ(Fd fd, boolean bl) {
        if (!this.my.x() && bl) {
            return String.format("\n\n\n\n\n.............................\n%s", this.mr.get("Please sign below"));
        }
        return "";
    }

    @Override
    public String TQ(Fd fd, boolean bl, boolean bl2) {
        String string = super.TQ(fd, bl, false);
        if (this.my.a() != TransactionResultEnum.Declined && bl) {
            String string2 = String.format("%s%s\n", this.mr.get("AGREEMENT"), this.TQ(fd, bl));
            string = string.replace((CharSequence)this.mr.get("AGREEMENT"), string2);
        }
        return string;
    }
}

