/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import android.util.Xml;
import com.creditcall.chipdnamobile.Application;
import com.creditcall.chipdnamobile.CardHash;
import com.creditcall.chipdnamobile.CardSchemeID;
import com.creditcall.chipdnamobile.CardToken;
import com.creditcall.chipdnamobile.Currency;
import com.creditcall.chipdnamobile.DeviceStatus;
import com.creditcall.chipdnamobile.FeatureToken;
import com.creditcall.chipdnamobile.FirmwareUpdateStatus;
import com.creditcall.chipdnamobile.Merchant;
import com.creditcall.chipdnamobile.MerchantData;
import com.creditcall.chipdnamobile.OfflineRequest;
import com.creditcall.chipdnamobile.PaymentMethod;
import com.creditcall.chipdnamobile.PaymentPlatformStatus;
import com.creditcall.chipdnamobile.ReceiptField;
import com.creditcall.chipdnamobile.ReceiptFieldInclusion;
import com.creditcall.chipdnamobile.RequestQueueStatus;
import com.creditcall.chipdnamobile.TerminalStatus;
import com.creditcall.chipdnamobile.TmsStatus;
import com.creditcall.chipdnamobile.TransactionTypeID;
import com.creditcall.chipdnamobile.VersionInformation;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;
import timber.log.Timber;

public class ChipDnaMobileSerializer {
    public static final String ReceiptDataTag = "ReceiptData";
    public static final String ReceiptItemIdTag = "ReceiptItemId";
    public static final String ReceiptItemTag = "ReceiptItem";
    public static final String ReceiptLabelTag = "Label";
    public static final String ReceiptValueTag = "Value";
    public static final String ReceiptInclusionTag = "Inclusion";
    public static final String ReceiptPriorityAttribute = "priority";
    public static final String CardHashesTag = "CardHashes";
    public static final String CardHashTag = "CardHash";
    public static final String CardHashScopeAttribute = "scope";
    public static final String CardHashSourceAttribute = "source";
    public static final String CardTokensTag = "CardTokens";
    public static final String CardTokenTag = "CardToken";
    public static final String CardTokenAlgorithmAttribute = "algorithm";
    public static final String CardTokenKeyAttribute = "key";
    public static final String FeatureTokensTag = "FeatureTokens";
    public static final String FeatureTokenTag = "FeatureToken";
    public static final String VersionInformationTag = "VersionInformation";
    public static final String VersionTag = "ChipDnaVersion";
    public static final String ReleaseNameTag = "ChipDnaReleaseName";
    public static final String ApplicationNameTag = "ChipDnaApplicationName";
    public static final String HashMapItemTag = "Item";
    public static final String HashMapKeyTag = "Key";
    public static final String HashMapValueTag = "Value";
    public static final String DeviceStatusRootTag = "DeviceStatus";
    public static final String DeviceStatusNameTag = "Name";
    public static final String DeviceStatusTag = "Status";
    public static final String DeviceStatusMakeTag = "Make";
    public static final String DeviceStatusModelTag = "Model";
    public static final String DeviceStatusFirmwareNameTag = "FirmwareName";
    public static final String DeviceStatusFirmwareVersionTag = "FirmwareVersion";
    public static final String DeviceStatusOperatingSystemVersionTag = "OperatingSystemVersion";
    public static final String DeviceStatusKernelsHashTag = "KernelsHash";
    public static final String DeviceStatusRevisionTag = "Revision";
    public static final String DeviceStatusRawBatteryChargePercentageTag = "RawBatteryChargePercentage";
    public static final String DeviceStatusBatteryChargePercentageTag = "BatteryChargePercentage";
    public static final String DeviceStatusBatteryChargingStatusTag = "BatteryChargingStatus";
    public static final String DeviceStatusBatteryChargingStatusUpdateDateTimeTag = "BatteryChargingStatusUpdateDateTime";
    public static final String DeviceStatusBatteryChargingStatusUpdateDateTimeFormatTag = "BatteryChargingStatusUpdateDateTimeFormat";
    public static final String DeviceStatusSerialNumTag = "SerialNum";
    public static final String DeviceStatusAvailabilityErrorTag = "Error";
    public static final String DeviceStatusErrorInformationTag = "ErrorInformation";
    public static final String DateTimeFormatTag = "DateTimeFormat";
    public static final String RequestQueueStatusTag = "RequestQueueStatus";
    public static final String TotalNumberOfPendingRequestsTag = "TotalNumberOfPendingRequests";
    public static final String TotalNumberOfFailedRequestsTag = "TotalNumberOfFailedRequests";
    public static final String PendingRequestsStorageLimitTag = "PendingRequestsStorageLimit";
    public static final String TotalPendingValueStoredTag = "TotalPendingValueStored";
    public static final String TotalFailedValueStoredTag = "TotalFailedValueStored";
    public static final String PendingRequestValueLimitTag = "PendingRequestsValueLimit";
    public static final String OldestPendingRequestDateTimeTag = "OldestPendingRequestDateTime";
    public static final String PendingRequestTotalsByRequestTypeTag = "PendingRequestTotalsByRequestType";
    public static final String FailedRequestTotalsByRequestTypeTag = "FailedRequestsTotalsByRequestType";
    public static final String PendingRequestVolumesByRequestTypeTag = "PendingRequestVolumesByRequestType";
    public static final String FailedRequestVolumesByRequestType = "FailedRequestVolumesByRequestType";
    public static final String FailedOfflineRequestsTag = "FailedOfflineRequests";
    public static final String FailedRequestTag = "FailedRequest";
    public static final String TmsStatusTag = "TmsStatus";
    public static final String LastConfigUpdateDateTimeTag = "LastConfigUpdateDateTime";
    public static final String DaysUntilConfigUpdateRequiredTag = "DaysUntilConfigUpdateRequired";
    public static final String RequiredConfigUpdateDateTimeTag = "RequiredConfigUpdateDateTime";
    public static final String PaymentPlatformStatusTag = "PaymentPlatformStatus";
    public static final String AvailabilityStateTag = "AvailabilityState";
    public static final String LocalDateTimeFormatTag = "LocalDateTimeFormat";
    public static final String LocalDateTimeTag = "LocalDateTime";
    public static final String PaymentPlatformStatusCheckDateTimeFormatTag = "PaymentPlatformStatusCheckDateTimeFormat";
    public static final String PaymentPlatformStatusCheckDateTimeTag = "PaymentPlatformStatusCheckDateTime";
    public static final String ErrorsTag = "Errors";
    public static final String ErrorTag = "Error";
    public static final String TerminalStatusTag = "TerminalStatus";
    public static final String TerminalIdTag = "TerminalId";
    public static final String TransactionKeyTag = "TransactionKey";
    public static final String ApiKeyTag = "ApiKey";
    public static final String WebMisUsernameTag = "WebMisUsername";
    public static final String WebMisPasswordTag = "WebMisPassword";
    public static final String AvailableCurrenciesTag = "AvailableCurrencies";
    public static final String CurrenciesTag = "Currencies";
    public static final String PaymentMethodAttribute = "payment-method";
    public static final String CurrencyTag = "Currency";
    public static final String NumericCodeAttribute = "numeric-code";
    public static final String CharCodeAttribute = "char-code";
    public static final String ExponentAttribute = "exponent";
    public static final String SymbolAttribute = "symbol";
    public static final String EnabledAttribute = "enabled";
    public static final String ApplicationTag = "Application";
    public static final String AvailableApplicationsTag = "AvailableApplications";
    public static final String ApplicationNameAttribute = "application-name";
    public static final String ApplicationPriorityAttribute = "application-priority";
    public static final String PinPadsTag = "PinPads";
    public static final String PinPadTag = "PinPad";
    public static final String PinPadConnectionTypeAttribute = "connection-type";
    public static final String MerchantDataTag = "MerchantData";
    public static final String MerchantTag = "Merchant";
    public static final String MerchantNameTag = "Name";
    public static final String IdAttribute = "id";
    public static final String CategoryCodeAttribute = "mcc";
    public static final String CardSchemesTag = "CardSchemes";
    public static final String CardSchemeTag = "CardScheme";
    public static final String TransactionTypesTag = "TransactionTypes";
    public static final String TransactionTypeTag = "TransactionType";
    public static final String FileTag = "File";
    public static final String FileNameAttribute = "file-name";
    public static final String FirmwareUpdateStatusTag = "FirmwareUpdateStatus";
    public static final String FilesRequiringUpdateTag = "FilesRequiringUpdate";
    public static final String DaysUntilFirmwareUpdateRequiredTag = "DaysUntilFirmwareUpdateRequired";
    public static final String RequiredFirmwareUpdateDateTimeTag = "RequiredFirmwareUpdateDateTime";

    static String TQ(Map<String, ReceiptField> map) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", ReceiptDataTag);
            for (String string : map.keySet()) {
                ReceiptField receiptField = map.get(string);
                xmlSerializer.startTag("", ReceiptItemTag);
                xmlSerializer.attribute("", ReceiptPriorityAttribute, Integer.toString(receiptField.getPriority()));
                xmlSerializer.startTag("", ReceiptItemIdTag);
                xmlSerializer.text(string);
                xmlSerializer.endTag("", ReceiptItemIdTag);
                if (receiptField.getLabel() != null) {
                    xmlSerializer.startTag("", ReceiptLabelTag);
                    xmlSerializer.text(receiptField.getLabel());
                    xmlSerializer.endTag("", ReceiptLabelTag);
                }
                if (receiptField.getValue() != null) {
                    xmlSerializer.startTag("", "Value");
                    xmlSerializer.text(receiptField.getValue());
                    xmlSerializer.endTag("", "Value");
                }
                xmlSerializer.startTag("", ReceiptInclusionTag);
                xmlSerializer.text(receiptField.getInclusion().name());
                xmlSerializer.endTag("", ReceiptInclusionTag);
                xmlSerializer.endTag("", ReceiptItemTag);
            }
            xmlSerializer.endTag("", ReceiptDataTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (Exception exception) {
            Timber.wtf((Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public static Map<String, ReceiptField> deserializeReceiptData(String receiptDataXml) throws XmlPullParserException, IOException {
        HashMap<String, ReceiptField> hashMap = new HashMap<String, ReceiptField>();
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(receiptDataXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, ReceiptDataTag);
        while (xmlPullParser.next() != 3 && xmlPullParser.getEventType() != 1) {
            if (xmlPullParser.getEventType() != 2 || !xmlPullParser.getName().equals(ReceiptItemTag)) continue;
            ChipDnaMobileSerializer.TQ(xmlPullParser, hashMap);
        }
        return hashMap;
    }

    private static void TQ(XmlPullParser xmlPullParser, Map<String, ReceiptField> map) throws IOException, XmlPullParserException {
        xmlPullParser.require(2, null, ReceiptItemTag);
        int n = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        ReceiptFieldInclusion receiptFieldInclusion = null;
        String string4 = xmlPullParser.getAttributeValue("", ReceiptPriorityAttribute);
        if (string4 != null && string4.length() > 0) {
            n = Integer.valueOf(string4);
        }
        while (xmlPullParser.next() != 3) {
            String string5;
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals(ReceiptItemIdTag)) {
                string = ChipDnaMobileSerializer.TQ(xmlPullParser, ReceiptItemIdTag);
                continue;
            }
            if (xmlPullParser.getName().equals(ReceiptLabelTag)) {
                string2 = ChipDnaMobileSerializer.TQ(xmlPullParser, ReceiptLabelTag);
                continue;
            }
            if (xmlPullParser.getName().equals("Value")) {
                string3 = ChipDnaMobileSerializer.TQ(xmlPullParser, "Value");
                continue;
            }
            if (!xmlPullParser.getName().equals(ReceiptInclusionTag) || (string5 = ChipDnaMobileSerializer.TQ(xmlPullParser, ReceiptInclusionTag)) == null) continue;
            receiptFieldInclusion = ReceiptFieldInclusion.valueOf(string5);
        }
        map.put(string, new ReceiptField(string2, string3, receiptFieldInclusion, n));
    }

    private static String TQ(XmlPullParser xmlPullParser, String string) throws IOException, XmlPullParserException {
        xmlPullParser.require(2, null, string);
        String string2 = "";
        if (xmlPullParser.next() == 4) {
            string2 = xmlPullParser.getText();
            xmlPullParser.nextTag();
        }
        xmlPullParser.require(3, null, string);
        return string2;
    }

    static String TQ(List<CardHash> list) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", CardHashesTag);
            for (CardHash cardHash : list) {
                xmlSerializer.startTag("", CardHashTag);
                xmlSerializer.attribute("", CardHashScopeAttribute, cardHash.getScope().name());
                xmlSerializer.attribute("", CardHashSourceAttribute, cardHash.getSource().name());
                xmlSerializer.text(cardHash.getValue());
                xmlSerializer.endTag("", CardHashTag);
            }
            xmlSerializer.endTag("", CardHashesTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (Exception exception) {
            Timber.wtf((Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public static List<CardHash> deserializeCardHashes(String cardHashXml) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(cardHashXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, CardHashesTag);
        ArrayList<CardHash> arrayList = new ArrayList<CardHash>();
        while (xmlPullParser.next() != 3) {
            String string;
            if (xmlPullParser.getEventType() != 2) continue;
            xmlPullParser.require(2, null, CardHashTag);
            CardHash.Scope scope = null;
            CardHash.Source source = null;
            String string2 = xmlPullParser.getAttributeValue("", CardHashScopeAttribute);
            if (string2 != null && string2.length() > 0) {
                scope = CardHash.Scope.valueOf(string2);
            }
            if ((string = xmlPullParser.getAttributeValue("", CardHashSourceAttribute)) != null && string.length() > 0) {
                source = CardHash.Source.valueOf(string);
            }
            String string3 = ChipDnaMobileSerializer.TQ(xmlPullParser, CardHashTag);
            arrayList.add(new CardHash(string3, scope, source));
        }
        return arrayList;
    }

    static String EL(List<CardToken> list) {
        if (list == null) {
            throw new NullPointerException("cardTokens cannot be null");
        }
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", CardTokensTag);
            for (CardToken cardToken : list) {
                xmlSerializer.startTag("", CardTokenTag);
                xmlSerializer.attribute("", CardTokenAlgorithmAttribute, cardToken.getAlgorithm());
                xmlSerializer.attribute("", CardTokenKeyAttribute, cardToken.getKey());
                xmlSerializer.text(cardToken.getValue());
                xmlSerializer.endTag("", CardTokenTag);
            }
            xmlSerializer.endTag("", CardTokensTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (Exception exception) {
            Timber.wtf((Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public static List<CardToken> deserializeCardTokens(String cardTokenXml) throws XmlPullParserException, IOException {
        if (cardTokenXml == null) {
            throw new NullPointerException("cardTokenXml cannot be null");
        }
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(cardTokenXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, CardTokensTag);
        ArrayList<CardToken> arrayList = new ArrayList<CardToken>();
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            xmlPullParser.require(2, null, CardTokenTag);
            String string = xmlPullParser.getAttributeValue("", CardTokenAlgorithmAttribute);
            String string2 = xmlPullParser.getAttributeValue("", CardTokenKeyAttribute);
            String string3 = ChipDnaMobileSerializer.TQ(xmlPullParser, CardTokenTag);
            arrayList.add(new CardToken(string, string2, string3));
        }
        return arrayList;
    }

    public static String serializeFeatureTokens(List<FeatureToken> featureTokens) {
        if (featureTokens == null) {
            throw new NullPointerException("featuretokens cannot be null");
        }
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", FeatureTokensTag);
            for (FeatureToken featureToken : featureTokens) {
                xmlSerializer.startTag("", FeatureTokenTag);
                xmlSerializer.text(featureToken.getValue());
                xmlSerializer.endTag("", FeatureTokenTag);
            }
            xmlSerializer.endTag("", FeatureTokensTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (Exception exception) {
            Timber.wtf((Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    static List<FeatureToken> TQ(String string) throws XmlPullParserException, IOException {
        if (string == null) {
            throw new NullPointerException("featureTokenXml cannot be null");
        }
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(string));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, FeatureTokensTag);
        ArrayList<FeatureToken> arrayList = new ArrayList<FeatureToken>();
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            xmlPullParser.require(2, null, FeatureTokenTag);
            String string2 = ChipDnaMobileSerializer.TQ(xmlPullParser, FeatureTokenTag);
            arrayList.add(new FeatureToken(string2));
        }
        return arrayList;
    }

    static String TQ(VersionInformation versionInformation) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", VersionInformationTag);
            xmlSerializer.startTag("", VersionTag);
            xmlSerializer.text(versionInformation.getVersion());
            xmlSerializer.endTag("", VersionTag);
            xmlSerializer.startTag("", ReleaseNameTag);
            xmlSerializer.text(versionInformation.getReleaseName());
            xmlSerializer.endTag("", ReleaseNameTag);
            xmlSerializer.startTag("", ApplicationNameTag);
            xmlSerializer.text(versionInformation.getApplicationName());
            xmlSerializer.endTag("", ApplicationNameTag);
            xmlSerializer.endTag("", VersionInformationTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (Exception exception) {
            Timber.wtf((Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public static VersionInformation deserializeVersionInformation(String versionInformationXml) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(versionInformationXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, VersionInformationTag);
        String string = null;
        String string2 = null;
        String string3 = null;
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals(VersionTag)) {
                string = ChipDnaMobileSerializer.TQ(xmlPullParser, VersionTag);
                continue;
            }
            if (xmlPullParser.getName().equals(ReleaseNameTag)) {
                string2 = ChipDnaMobileSerializer.TQ(xmlPullParser, ReleaseNameTag);
                continue;
            }
            if (!xmlPullParser.getName().equals(ApplicationNameTag)) continue;
            string3 = ChipDnaMobileSerializer.TQ(xmlPullParser, ApplicationNameTag);
        }
        return new VersionInformation(string, string2, string3);
    }

    static String TQ(DeviceStatus deviceStatus) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", DeviceStatusRootTag);
            if (deviceStatus.getName() != null) {
                xmlSerializer.startTag("", "Name");
                xmlSerializer.text(deviceStatus.getName());
                xmlSerializer.endTag("", "Name");
            }
            xmlSerializer.startTag("", DeviceStatusTag);
            xmlSerializer.text(DeviceStatus.EL(deviceStatus.getStatus()));
            xmlSerializer.endTag("", DeviceStatusTag);
            if (deviceStatus.getMake() != null) {
                xmlSerializer.startTag("", DeviceStatusMakeTag);
                xmlSerializer.text(deviceStatus.getMake());
                xmlSerializer.endTag("", DeviceStatusMakeTag);
            }
            if (deviceStatus.getModel() != null) {
                xmlSerializer.startTag("", DeviceStatusModelTag);
                xmlSerializer.text(deviceStatus.getModel());
                xmlSerializer.endTag("", DeviceStatusModelTag);
            }
            if (deviceStatus.getFirmwareName() != null) {
                xmlSerializer.startTag("", DeviceStatusFirmwareNameTag);
                xmlSerializer.text(deviceStatus.getFirmwareName());
                xmlSerializer.endTag("", DeviceStatusFirmwareNameTag);
            }
            if (deviceStatus.getFirmwareVersion() != null) {
                xmlSerializer.startTag("", DeviceStatusFirmwareVersionTag);
                xmlSerializer.text(deviceStatus.getFirmwareVersion());
                xmlSerializer.endTag("", DeviceStatusFirmwareVersionTag);
            }
            if (deviceStatus.getOsVersion() != null) {
                xmlSerializer.startTag("", DeviceStatusOperatingSystemVersionTag);
                xmlSerializer.text(deviceStatus.getOsVersion());
                xmlSerializer.endTag("", DeviceStatusOperatingSystemVersionTag);
            }
            if (deviceStatus.getKernelsHash() != null) {
                xmlSerializer.startTag("", DeviceStatusKernelsHashTag);
                xmlSerializer.text(deviceStatus.getKernelsHash());
                xmlSerializer.endTag("", DeviceStatusKernelsHashTag);
            }
            if (deviceStatus.getRevision() != null) {
                xmlSerializer.startTag("", DeviceStatusRevisionTag);
                xmlSerializer.text(deviceStatus.getRevision());
                xmlSerializer.endTag("", DeviceStatusRevisionTag);
            }
            if (deviceStatus.getSerialNumber() != null) {
                xmlSerializer.startTag("", DeviceStatusSerialNumTag);
                xmlSerializer.text(deviceStatus.getSerialNumber());
                xmlSerializer.endTag("", DeviceStatusSerialNumTag);
            }
            if (deviceStatus.getRawBatteryChargePercentage() >= 0) {
                xmlSerializer.startTag("", DeviceStatusRawBatteryChargePercentageTag);
                xmlSerializer.text(Integer.toString(deviceStatus.getRawBatteryChargePercentage()));
                xmlSerializer.endTag("", DeviceStatusRawBatteryChargePercentageTag);
            }
            if (deviceStatus.getBatteryChargePercentage() >= 0) {
                xmlSerializer.startTag("", DeviceStatusBatteryChargePercentageTag);
                xmlSerializer.text(Integer.toString(deviceStatus.getBatteryChargePercentage()));
                xmlSerializer.endTag("", DeviceStatusBatteryChargePercentageTag);
            }
            if (deviceStatus.getBatteryChargingStatus() != null) {
                xmlSerializer.startTag("", DeviceStatusBatteryChargingStatusTag);
                xmlSerializer.text(deviceStatus.getBatteryChargingStatus());
                xmlSerializer.endTag("", DeviceStatusBatteryChargingStatusTag);
            }
            if (deviceStatus.getBatteryChargingStatusUpdateDateTime() != null) {
                xmlSerializer.startTag("", DeviceStatusBatteryChargingStatusUpdateDateTimeTag);
                xmlSerializer.text(deviceStatus.getBatteryChargingStatusUpdateDateTime());
                xmlSerializer.endTag("", DeviceStatusBatteryChargingStatusUpdateDateTimeTag);
            }
            if (deviceStatus.getBatteryChargingStatusUpdateDateTimeFormat() != null) {
                xmlSerializer.startTag("", DeviceStatusBatteryChargingStatusUpdateDateTimeFormatTag);
                xmlSerializer.text(deviceStatus.getBatteryChargingStatusUpdateDateTimeFormat());
                xmlSerializer.endTag("", DeviceStatusBatteryChargingStatusUpdateDateTimeFormatTag);
            }
            if (deviceStatus.getAvailabilityError() != null) {
                xmlSerializer.startTag("", "Error");
                xmlSerializer.text(deviceStatus.getAvailabilityError());
                xmlSerializer.endTag("", "Error");
            }
            if (deviceStatus.getErrorInformation() != null && deviceStatus.getErrorInformation().size() > 0) {
                xmlSerializer.startTag("", DeviceStatusErrorInformationTag);
                ChipDnaMobileSerializer.TQ(deviceStatus.getErrorInformation(), xmlSerializer);
                xmlSerializer.endTag("", DeviceStatusErrorInformationTag);
            }
            xmlSerializer.endTag("", DeviceStatusRootTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            Timber.wtf((Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static DeviceStatus deserializeDeviceStatus(String deviceStatusXml) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(deviceStatusXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, DeviceStatusRootTag);
        DeviceStatus deviceStatus = new DeviceStatus();
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals("Name")) {
                deviceStatus.EL(ChipDnaMobileSerializer.TQ(xmlPullParser, "Name"));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusTag)) {
                String string = ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusTag);
                deviceStatus.TQ(DeviceStatus.sw(string));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusMakeTag)) {
                deviceStatus.rE(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusMakeTag));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusModelTag)) {
                deviceStatus.dR(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusModelTag));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusFirmwareNameTag)) {
                deviceStatus.NE(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusFirmwareNameTag));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusFirmwareVersionTag)) {
                deviceStatus.dC(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusFirmwareVersionTag));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusOperatingSystemVersionTag)) {
                deviceStatus.setOsVersion(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusOperatingSystemVersionTag));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusKernelsHashTag)) {
                deviceStatus.setKernelsHash(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusKernelsHashTag));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusRevisionTag)) {
                deviceStatus.uq(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusRevisionTag));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusRawBatteryChargePercentageTag)) {
                deviceStatus.TQ(Integer.parseInt(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusRawBatteryChargePercentageTag)));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusBatteryChargePercentageTag)) {
                deviceStatus.EL(Integer.parseInt(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusBatteryChargePercentageTag)));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusBatteryChargingStatusTag)) {
                deviceStatus.cL(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusBatteryChargingStatusTag));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusBatteryChargingStatusUpdateDateTimeTag)) {
                deviceStatus.zv(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusBatteryChargingStatusUpdateDateTimeTag));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusBatteryChargingStatusUpdateDateTimeFormatTag)) {
                deviceStatus.dY(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusBatteryChargingStatusUpdateDateTimeFormatTag));
                continue;
            }
            if (xmlPullParser.getName().equals(DeviceStatusSerialNumTag)) {
                deviceStatus.VT(ChipDnaMobileSerializer.TQ(xmlPullParser, DeviceStatusSerialNumTag));
                continue;
            }
            if (xmlPullParser.getName().equals("Error")) {
                deviceStatus.TQ(ChipDnaMobileSerializer.TQ(xmlPullParser, "Error"));
                continue;
            }
            if (!xmlPullParser.getName().equals(DeviceStatusErrorInformationTag)) continue;
            deviceStatus.TQ(ChipDnaMobileSerializer.TQ(xmlPullParser));
        }
        return deviceStatus;
    }

    private static HashMap<String, String> TQ(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        xmlPullParser.require(2, null, DeviceStatusErrorInformationTag);
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2 || !xmlPullParser.getName().equals(HashMapItemTag)) continue;
            xmlPullParser.require(2, null, HashMapItemTag);
            String string = null;
            String string2 = null;
            while (xmlPullParser.next() != 3) {
                if (xmlPullParser.getEventType() != 2) continue;
                if (xmlPullParser.getName().equals(HashMapKeyTag)) {
                    string = ChipDnaMobileSerializer.TQ(xmlPullParser, HashMapKeyTag);
                    continue;
                }
                if (!xmlPullParser.getName().equals("Value")) continue;
                string2 = ChipDnaMobileSerializer.TQ(xmlPullParser, "Value");
            }
            if (string == null) continue;
            hashMap.put(string, string2);
        }
        return hashMap.size() > 0 ? hashMap : null;
    }

    static String TQ(FirmwareUpdateStatus firmwareUpdateStatus) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", FirmwareUpdateStatusTag);
            if (!firmwareUpdateStatus.getDateTimeFormat().isEmpty()) {
                xmlSerializer.startTag("", DateTimeFormatTag);
                xmlSerializer.text(firmwareUpdateStatus.getDateTimeFormat());
                xmlSerializer.endTag("", DateTimeFormatTag);
            }
            if (!firmwareUpdateStatus.getDaysUntilFirmwareUpdateRequired().isEmpty()) {
                xmlSerializer.startTag("", DaysUntilFirmwareUpdateRequiredTag);
                xmlSerializer.text(firmwareUpdateStatus.getDaysUntilFirmwareUpdateRequired());
                xmlSerializer.endTag("", DaysUntilFirmwareUpdateRequiredTag);
            }
            if (!firmwareUpdateStatus.getRequiredFirmwareUpdateTime().isEmpty()) {
                xmlSerializer.startTag("", RequiredFirmwareUpdateDateTimeTag);
                xmlSerializer.text(firmwareUpdateStatus.getRequiredFirmwareUpdateTime());
                xmlSerializer.endTag("", RequiredFirmwareUpdateDateTimeTag);
            }
            if (!firmwareUpdateStatus.getFilesRequiringUpdate().isEmpty()) {
                xmlSerializer.startTag("", FilesRequiringUpdateTag);
                ChipDnaMobileSerializer.TQ(firmwareUpdateStatus.getFilesRequiringUpdate(), xmlSerializer);
                xmlSerializer.endTag("", FilesRequiringUpdateTag);
            }
            xmlSerializer.endTag("", FirmwareUpdateStatusTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            Timber.wtf((Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    private static void TQ(List<String> list, XmlSerializer xmlSerializer) throws IOException {
        for (String string : list) {
            xmlSerializer.startTag("", FileTag);
            xmlSerializer.attribute("", FileNameAttribute, string);
            xmlSerializer.endTag("", FileTag);
        }
    }

    public static FirmwareUpdateStatus deserializeFirmwareUpdateStatus(String firmwareUpdateStatusXml) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(firmwareUpdateStatusXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, FirmwareUpdateStatusTag);
        String string = "";
        String string2 = "";
        String string3 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals(DateTimeFormatTag)) {
                string = ChipDnaMobileSerializer.TQ(xmlPullParser, DateTimeFormatTag);
                continue;
            }
            if (xmlPullParser.getName().equals(DaysUntilFirmwareUpdateRequiredTag)) {
                string2 = ChipDnaMobileSerializer.TQ(xmlPullParser, DaysUntilFirmwareUpdateRequiredTag);
                continue;
            }
            if (xmlPullParser.getName().equals(RequiredFirmwareUpdateDateTimeTag)) {
                string3 = ChipDnaMobileSerializer.TQ(xmlPullParser, RequiredFirmwareUpdateDateTimeTag);
                continue;
            }
            if (!xmlPullParser.getName().equals(FilesRequiringUpdateTag)) continue;
            xmlPullParser.require(2, null, FilesRequiringUpdateTag);
            while (xmlPullParser.next() != 3) {
                if (xmlPullParser.getEventType() != 2 || !xmlPullParser.getName().equals(FileTag)) continue;
                String string4 = xmlPullParser.getAttributeValue("", FileNameAttribute);
                if (string4 != null && !string4.isEmpty()) {
                    arrayList.add(string4);
                }
                xmlPullParser.next();
                xmlPullParser.require(3, null, FileTag);
            }
        }
        return new FirmwareUpdateStatus(string, string2, string3, arrayList);
    }

    private static <K, V> void TQ(HashMap<K, V> hashMap, XmlSerializer xmlSerializer) throws IOException {
        for (K k : hashMap.keySet()) {
            xmlSerializer.startTag("", HashMapItemTag);
            xmlSerializer.startTag("", HashMapKeyTag);
            xmlSerializer.text(k.toString());
            xmlSerializer.endTag("", HashMapKeyTag);
            xmlSerializer.startTag("", "Value");
            xmlSerializer.text(hashMap.get(k).toString());
            xmlSerializer.endTag("", "Value");
            xmlSerializer.endTag("", HashMapItemTag);
        }
    }

    public static RequestQueueStatus deserializeRequestQueueStatus(String requestQueueStatusXml) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(requestQueueStatusXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, RequestQueueStatusTag);
        RequestQueueStatus requestQueueStatus = new RequestQueueStatus();
        while (xmlPullParser.next() != 3) {
            Object object;
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals(TotalNumberOfPendingRequestsTag)) {
                object = ChipDnaMobileSerializer.TQ(xmlPullParser, TotalNumberOfPendingRequestsTag);
                requestQueueStatus.TQ(Long.parseLong((String)object));
            } else if (xmlPullParser.getName().equals(TotalNumberOfFailedRequestsTag)) {
                object = ChipDnaMobileSerializer.TQ(xmlPullParser, TotalNumberOfFailedRequestsTag);
                requestQueueStatus.EL(Long.parseLong((String)object));
            } else if (xmlPullParser.getName().equals(PendingRequestsStorageLimitTag)) {
                object = ChipDnaMobileSerializer.TQ(xmlPullParser, PendingRequestsStorageLimitTag);
                requestQueueStatus.cL(Long.parseLong((String)object));
            } else if (xmlPullParser.getName().equals(PendingRequestValueLimitTag)) {
                object = ChipDnaMobileSerializer.TQ(xmlPullParser, PendingRequestValueLimitTag);
                requestQueueStatus.rE(Long.parseLong((String)object));
            } else if (xmlPullParser.getName().equals(TotalPendingValueStoredTag)) {
                object = ChipDnaMobileSerializer.TQ(xmlPullParser, TotalPendingValueStoredTag);
                requestQueueStatus.zv(Long.parseLong((String)object));
            } else if (xmlPullParser.getName().equals(TotalFailedValueStoredTag)) {
                object = ChipDnaMobileSerializer.TQ(xmlPullParser, TotalFailedValueStoredTag);
                requestQueueStatus.dY(Long.parseLong((String)object));
            } else if (xmlPullParser.getName().equals(DateTimeFormatTag)) {
                requestQueueStatus.EL(ChipDnaMobileSerializer.TQ(xmlPullParser, DateTimeFormatTag));
            } else if (xmlPullParser.getName().equals(OldestPendingRequestDateTimeTag)) {
                requestQueueStatus.TQ(ChipDnaMobileSerializer.TQ(xmlPullParser, OldestPendingRequestDateTimeTag));
            } else if (xmlPullParser.getName().equals(PendingRequestTotalsByRequestTypeTag)) {
                requestQueueStatus.EL(ChipDnaMobileSerializer.EL(xmlPullParser, PendingRequestTotalsByRequestTypeTag));
            } else if (xmlPullParser.getName().equals(PendingRequestVolumesByRequestTypeTag)) {
                requestQueueStatus.TQ(ChipDnaMobileSerializer.EL(xmlPullParser, PendingRequestVolumesByRequestTypeTag));
            } else if (xmlPullParser.getName().equals(FailedRequestTotalsByRequestTypeTag)) {
                requestQueueStatus.zv(ChipDnaMobileSerializer.EL(xmlPullParser, FailedRequestTotalsByRequestTypeTag));
            } else if (xmlPullParser.getName().equals(FailedRequestVolumesByRequestType)) {
                requestQueueStatus.cL(ChipDnaMobileSerializer.EL(xmlPullParser, FailedRequestVolumesByRequestType));
            }
            if (!xmlPullParser.getName().equals(FailedOfflineRequestsTag)) continue;
            xmlPullParser.require(2, null, FailedOfflineRequestsTag);
            object = new ArrayList();
            while (xmlPullParser.next() != 3) {
                if (xmlPullParser.getEventType() != 2 || !xmlPullParser.getName().equals(FailedRequestTag)) continue;
                object.add(ChipDnaMobileSerializer.TQ(xmlPullParser, FailedRequestTag));
            }
            if (object.isEmpty()) continue;
            requestQueueStatus.TQ((List<String>)object);
        }
        return requestQueueStatus;
    }

    private static HashMap<OfflineRequest.CEMOfflineRequestType, Long> EL(XmlPullParser xmlPullParser, String string) throws IOException, XmlPullParserException {
        HashMap<OfflineRequest.CEMOfflineRequestType, Long> hashMap = new HashMap<OfflineRequest.CEMOfflineRequestType, Long>();
        xmlPullParser.require(2, null, string);
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2 || !xmlPullParser.getName().equals(HashMapItemTag)) continue;
            xmlPullParser.require(2, null, HashMapItemTag);
            String string2 = null;
            String string3 = null;
            while (xmlPullParser.next() != 3) {
                if (xmlPullParser.getEventType() != 2) continue;
                if (xmlPullParser.getName().equals(HashMapKeyTag)) {
                    string2 = ChipDnaMobileSerializer.TQ(xmlPullParser, HashMapKeyTag);
                    continue;
                }
                if (!xmlPullParser.getName().equals("Value")) continue;
                string3 = ChipDnaMobileSerializer.TQ(xmlPullParser, "Value");
            }
            if (string2 == null) continue;
            OfflineRequest.CEMOfflineRequestType cEMOfflineRequestType = Enum.valueOf(OfflineRequest.CEMOfflineRequestType.class, string2);
            hashMap.put(cEMOfflineRequestType, Long.parseLong(string3));
        }
        return hashMap.size() > 0 ? hashMap : null;
    }

    static String TQ(RequestQueueStatus requestQueueStatus) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            List<String> list;
            HashMap<OfflineRequest.CEMOfflineRequestType, Long> hashMap;
            HashMap<OfflineRequest.CEMOfflineRequestType, Long> hashMap2;
            HashMap<OfflineRequest.CEMOfflineRequestType, Long> hashMap3;
            HashMap<OfflineRequest.CEMOfflineRequestType, Long> hashMap4;
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", RequestQueueStatusTag);
            xmlSerializer.startTag("", TotalNumberOfPendingRequestsTag);
            xmlSerializer.text(String.valueOf(requestQueueStatus.getTotalNumberOfPendingRequests()));
            xmlSerializer.endTag("", TotalNumberOfPendingRequestsTag);
            xmlSerializer.startTag("", TotalNumberOfFailedRequestsTag);
            xmlSerializer.text(String.valueOf(requestQueueStatus.getTotalNumberOfFailedRequests()));
            xmlSerializer.endTag("", TotalNumberOfFailedRequestsTag);
            xmlSerializer.startTag("", PendingRequestsStorageLimitTag);
            xmlSerializer.text(String.valueOf(requestQueueStatus.getPendingRequestsStorageLimit()));
            xmlSerializer.endTag("", PendingRequestsStorageLimitTag);
            xmlSerializer.startTag("", PendingRequestValueLimitTag);
            xmlSerializer.text(String.valueOf(requestQueueStatus.getPendingRequestsValueLimit()));
            xmlSerializer.endTag("", PendingRequestValueLimitTag);
            xmlSerializer.startTag("", TotalPendingValueStoredTag);
            xmlSerializer.text(String.valueOf(requestQueueStatus.getTotalPendingValueStored()));
            xmlSerializer.endTag("", TotalPendingValueStoredTag);
            xmlSerializer.startTag("", TotalFailedValueStoredTag);
            xmlSerializer.text(String.valueOf(requestQueueStatus.getTotalFailedValueStored()));
            xmlSerializer.endTag("", TotalFailedValueStoredTag);
            xmlSerializer.startTag("", DateTimeFormatTag);
            xmlSerializer.text(requestQueueStatus.getDateTimeFormat());
            xmlSerializer.endTag("", DateTimeFormatTag);
            if (requestQueueStatus.getDateTimeOfOldestStoredRequest() != null) {
                xmlSerializer.startTag("", OldestPendingRequestDateTimeTag);
                xmlSerializer.text(requestQueueStatus.getDateTimeOfOldestStoredRequest());
                xmlSerializer.endTag("", OldestPendingRequestDateTimeTag);
            }
            if ((hashMap4 = requestQueueStatus.getPendingRequestTotalsByRequestType()) != null && !hashMap4.isEmpty()) {
                xmlSerializer.startTag("", PendingRequestTotalsByRequestTypeTag);
                ChipDnaMobileSerializer.TQ(hashMap4, xmlSerializer);
                xmlSerializer.endTag("", PendingRequestTotalsByRequestTypeTag);
            }
            if ((hashMap3 = requestQueueStatus.getPendingRequestVolumesByRequestType()) != null && !hashMap3.isEmpty()) {
                xmlSerializer.startTag("", PendingRequestVolumesByRequestTypeTag);
                ChipDnaMobileSerializer.TQ(hashMap3, xmlSerializer);
                xmlSerializer.endTag("", PendingRequestVolumesByRequestTypeTag);
            }
            if ((hashMap2 = requestQueueStatus.getFailedRequestTotalsByRequestType()) != null && !hashMap2.isEmpty()) {
                xmlSerializer.startTag("", FailedRequestTotalsByRequestTypeTag);
                ChipDnaMobileSerializer.TQ(hashMap2, xmlSerializer);
                xmlSerializer.endTag("", FailedRequestTotalsByRequestTypeTag);
            }
            if ((hashMap = requestQueueStatus.getFailedRequestVolumesByRequestType()) != null && !hashMap.isEmpty()) {
                xmlSerializer.startTag("", FailedRequestVolumesByRequestType);
                ChipDnaMobileSerializer.TQ(hashMap, xmlSerializer);
                xmlSerializer.endTag("", PendingRequestVolumesByRequestTypeTag);
            }
            if ((list = requestQueueStatus.getFailedOfflineRequests()) != null && !list.isEmpty()) {
                xmlSerializer.startTag("", FailedOfflineRequestsTag);
                for (String string : list) {
                    xmlSerializer.startTag("", FailedRequestTag);
                    xmlSerializer.text(string);
                    xmlSerializer.endTag("", FailedRequestTag);
                }
                xmlSerializer.endTag("", FailedOfflineRequestsTag);
            }
            xmlSerializer.endTag("", RequestQueueStatusTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            Timber.wtf((Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static TmsStatus deserializeTmsStatus(String tmsStatusXml) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(tmsStatusXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, TmsStatusTag);
        TmsStatus tmsStatus = new TmsStatus();
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals(LastConfigUpdateDateTimeTag)) {
                tmsStatus.EL(ChipDnaMobileSerializer.TQ(xmlPullParser, LastConfigUpdateDateTimeTag));
                continue;
            }
            if (xmlPullParser.getName().equals(DaysUntilConfigUpdateRequiredTag)) {
                tmsStatus.cL(ChipDnaMobileSerializer.TQ(xmlPullParser, DaysUntilConfigUpdateRequiredTag));
                continue;
            }
            if (xmlPullParser.getName().equals(RequiredConfigUpdateDateTimeTag)) {
                tmsStatus.zv(ChipDnaMobileSerializer.TQ(xmlPullParser, RequiredConfigUpdateDateTimeTag));
                continue;
            }
            if (!xmlPullParser.getName().equals(DateTimeFormatTag)) continue;
            tmsStatus.TQ(ChipDnaMobileSerializer.TQ(xmlPullParser, DateTimeFormatTag));
        }
        return tmsStatus;
    }

    static String TQ(TmsStatus tmsStatus) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", TmsStatusTag);
            if (tmsStatus.getLastConfigUpdateDateTime() != null) {
                xmlSerializer.startTag("", LastConfigUpdateDateTimeTag);
                xmlSerializer.text(tmsStatus.getLastConfigUpdateDateTime());
                xmlSerializer.endTag("", LastConfigUpdateDateTimeTag);
            }
            xmlSerializer.startTag("", DaysUntilConfigUpdateRequiredTag);
            xmlSerializer.text(tmsStatus.getDaysUntilConfigUpdateRequired());
            xmlSerializer.endTag("", DaysUntilConfigUpdateRequiredTag);
            xmlSerializer.startTag("", RequiredConfigUpdateDateTimeTag);
            xmlSerializer.text(tmsStatus.getRequiredConfigUpdateDateTime());
            xmlSerializer.endTag("", RequiredConfigUpdateDateTimeTag);
            xmlSerializer.startTag("", DateTimeFormatTag);
            xmlSerializer.text(tmsStatus.getDateTimeFormat());
            xmlSerializer.endTag("", DateTimeFormatTag);
            xmlSerializer.endTag("", TmsStatusTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            Timber.wtf((Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static PaymentPlatformStatus deserializePaymentPlatformStatus(String paymentPlatformStatusXml) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(paymentPlatformStatusXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, PaymentPlatformStatusTag);
        PaymentPlatformStatus paymentPlatformStatus = new PaymentPlatformStatus();
        while (xmlPullParser.next() != 3) {
            Object object;
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals(AvailabilityStateTag)) {
                object = ChipDnaMobileSerializer.TQ(xmlPullParser, AvailabilityStateTag);
                paymentPlatformStatus.TQ(Enum.valueOf(PaymentPlatformStatus.PaymentPlatformState.class, (String)object));
                continue;
            }
            if (xmlPullParser.getName().equals(LocalDateTimeTag)) {
                paymentPlatformStatus.EL(ChipDnaMobileSerializer.TQ(xmlPullParser, LocalDateTimeTag));
                continue;
            }
            if (xmlPullParser.getName().equals(LocalDateTimeFormatTag)) {
                paymentPlatformStatus.TQ(ChipDnaMobileSerializer.TQ(xmlPullParser, LocalDateTimeFormatTag));
                continue;
            }
            if (xmlPullParser.getName().equals(PaymentPlatformStatusCheckDateTimeTag)) {
                paymentPlatformStatus.EL(ChipDnaMobileSerializer.TQ(xmlPullParser, PaymentPlatformStatusCheckDateTimeTag));
                continue;
            }
            if (xmlPullParser.getName().equals(PaymentPlatformStatusCheckDateTimeFormatTag)) {
                paymentPlatformStatus.TQ(ChipDnaMobileSerializer.TQ(xmlPullParser, PaymentPlatformStatusCheckDateTimeFormatTag));
                continue;
            }
            if (!xmlPullParser.getName().equals(ErrorsTag)) continue;
            xmlPullParser.require(2, null, ErrorsTag);
            object = new ArrayList();
            while (xmlPullParser.next() != 3) {
                if (xmlPullParser.getEventType() != 2 || !xmlPullParser.getName().equals("Error")) continue;
                object.add(ChipDnaMobileSerializer.TQ(xmlPullParser, "Error"));
            }
            if (object.isEmpty()) continue;
            paymentPlatformStatus.TQ((List<String>)object);
        }
        return paymentPlatformStatus;
    }

    static String TQ(PaymentPlatformStatus paymentPlatformStatus) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", PaymentPlatformStatusTag);
            xmlSerializer.startTag("", AvailabilityStateTag);
            xmlSerializer.text(String.valueOf((Object)paymentPlatformStatus.getState()));
            xmlSerializer.endTag("", AvailabilityStateTag);
            if (paymentPlatformStatus.getLocalDateTime() != null) {
                xmlSerializer.startTag("", LocalDateTimeTag);
                xmlSerializer.text(paymentPlatformStatus.getLocalDateTime());
                xmlSerializer.endTag("", LocalDateTimeTag);
                xmlSerializer.startTag("", LocalDateTimeFormatTag);
                xmlSerializer.text(paymentPlatformStatus.getLocalDateTimeFormat());
                xmlSerializer.endTag("", LocalDateTimeFormatTag);
            }
            xmlSerializer.startTag("", PaymentPlatformStatusCheckDateTimeTag);
            xmlSerializer.text(paymentPlatformStatus.getPaymentPlatformStatusCheckDateTime());
            xmlSerializer.endTag("", PaymentPlatformStatusCheckDateTimeTag);
            xmlSerializer.startTag("", PaymentPlatformStatusCheckDateTimeFormatTag);
            xmlSerializer.text(paymentPlatformStatus.getPaymentPlatformStatusCheckDateTimeFormat());
            xmlSerializer.endTag("", PaymentPlatformStatusCheckDateTimeFormatTag);
            if (paymentPlatformStatus.getErrors() != null && !paymentPlatformStatus.getErrors().isEmpty()) {
                xmlSerializer.startTag("", ErrorsTag);
                for (String string : paymentPlatformStatus.getErrors()) {
                    xmlSerializer.startTag("", "Error");
                    xmlSerializer.text(string);
                    xmlSerializer.endTag("", "Error");
                }
                xmlSerializer.endTag("", ErrorsTag);
            }
            xmlSerializer.endTag("", PaymentPlatformStatusTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            Timber.wtf((Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static TerminalStatus deserializeTerminalStatus(String terminalStatusXml) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(terminalStatusXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, TerminalStatusTag);
        TerminalStatus terminalStatus = new TerminalStatus();
        boolean bl = "True".equalsIgnoreCase(xmlPullParser.getAttributeValue("", EnabledAttribute));
        terminalStatus.TQ(bl);
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals(TerminalIdTag)) {
                terminalStatus.TQ(ChipDnaMobileSerializer.TQ(xmlPullParser, TerminalIdTag));
                continue;
            }
            if (xmlPullParser.getName().equals(TransactionKeyTag)) {
                terminalStatus.EL(ChipDnaMobileSerializer.TQ(xmlPullParser, TransactionKeyTag));
                continue;
            }
            if (xmlPullParser.getName().equals(ApiKeyTag)) {
                terminalStatus.cL(ChipDnaMobileSerializer.TQ(xmlPullParser, ApiKeyTag));
                continue;
            }
            if (xmlPullParser.getName().equals(WebMisUsernameTag)) {
                terminalStatus.zv(ChipDnaMobileSerializer.TQ(xmlPullParser, WebMisUsernameTag));
                continue;
            }
            if (!xmlPullParser.getName().equals(WebMisPasswordTag)) continue;
            terminalStatus.dY(ChipDnaMobileSerializer.TQ(xmlPullParser, WebMisPasswordTag));
        }
        return terminalStatus;
    }

    static String TQ(TerminalStatus terminalStatus) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", TerminalStatusTag);
            xmlSerializer.attribute("", EnabledAttribute, terminalStatus.isEnabled() ? "True" : "False");
            if (terminalStatus.getTerminalId() != null && !terminalStatus.getTerminalId().isEmpty()) {
                xmlSerializer.startTag("", TerminalIdTag);
                xmlSerializer.text(terminalStatus.getTerminalId());
                xmlSerializer.endTag("", TerminalIdTag);
            }
            if (terminalStatus.getTransactionKey() != null && !terminalStatus.getTransactionKey().isEmpty()) {
                xmlSerializer.startTag("", TransactionKeyTag);
                xmlSerializer.text(terminalStatus.getTransactionKey());
                xmlSerializer.endTag("", TransactionKeyTag);
            }
            if (terminalStatus.getApiKey() != null && !terminalStatus.getApiKey().isEmpty()) {
                xmlSerializer.startTag("", ApiKeyTag);
                xmlSerializer.text(terminalStatus.getApiKey());
                xmlSerializer.endTag("", ApiKeyTag);
            }
            if (terminalStatus.getWebMisUserName() != null && !terminalStatus.getWebMisUserName().isEmpty()) {
                xmlSerializer.startTag("", WebMisUsernameTag);
                xmlSerializer.text(terminalStatus.getWebMisUserName());
                xmlSerializer.endTag("", WebMisUsernameTag);
            }
            if (terminalStatus.getWebMisPassword() != null && !terminalStatus.getWebMisPassword().isEmpty()) {
                xmlSerializer.startTag("", WebMisPasswordTag);
                xmlSerializer.text(terminalStatus.getWebMisPassword());
                xmlSerializer.endTag("", WebMisPasswordTag);
            }
            xmlSerializer.endTag("", TerminalStatusTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            Timber.wtf((Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static HashMap<PaymentMethod, ArrayList<Currency>> deserializeAvailableCurrencies(String availableCurrenciesXml) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(availableCurrenciesXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, AvailableCurrenciesTag);
        HashMap<PaymentMethod, ArrayList<Currency>> hashMap = new HashMap<PaymentMethod, ArrayList<Currency>>();
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            xmlPullParser.require(2, null, CurrenciesTag);
            if (!xmlPullParser.getName().equals(CurrenciesTag)) continue;
            String string = xmlPullParser.getAttributeValue("", PaymentMethodAttribute);
            PaymentMethod paymentMethod = Enum.valueOf(PaymentMethod.class, string);
            ArrayList<Currency> arrayList = ChipDnaMobileSerializer.dY(xmlPullParser);
            hashMap.put(paymentMethod, arrayList);
        }
        return hashMap;
    }

    static String EL(Map<PaymentMethod, ArrayList<Currency>> map) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", AvailableCurrenciesTag);
            for (PaymentMethod paymentMethod : map.keySet()) {
                xmlSerializer.startTag("", CurrenciesTag);
                xmlSerializer.attribute("", PaymentMethodAttribute, paymentMethod.name());
                List list = map.get((Object)paymentMethod);
                ChipDnaMobileSerializer.TQ(xmlSerializer, list);
                xmlSerializer.endTag("", CurrenciesTag);
            }
            xmlSerializer.endTag("", AvailableCurrenciesTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            Timber.wtf((Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    private static void TQ(XmlSerializer xmlSerializer, List<Currency> list) throws IOException {
        for (Currency currency : list) {
            xmlSerializer.startTag("", CurrencyTag);
            xmlSerializer.attribute("", NumericCodeAttribute, currency.a());
            xmlSerializer.attribute("", CharCodeAttribute, currency.getCharCode());
            xmlSerializer.attribute("", SymbolAttribute, currency.getSymbol());
            xmlSerializer.attribute("", ExponentAttribute, String.valueOf(currency.getExponent()));
            xmlSerializer.endTag("", CurrencyTag);
        }
    }

    public static HashMap<String, ArrayList<String>> deserializeAvailablePinPads(String availablePinPadsXml) throws XmlPullParserException, IOException {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        if (availablePinPadsXml == null) {
            return hashMap;
        }
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(availablePinPadsXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, PinPadsTag);
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            xmlPullParser.require(2, null, PinPadTag);
            if (!xmlPullParser.getName().equals(PinPadTag)) continue;
            String string = xmlPullParser.getAttributeValue("", PinPadConnectionTypeAttribute).toUpperCase();
            String string2 = ChipDnaMobileSerializer.TQ(xmlPullParser, PinPadTag);
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList());
            }
            hashMap.get(string).add(string2);
        }
        return hashMap;
    }

    static String TQ(HashMap<String, ArrayList<String>> hashMap) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", PinPadsTag);
            for (String string : hashMap.keySet()) {
                for (String string2 : hashMap.get(string)) {
                    xmlSerializer.startTag("", PinPadTag);
                    xmlSerializer.attribute("", PinPadConnectionTypeAttribute, string);
                    xmlSerializer.text(string2);
                    xmlSerializer.endTag("", PinPadTag);
                }
            }
            xmlSerializer.endTag("", PinPadsTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            Timber.wtf((Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    static String TQ(ArrayList<Application> arrayList) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", AvailableApplicationsTag);
            for (Application application : arrayList) {
                xmlSerializer.startTag("", ApplicationTag);
                xmlSerializer.attribute("", ApplicationNameAttribute, application.getName());
                xmlSerializer.attribute("", ApplicationPriorityAttribute, String.valueOf(application.getPriority()));
                xmlSerializer.endTag("", ApplicationTag);
            }
            xmlSerializer.endTag("", AvailableApplicationsTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            Timber.wtf((Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public static ArrayList<Application> deserializeAvailableApplications(String availableApplicationsXml) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(availableApplicationsXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, AvailableApplicationsTag);
        ArrayList<Application> arrayList = new ArrayList<Application>();
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            xmlPullParser.require(2, null, ApplicationTag);
            if (xmlPullParser.getName().equals(ApplicationTag)) {
                String string = xmlPullParser.getAttributeValue("", ApplicationNameAttribute);
                String string2 = xmlPullParser.getAttributeValue("", ApplicationPriorityAttribute);
                arrayList.add(new Application(string, Integer.parseInt(string2)));
            }
            xmlPullParser.next();
            xmlPullParser.require(3, null, ApplicationTag);
        }
        return arrayList;
    }

    static String TQ(MerchantData merchantData) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            xmlSerializer.setOutput((Writer)stringWriter);
            xmlSerializer.startDocument("UTF-8", Boolean.valueOf(true));
            xmlSerializer.startTag("", MerchantDataTag);
            if (merchantData.getMerchantList() != null && !merchantData.getMerchantList().isEmpty()) {
                for (Merchant merchant : merchantData.getMerchantList()) {
                    ChipDnaMobileSerializer.TQ(xmlSerializer, merchant);
                }
            }
            xmlSerializer.endTag("", MerchantDataTag);
            xmlSerializer.endDocument();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            Timber.wtf((Throwable)iOException, (String)"Failed to serialize merchant data", (Object[])new Object[0]);
            throw new RuntimeException(iOException);
        }
    }

    static void TQ(XmlSerializer xmlSerializer, Merchant merchant) throws IOException {
        xmlSerializer.startTag("", MerchantTag);
        if (merchant.getNumber() != null) {
            xmlSerializer.attribute("", IdAttribute, merchant.getNumber());
        }
        if (merchant.getCategoryCode() != null) {
            xmlSerializer.attribute("", CategoryCodeAttribute, merchant.getCategoryCode());
        }
        if (merchant.getName() != null) {
            xmlSerializer.startTag("", "Name");
            xmlSerializer.text(merchant.getName());
            xmlSerializer.endTag("", "Name");
        }
        if (merchant.getCardSchemes() != null && !merchant.getCardSchemes().isEmpty()) {
            xmlSerializer.startTag("", CardSchemesTag);
            for (CardSchemeID object : merchant.getCardSchemes()) {
                xmlSerializer.startTag("", CardSchemeTag);
                xmlSerializer.attribute("", IdAttribute, String.valueOf(object.getCardSchemeID()));
                xmlSerializer.endTag("", CardSchemeTag);
            }
            xmlSerializer.endTag("", CardSchemesTag);
        }
        if (merchant.getTransactionTypes() != null && !merchant.getTransactionTypes().isEmpty()) {
            xmlSerializer.startTag("", TransactionTypesTag);
            for (TransactionTypeID transactionTypeID : merchant.getTransactionTypes()) {
                xmlSerializer.startTag("", TransactionTypeTag);
                xmlSerializer.attribute("", IdAttribute, String.valueOf(transactionTypeID.getTransactionTypeID()));
                xmlSerializer.endTag("", TransactionTypeTag);
            }
            xmlSerializer.endTag("", TransactionTypesTag);
        }
        if (merchant.getCurrencies() != null && !merchant.getCurrencies().isEmpty()) {
            xmlSerializer.startTag("", CurrenciesTag);
            ChipDnaMobileSerializer.TQ(xmlSerializer, merchant.getCurrencies());
            xmlSerializer.endTag("", CurrenciesTag);
        }
        xmlSerializer.endTag("", MerchantTag);
    }

    public static MerchantData deserializeMerchantData(String merchantDataXml) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((Reader)new StringReader(merchantDataXml));
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, MerchantDataTag);
        MerchantData merchantData = new MerchantData(new ArrayList<Merchant>());
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2 || !xmlPullParser.getName().equals(MerchantTag)) continue;
            Merchant merchant = ChipDnaMobileSerializer.EL(xmlPullParser);
            merchantData.getMerchantList().add(merchant);
        }
        return merchantData;
    }

    private static Merchant EL(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        xmlPullParser.require(2, null, MerchantTag);
        Merchant merchant = new Merchant();
        merchant.EL(xmlPullParser.getAttributeValue(null, IdAttribute));
        merchant.cL(xmlPullParser.getAttributeValue(null, CategoryCodeAttribute));
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals("Name")) {
                merchant.TQ(ChipDnaMobileSerializer.TQ(xmlPullParser, "Name"));
                continue;
            }
            if (xmlPullParser.getName().equals(CardSchemesTag)) {
                merchant.TQ(ChipDnaMobileSerializer.cL(xmlPullParser));
                continue;
            }
            if (xmlPullParser.getName().equals(TransactionTypesTag)) {
                merchant.EL(ChipDnaMobileSerializer.zv(xmlPullParser));
                continue;
            }
            if (!xmlPullParser.getName().equals(CurrenciesTag)) continue;
            merchant.cL(ChipDnaMobileSerializer.dY(xmlPullParser));
        }
        return merchant;
    }

    private static ArrayList<CardSchemeID> cL(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        xmlPullParser.require(2, null, CardSchemesTag);
        ArrayList<CardSchemeID> arrayList = new ArrayList<CardSchemeID>();
        while (xmlPullParser.next() != 3) {
            String string;
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals(CardSchemeTag) && (string = xmlPullParser.getAttributeValue(null, IdAttribute)) != null) {
                arrayList.add(CardSchemeID.TQ(Integer.parseInt(string)));
            }
            xmlPullParser.next();
            xmlPullParser.require(3, null, CardSchemeTag);
        }
        return arrayList;
    }

    private static ArrayList<TransactionTypeID> zv(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        xmlPullParser.require(2, null, TransactionTypesTag);
        ArrayList<TransactionTypeID> arrayList = new ArrayList<TransactionTypeID>();
        while (xmlPullParser.next() != 3) {
            int n;
            TransactionTypeID transactionTypeID;
            if (xmlPullParser.getEventType() != 2) continue;
            if (xmlPullParser.getName().equals(TransactionTypeTag) && (transactionTypeID = TransactionTypeID.TQ(n = Integer.parseInt(xmlPullParser.getAttributeValue(null, IdAttribute)))) != null) {
                arrayList.add(transactionTypeID);
            }
            xmlPullParser.next();
            xmlPullParser.require(3, null, TransactionTypeTag);
        }
        return arrayList;
    }

    private static ArrayList<Currency> dY(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        xmlPullParser.require(2, null, CurrenciesTag);
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        while (xmlPullParser.next() != 3) {
            if (xmlPullParser.getEventType() != 2) continue;
            xmlPullParser.require(2, null, CurrencyTag);
            if (xmlPullParser.getName().equals(CurrencyTag)) {
                String string = xmlPullParser.getAttributeValue("", NumericCodeAttribute);
                String string2 = xmlPullParser.getAttributeValue("", CharCodeAttribute);
                String string3 = xmlPullParser.getAttributeValue("", SymbolAttribute);
                String string4 = xmlPullParser.getAttributeValue("", ExponentAttribute);
                arrayList.add(new Currency(string, string3, string2, Integer.parseInt(string4)));
            }
            xmlPullParser.next();
            xmlPullParser.require(3, null, CurrencyTag);
        }
        return arrayList;
    }
}

