/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import android.app.Activity;
import android.content.Context;
import com.creditcall.chipdnamobile.CCSDKWrapper;
import com.creditcall.chipdnamobile.CloudCommerceError;
import com.creditcall.chipdnamobile.CloudCommerceErrorKt;
import com.creditcall.chipdnamobile.CloudCommerceUtilsKt;
import com.creditcall.chipdnamobile.ICloudCommercePrepareListener;
import com.creditcall.chipdnamobile.ICloudCommerceRefreshTokenListener;
import com.creditcall.chipdnamobile.ICloudCommerceTransactionListener;
import com.creditcall.chipdnamobile.SdkUpgradeResponse;
import com.creditcall.chipdnamobile.TransactionResponse;
import com.creditcall.chipdnamobile.TransactionResponseKt;
import com.creditcall.chipdnamobile.TransactionUpdate;
import com.creditcall.chipdnamobile.UserNotification;
import com.mastercard.cpos.facade.exception.PaymentException;
import com.mastercard.cpos.facade.exception.PosException;
import com.mastercard.cpos.facade.model.CposSession;
import com.mastercard.cpos.facade.model.InitPaymentRequest;
import com.mastercard.cpos.facade.model.MerchantSettingsData;
import com.mastercard.cpos.facade.model.PaymentOutcomeResponse;
import com.mastercard.cpos.nfc.listener.NfcEventListener;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014JE\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001e\u0010\u001fJE\u0010%\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010)\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00192\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b)\u0010*J5\u0010\u0013\u001a\u00020,2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0013\u0010-R\u0014\u0010\u0013\u001a\u00020.8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010/R\u0018\u00101\u001a\u0004\u0018\u0001008\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102"}, d2={"Lcom/creditcall/chipdnamobile/CloudCommerceWrapper;", "", "<init>", "()V", "", "abortTransaction", "clearSession", "Landroid/content/Context;", "context", "initializeSDK", "(Landroid/content/Context;)V", "Landroid/app/Activity;", "p0", "Lcom/mastercard/cpos/facade/model/InitPaymentRequest;", "p1", "Lcom/creditcall/chipdnamobile/ICloudCommerceTransactionListener;", "p2", "Lio/reactivex/rxjava3/core/Observable;", "Lcom/mastercard/cpos/facade/model/PaymentOutcomeResponse;", "TQ", "(Landroid/app/Activity;Lcom/mastercard/cpos/facade/model/InitPaymentRequest;Lcom/creditcall/chipdnamobile/ICloudCommerceTransactionListener;)Lio/reactivex/rxjava3/core/Observable;", "activity", "", "amount", "tipAmount", "", "currencyCode", "countryCode", "orderId", "transactionListener", "performTransaction", "(Landroid/app/Activity;JJLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/creditcall/chipdnamobile/ICloudCommerceTransactionListener;)V", "certFingerprint", "token", "categoryCode", "Lcom/creditcall/chipdnamobile/ICloudCommercePrepareListener;", "prepareListener", "prepareSDK", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/creditcall/chipdnamobile/ICloudCommercePrepareListener;)V", "Lcom/creditcall/chipdnamobile/ICloudCommerceRefreshTokenListener;", "refreshListener", "refreshToken", "(Ljava/lang/String;Lcom/creditcall/chipdnamobile/ICloudCommerceRefreshTokenListener;)V", "p3", "Lio/reactivex/rxjava3/disposables/Disposable;", "(Lio/reactivex/rxjava3/core/Observable;Landroid/app/Activity;Lcom/mastercard/cpos/facade/model/InitPaymentRequest;Lcom/creditcall/chipdnamobile/ICloudCommerceTransactionListener;)Lio/reactivex/rxjava3/disposables/Disposable;", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "Lcom/creditcall/chipdnamobile/TransactionResponse;", "EL", "Lcom/creditcall/chipdnamobile/TransactionResponse;"})
public final class CloudCommerceWrapper {
    @NotNull
    private final CompositeDisposable TQ = new CompositeDisposable();
    @Nullable
    private TransactionResponse EL;

    public final void initializeSDK(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"");
        Timber.i((String)("initializing CCSDK - version " + CCSDKWrapper.INSTANCE.getVersion()), (Object[])new Object[0]);
        CCSDKWrapper.INSTANCE.initialize(context);
    }

    public final void prepareSDK(@NotNull Context context, @NotNull String certFingerprint, @NotNull String token, @NotNull String countryCode, @NotNull String currencyCode, @NotNull String categoryCode, final @NotNull ICloudCommercePrepareListener prepareListener) {
        MerchantSettingsData merchantSettingsData;
        Intrinsics.checkNotNullParameter((Object)context, (String)"");
        Intrinsics.checkNotNullParameter((Object)certFingerprint, (String)"");
        Intrinsics.checkNotNullParameter((Object)token, (String)"");
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"");
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"");
        Intrinsics.checkNotNullParameter((Object)categoryCode, (String)"");
        Intrinsics.checkNotNullParameter((Object)prepareListener, (String)"");
        Timber.i((String)("prepareSDK countryCode = " + countryCode + ", currencyCode = " + currencyCode + ", categoryCode = " + categoryCode), (Object[])new Object[0]);
        MerchantSettingsData merchantSettingsData2 = merchantSettingsData = new MerchantSettingsData();
        boolean bl = false;
        merchantSettingsData2.setMerchantCountryCode(countryCode);
        merchantSettingsData2.setMerchantCurrencyCode(currencyCode);
        merchantSettingsData2.setMerchantCategoryCode(categoryCode);
        MerchantSettingsData merchantSettingsData3 = merchantSettingsData;
        this.TQ.add(CCSDKWrapper.INSTANCE.prepare(context, certFingerprint, token, merchantSettingsData3).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribe(new Consumer(){

            public final void TQ(@NotNull CposSession cposSession) {
                Intrinsics.checkNotNullParameter((Object)cposSession, (String)"");
                com.mastercard.cpos.facade.model.SdkUpgradeResponse sdkUpgradeResponse = cposSession.getSdkUpgradeResponse();
                boolean bl = false;
                Timber.i((String)("Prepare finished with success, isForceUpgrade = " + sdkUpgradeResponse.isForceUpgrade() + ", isRecommendedUpgrade = " + sdkUpgradeResponse.isRecommendedUpgrade()), (Object[])new Object[0]);
                prepareListener.onPrepareFinished(new SdkUpgradeResponse(cposSession.getSdkUpgradeResponse().isForceUpgrade(), cposSession.getSdkUpgradeResponse().isRecommendedUpgrade()));
            }

            public /* synthetic */ void accept(Object t) {
                this.TQ((CposSession)t);
            }
        }, new Consumer(){

            public final void TQ(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"");
                CloudCommerceError cloudCommerceError = CloudCommerceErrorKt.toCloudCommerceError(throwable);
                Timber.e((String)("Prepare finished with error, CloudCommerceError = " + cloudCommerceError + ", Original message: " + throwable.getMessage()), (Object[])new Object[0]);
                prepareListener.onPrepareFailed(cloudCommerceError);
            }

            public /* synthetic */ void accept(Object t) {
                this.TQ((Throwable)t);
            }
        }));
    }

    public final void refreshToken(@NotNull String token, final @NotNull ICloudCommerceRefreshTokenListener refreshListener) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"");
        Intrinsics.checkNotNullParameter((Object)refreshListener, (String)"");
        Timber.i((String)"refreshToken", (Object[])new Object[0]);
        try {
            this.TQ.add(CCSDKWrapper.INSTANCE.refreshToken(token).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribe(new Consumer(){

                public final void TQ(@NotNull String string) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"");
                    Timber.d((String)("Refresh token finished with success, sessionId = " + string), (Object[])new Object[0]);
                    refreshListener.onRefreshSuccess();
                }

                public /* synthetic */ void accept(Object t) {
                    this.TQ((String)t);
                }
            }, new Consumer(){

                public final void TQ(@NotNull Throwable throwable) {
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"");
                    CloudCommerceError cloudCommerceError = CloudCommerceErrorKt.toCloudCommerceError(throwable);
                    Timber.e((String)("Refresh token finished with error, CloudCommerceError = " + cloudCommerceError + ", Original message: " + throwable.getMessage()), (Object[])new Object[0]);
                    refreshListener.onRefreshFailed(cloudCommerceError);
                }

                public /* synthetic */ void accept(Object t) {
                    this.TQ((Throwable)t);
                }
            }));
        }
        catch (PosException posException) {
            CloudCommerceError cloudCommerceError = CloudCommerceErrorKt.toCloudCommerceError(posException);
            Timber.e((String)("Refresh token failed with error, CloudCommerceError = " + cloudCommerceError + ", Original message: " + posException.getMessage()), (Object[])new Object[0]);
            refreshListener.onRefreshFailed(cloudCommerceError);
        }
    }

    public final void performTransaction(final @NotNull Activity activity, long amount, long tipAmount, @NotNull String currencyCode, @NotNull String countryCode, @NotNull String orderId, final @NotNull ICloudCommerceTransactionListener transactionListener) {
        InitPaymentRequest initPaymentRequest;
        InitPaymentRequest initPaymentRequest2;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"");
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"");
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"");
        Intrinsics.checkNotNullParameter((Object)orderId, (String)"");
        Intrinsics.checkNotNullParameter((Object)transactionListener, (String)"");
        InitPaymentRequest initPaymentRequest3 = initPaymentRequest2 = new InitPaymentRequest();
        boolean bl = false;
        initPaymentRequest3.setAmountAuthorizedNumeric(CloudCommerceUtilsKt.toAmountAuthorizedNumeric(amount));
        initPaymentRequest3.setTip(CloudCommerceUtilsKt.toAmountAuthorizedNumeric(tipAmount));
        initPaymentRequest3.setOrderId(orderId);
        initPaymentRequest3.setTransactionCurrencyCode(currencyCode);
        Pair[] pairArray = new Pair[]{new Pair((Object)"country", (Object)countryCode)};
        initPaymentRequest3.setConfigData(MapsKt.hashMapOf((Pair[])pairArray));
        initPaymentRequest2 = initPaymentRequest = initPaymentRequest2;
        boolean bl2 = false;
        Timber.i((String)("initiatePayment - amountAuthorizedNumeric = " + initPaymentRequest2.getAmountAuthorizedNumeric() + ", tip = " + initPaymentRequest2.getTip() + ", orderId = " + orderId + ", transactionCurrencyCode = " + initPaymentRequest2.getTransactionCurrencyCode() + ", configData = " + initPaymentRequest2.getConfigData()), (Object[])new Object[0]);
        Observable observable = CCSDKWrapper.INSTANCE.initiatePayment(activity, initPaymentRequest).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).flatMapObservable(new Function(){

            @NotNull
            public final ObservableSource<? extends PaymentOutcomeResponse> TQ(boolean bl) {
                Observable observable;
                if (bl) {
                    observable = this.TQ(activity, initPaymentRequest, transactionListener);
                } else {
                    Observable observable2 = Observable.error((Throwable)new Exception("Payment initiation failed"));
                    observable = observable2;
                    Intrinsics.checkNotNullExpressionValue((Object)observable2, (String)"");
                }
                return (ObservableSource)observable;
            }

            public /* synthetic */ Object apply(Object t) {
                return this.TQ((Boolean)t);
            }
        });
        CompositeDisposable compositeDisposable = this.TQ;
        bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"");
        compositeDisposable.add(this.TQ((Observable<PaymentOutcomeResponse>)observable, activity, initPaymentRequest, transactionListener));
    }

    private final Observable<PaymentOutcomeResponse> TQ(Activity activity, InitPaymentRequest initPaymentRequest, ICloudCommerceTransactionListener iCloudCommerceTransactionListener) {
        InitPaymentRequest initPaymentRequest2 = initPaymentRequest;
        boolean bl = false;
        Timber.i((String)("performTransaction - amountAuthorizedNumeric = " + initPaymentRequest2.getAmountAuthorizedNumeric() + ", tip = " + initPaymentRequest2.getTip() + ", transactionCurrencyCode = " + initPaymentRequest2.getTransactionCurrencyCode() + ", configData = " + initPaymentRequest2.getConfigData()), (Object[])new Object[0]);
        TransactionUpdate transactionUpdate = TransactionUpdate.CardEntryPrompted;
        Intrinsics.checkNotNullExpressionValue((Object)transactionUpdate, (String)"");
        iCloudCommerceTransactionListener.onTransactionUpdate(transactionUpdate);
        return CCSDKWrapper.INSTANCE.performTransaction(activity, initPaymentRequest, new NfcEventListener(){

            public void onTagDiscovered() {
                Timber.d((String)"onTagDiscovered", (Object[])new Object[0]);
            }

            public void onTagLost() {
                Timber.d((String)"onTagLost", (Object[])new Object[0]);
            }
        });
    }

    private final Disposable TQ(Observable<PaymentOutcomeResponse> observable, final Activity activity, final InitPaymentRequest initPaymentRequest, final ICloudCommerceTransactionListener iCloudCommerceTransactionListener) {
        Disposable disposable = observable.subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribe(new Consumer(){

            public final void TQ(@NotNull PaymentOutcomeResponse paymentOutcomeResponse) {
                block2: {
                    boolean bl;
                    Object object;
                    ICloudCommerceTransactionListener iCloudCommerceTransactionListener2;
                    Object object2;
                    Intrinsics.checkNotNullParameter((Object)paymentOutcomeResponse, (String)"");
                    Timber.d((String)("Transaction update paymentOutcomeResponse message: " + paymentOutcomeResponse.getMessage() + ", uirdMessageID: " + paymentOutcomeResponse.getUIRDMessageID()), (Object[])new Object[0]);
                    CharSequence charSequence = paymentOutcomeResponse.getTransactionOutcome();
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        EL = TransactionResponseKt.toTransactionResponse(paymentOutcomeResponse);
                        Timber.d((String)("Transaction update paymentOutcomeResponse message: " + EL), (Object[])new Object[0]);
                    }
                    TransactionUpdate transactionUpdate = TransactionResponseKt.mapToTransactionUpdate(paymentOutcomeResponse);
                    if (transactionUpdate != null) {
                        object2 = transactionUpdate;
                        iCloudCommerceTransactionListener2 = iCloudCommerceTransactionListener;
                        object = object2;
                        bl = false;
                        iCloudCommerceTransactionListener2.onTransactionUpdate((TransactionUpdate)object);
                    }
                    UserNotification userNotification = TransactionResponseKt.mapToUserNotification(paymentOutcomeResponse);
                    if (userNotification == null) break block2;
                    object2 = userNotification;
                    iCloudCommerceTransactionListener2 = iCloudCommerceTransactionListener;
                    object = object2;
                    bl = false;
                    iCloudCommerceTransactionListener2.onUserNotification((UserNotification)object);
                }
            }

            public /* synthetic */ void accept(Object t) {
                this.TQ((PaymentOutcomeResponse)t);
            }
        }, new Consumer(){

            public final void TQ(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"");
                CloudCommerceError cloudCommerceError = CloudCommerceErrorKt.toCloudCommerceError(throwable);
                Timber.e((String)("Failed to perform transaction: " + cloudCommerceError.getErrorCode() + " - Original message: " + throwable.getMessage()), (Object[])new Object[0]);
                CloudCommerceError cloudCommerceError2 = cloudCommerceError;
                if (cloudCommerceError2 instanceof CloudCommerceError.TryAgain) {
                    TQ.add(this.TQ((Observable<PaymentOutcomeResponse>)this.TQ(activity, initPaymentRequest, iCloudCommerceTransactionListener), activity, initPaymentRequest, iCloudCommerceTransactionListener));
                    UserNotification userNotification = UserNotification.TryCardAgain;
                    Intrinsics.checkNotNullExpressionValue((Object)userNotification, (String)"");
                    iCloudCommerceTransactionListener.onUserNotification(userNotification);
                } else if (cloudCommerceError2 instanceof CloudCommerceError.UseOtherCard) {
                    TQ.add(this.TQ((Observable<PaymentOutcomeResponse>)this.TQ(activity, initPaymentRequest, iCloudCommerceTransactionListener), activity, initPaymentRequest, iCloudCommerceTransactionListener));
                    UserNotification userNotification = UserNotification.UseOtherCard;
                    Intrinsics.checkNotNullExpressionValue((Object)userNotification, (String)"");
                    iCloudCommerceTransactionListener.onUserNotification(userNotification);
                } else {
                    iCloudCommerceTransactionListener.onTransactionError(cloudCommerceError);
                }
            }

            public /* synthetic */ void accept(Object t) {
                this.TQ((Throwable)t);
            }
        }, () -> CloudCommerceWrapper.TQ(this, iCloudCommerceTransactionListener));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"");
        return disposable;
    }

    public final void abortTransaction() {
        try {
            this.TQ.clear();
            CCSDKWrapper.INSTANCE.abortTransaction();
        }
        catch (PaymentException paymentException) {
            CloudCommerceError cloudCommerceError = CloudCommerceErrorKt.toCloudCommerceError(paymentException);
            Timber.w((String)("terminateTransaction failed with " + cloudCommerceError), (Object[])new Object[0]);
        }
    }

    public final void clearSession() {
        this.TQ.clear();
        try {
            CCSDKWrapper.INSTANCE.clearSession();
        }
        catch (PosException posException) {
            CloudCommerceError cloudCommerceError = CloudCommerceErrorKt.toCloudCommerceError(posException);
            Timber.w((String)("clearSession failed with " + cloudCommerceError), (Object[])new Object[0]);
        }
    }

    private static final void TQ(CloudCommerceWrapper cloudCommerceWrapper, ICloudCommerceTransactionListener iCloudCommerceTransactionListener) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)cloudCommerceWrapper, (String)"");
            Intrinsics.checkNotNullParameter((Object)iCloudCommerceTransactionListener, (String)"");
            Timber.d((String)"Transaction finished", (Object[])new Object[0]);
            TransactionResponse transactionResponse = cloudCommerceWrapper.EL;
            if (transactionResponse != null) {
                TransactionResponse transactionResponse2 = transactionResponse;
                boolean bl = false;
                iCloudCommerceTransactionListener.onTransactionFinished(transactionResponse2);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            iCloudCommerceTransactionListener.onTransactionError(new CloudCommerceError.GenericError("No transaction response available"));
        }
    }
}

