/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import com.creditcall.chipdnamobile.ConfigurationErrorCode;
import com.creditcall.chipdnamobile.ConfigurationException;
import com.creditcall.chipdnamobile.DefaultAmount;
import com.creditcall.chipdnamobile.Hk;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tR\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\r"}, d2={"Lcom/creditcall/chipdnamobile/DefaultAmountsConfiguration;", "", "", "jsonString", "<init>", "(Ljava/lang/String;)V", "", "exponent", "getCardDetailsAmount", "(I)Ljava/lang/String;", "", "Lcom/creditcall/chipdnamobile/DefaultAmount;", "TQ", "Ljava/util/Map;", "Companion"})
public final class DefaultAmountsConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, DefaultAmount> TQ;
    @NotNull
    public static final String CARD_DETAILS = "CardDetails";
    @NotNull
    public static final String MINOR = "minor";
    @NotNull
    public static final String MAJOR = "major";
    @NotNull
    private static final String EL = "type";
    @NotNull
    private static final String cL = "value";

    public DefaultAmountsConfiguration(@NotNull String jsonString) throws ConfigurationException {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"");
        try {
            JSONObject jSONObject = new JSONObject(jsonString);
            JSONObject jSONObject2 = jSONObject.getJSONObject(CARD_DETAILS);
            String string = jSONObject2.getString(EL);
            int n = jSONObject2.getInt(cL);
            if (!string.equals(MINOR) && !string.equals(MAJOR) || n < 0 || n > 10000) {
                Timber.w((String)"DefaultAmounts type or value not valid, type must be minor or major and value must be between 0 - 10000", (Object[])new Object[0]);
                throw new ConfigurationException(ConfigurationErrorCode.DefaultAmountsFormatError);
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            DefaultAmount defaultAmount = new DefaultAmount(string, n);
            Map map = new LinkedHashMap();
            map.put(CARD_DETAILS, defaultAmount);
            this.TQ = map;
        }
        catch (JSONException jSONException) {
            Timber.w((String)"Error parsing DefaultAmounts JSON string", (Object[])new Object[0]);
            throw new ConfigurationException(ConfigurationErrorCode.DefaultAmountsFormatError);
        }
    }

    @NotNull
    public final String getCardDetailsAmount(int exponent) {
        DefaultAmount defaultAmount = this.TQ.get(CARD_DETAILS);
        if (defaultAmount == null) {
            return "";
        }
        if (defaultAmount.getType().equals(MAJOR)) {
            String string = Hk.TQ((long)(Math.pow(10.0, exponent) * (double)defaultAmount.getValue()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            return string;
        }
        return String.valueOf(defaultAmount.getValue());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006"}, d2={"Lcom/creditcall/chipdnamobile/DefaultAmountsConfiguration$Companion;", "", "<init>", "()V", "", "CARD_DETAILS", "Ljava/lang/String;", "MAJOR", "MINOR", "EL", "TQ", "cL"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

