/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import androidx.annotation.VisibleForTesting;
import com.creditcall.chipdnamobile.CA;
import com.creditcall.chipdnamobile.ChipDnaMobileException;
import com.creditcall.chipdnamobile.FirmwareUpdateConfiguration;
import com.creditcall.chipdnamobile.FirmwareUpdateRequest;
import com.creditcall.chipdnamobile.FirmwareUpdateStatus;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0000\u0018\u0000 C2\u00020\u0001:\u0001CB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005Bs\b\u0001\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\n\u0012\b\b\u0002\u0010\u000e\u001a\u00020\n\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011\u00a2\u0006\u0004\b\u0004\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0011\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010\u001b\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\u0017H\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u001fJ\u000f\u0010!\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\n\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\n\u00a2\u0006\u0004\b%\u0010$J\r\u0010&\u001a\u00020\n\u00a2\u0006\u0004\b&\u0010$J\u0017\u0010\u0018\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020'H\u0002\u00a2\u0006\u0004\b\u0018\u0010)J\r\u0010*\u001a\u00020(\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010\u0018\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0005J\u001b\u0010-\u001a\u00020(2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011\u00a2\u0006\u0004\b-\u0010.J\r\u0010/\u001a\u00020(\u00a2\u0006\u0004\b/\u0010+J\r\u00100\u001a\u00020(\u00a2\u0006\u0004\b0\u0010+J\r\u00101\u001a\u00020(\u00a2\u0006\u0004\b1\u0010+J\u0015\u00104\u001a\u00020(2\u0006\u00103\u001a\u000202\u00a2\u0006\u0004\b4\u00105R\u0016\u0010\u0018\u001a\u00020\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u00106R\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0016\u0010:\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u00109R\u0016\u0010=\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0016\u0010?\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010<R\u0016\u0010;\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010<R\u0016\u0010>\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b?\u0010<R\u0016\u0010@\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b@\u00109R\u0016\u0010A\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\bA\u00109R\u0016\u00107\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010B"}, d2={"Lcom/creditcall/chipdnamobile/FirmwareUpdateProperty;", "", "", "device", "<init>", "(Ljava/lang/String;)V", "", "firmwareAvailableSince", "", "timeFrame", "", "firmwareUpdateComplete", "firmwareUpdateIncomplete", "firmwareUpdateAttempted", "firmwareUpdateAvailable", "lastAttemptedFirmwareUpdateTime", "lastSuccessfulFirmwareUpdateTime", "", "filesRequiringUpdate", "(JLjava/lang/String;IZZZZJJLjava/util/List;)V", "Lcom/creditcall/chipdnamobile/FirmwareUpdateRequest;", "EL", "()Lcom/creditcall/chipdnamobile/FirmwareUpdateRequest;", "Ljava/util/Date;", "TQ", "()Ljava/util/Date;", "currentDate", "daysUntilFirmwareUpdateCritical$ChipDnaMobileSDK_release", "(Ljava/util/Date;)I", "p0", "p1", "(Ljava/util/Date;Ljava/util/Date;)I", "Lcom/creditcall/chipdnamobile/FirmwareUpdateStatus;", "getFirmwareUpdateStatus", "()Lcom/creditcall/chipdnamobile/FirmwareUpdateStatus;", "isFirmwareUpdateAvailable", "()Z", "isFirmwareUpdateCritical", "isFirmwareUpdateIncomplete", "Ljava/util/Calendar;", "", "(Ljava/util/Calendar;)V", "save", "()V", "newFiles", "setFilesRequiringUpdate", "(Ljava/util/List;)V", "setFirmwareUpdateAttempted", "setFirmwareUpdateComplete", "setFirmwareUpdateIncomplete", "Lcom/creditcall/chipdnamobile/FirmwareUpdateConfiguration;", "firmwareUpdateConfiguration", "setTimeFrame", "(Lcom/creditcall/chipdnamobile/FirmwareUpdateConfiguration;)V", "Ljava/lang/String;", "VT", "Ljava/util/List;", "J", "cL", "rE", "Z", "zv", "dR", "dY", "NE", "dC", "I", "Companion"})
public final class FirmwareUpdateProperty {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long TQ;
    @NotNull
    private String EL;
    private int cL;
    private boolean zv;
    private boolean dY;
    private boolean rE;
    private boolean dR;
    private long NE;
    private long dC;
    @NotNull
    private List<String> VT;
    @Nullable
    private static FirmwareUpdateProperty uq;
    @NotNull
    public static final String DateTimeFormat = "yyyyMMddHHmmss";

    @VisibleForTesting
    public FirmwareUpdateProperty(long firmwareAvailableSince, @NotNull String device, int timeFrame, boolean firmwareUpdateComplete, boolean firmwareUpdateIncomplete, boolean firmwareUpdateAttempted, boolean firmwareUpdateAvailable, long lastAttemptedFirmwareUpdateTime, long lastSuccessfulFirmwareUpdateTime, @NotNull List<String> filesRequiringUpdate) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"");
        Intrinsics.checkNotNullParameter(filesRequiringUpdate, (String)"");
        this.TQ = firmwareAvailableSince;
        this.EL = device;
        this.cL = timeFrame;
        this.zv = firmwareUpdateComplete;
        this.dY = firmwareUpdateIncomplete;
        this.rE = firmwareUpdateAttempted;
        this.dR = firmwareUpdateAvailable;
        this.NE = lastAttemptedFirmwareUpdateTime;
        this.dC = lastSuccessfulFirmwareUpdateTime;
        this.VT = filesRequiringUpdate;
    }

    public /* synthetic */ FirmwareUpdateProperty(long l, String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, long l2, long l3, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            l = 0L;
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        if ((n2 & 4) != 0) {
            n = -1;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl4 = false;
        }
        if ((n2 & 0x80) != 0) {
            l2 = 0L;
        }
        if ((n2 & 0x100) != 0) {
            l3 = 0L;
        }
        if ((n2 & 0x200) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(l, string, n, bl, bl2, bl3, bl4, l2, l3, list);
    }

    public FirmwareUpdateProperty(@NotNull String device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"");
        this(0L, null, 0, false, false, false, false, 0L, 0L, null, 1023, null);
        if (uq == null) {
            throw new IllegalStateException("FirmwareUpdateProperty not initialized");
        }
        FirmwareUpdateProperty firmwareUpdateProperty = uq;
        Intrinsics.checkNotNull((Object)firmwareUpdateProperty);
        if (Intrinsics.areEqual((Object)firmwareUpdateProperty.EL, (Object)device)) {
            FirmwareUpdateProperty firmwareUpdateProperty2 = uq;
            Intrinsics.checkNotNull((Object)firmwareUpdateProperty2);
            Companion.copyInstanceVariables(firmwareUpdateProperty2, this);
        } else {
            this.TQ(device);
        }
    }

    private final void TQ(String string) {
        CA cA = CA.EL();
        FirmwareUpdateRequest firmwareUpdateRequest = cA.rE(string);
        if (firmwareUpdateRequest != null) {
            this.EL = firmwareUpdateRequest.getDeviceID();
            this.cL = firmwareUpdateRequest.getTimeFrame();
            this.zv = firmwareUpdateRequest.getUpdateComplete();
            this.dY = firmwareUpdateRequest.getUpdateIncomplete();
            this.dR = firmwareUpdateRequest.getUpdateRequired();
            this.NE = Long.parseLong(firmwareUpdateRequest.getLastAttemptedDateTime());
            this.dC = Long.parseLong(firmwareUpdateRequest.getLastSuccessfulDateTime());
            this.TQ = Long.parseLong(firmwareUpdateRequest.getUpdateAvailableDate());
            String[] stringArray = new String[]{","};
            this.VT = StringsKt.split$default((CharSequence)firmwareUpdateRequest.getFileRequiringUpdate(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        } else {
            this.TQ = 0L;
            this.EL = string;
            this.cL = -1;
            this.zv = false;
            this.dY = false;
            this.dR = false;
            this.NE = 0L;
            this.dC = 0L;
            this.TQ = 0L;
            this.VT = new ArrayList();
        }
    }

    public final void save() {
        Companion.copyInstanceVariables(this, Companion.getInstance());
        FirmwareUpdateRequest firmwareUpdateRequest = this.EL();
        CA cA = CA.EL();
        try {
            if (this.zv) {
                cA.cL(firmwareUpdateRequest);
            }
            if (cA.rE(this.EL) == null) {
                cA.TQ(this.EL());
            } else {
                cA.EL(firmwareUpdateRequest);
            }
        }
        catch (ChipDnaMobileException chipDnaMobileException) {
            Object[] objectArray = new Object[]{this.EL, chipDnaMobileException.getMessage()};
            Timber.w((Throwable)chipDnaMobileException, (String)"Failed to store firmware update data [device=%s, error=%s]", (Object[])objectArray);
        }
    }

    public final void setFirmwareUpdateComplete() {
        List list = new ArrayList();
        this.zv = true;
        this.cL = -1;
        this.TQ = 0L;
        this.dC = System.currentTimeMillis();
        this.dR = false;
        this.rE = false;
        this.dY = false;
        this.NE = 0L;
        this.VT = list;
    }

    public final void setFirmwareUpdateAttempted() {
        this.zv = false;
        this.rE = true;
        this.NE = System.currentTimeMillis();
        this.cL = 0;
    }

    public final void setFirmwareUpdateIncomplete() {
        this.zv = false;
        this.dY = true;
    }

    public final boolean isFirmwareUpdateAvailable() {
        return this.dR;
    }

    public final boolean isFirmwareUpdateCritical() {
        long l = System.currentTimeMillis() / (long)86400000;
        long l2 = this.TQ / (long)1000 / (long)86400 + (long)this.cL;
        return this.dR && this.cL > 0 && l >= l2 || this.cL == 0;
    }

    public final boolean isFirmwareUpdateIncomplete() {
        return this.dY || this.rE && !this.zv;
    }

    public final void setFilesRequiringUpdate(@NotNull List<String> newFiles) {
        Intrinsics.checkNotNullParameter(newFiles, (String)"");
        List list = CollectionsKt.toMutableList((Collection)newFiles);
        this.VT = CollectionsKt.toList((Iterable)list);
    }

    public final void setTimeFrame(@NotNull FirmwareUpdateConfiguration firmwareUpdateConfiguration) {
        Intrinsics.checkNotNullParameter((Object)firmwareUpdateConfiguration, (String)"");
        if (this.cL < 0 || firmwareUpdateConfiguration.getTimeFrame() != this.cL) {
            this.dR = true;
            this.zv = false;
            this.cL = firmwareUpdateConfiguration.getTimeFrame();
            this.TQ = System.currentTimeMillis();
        }
    }

    @VisibleForTesting
    public final int daysUntilFirmwareUpdateCritical$ChipDnaMobileSDK_release(@NotNull Date currentDate) {
        int n;
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"");
        Date date = this.TQ();
        if (date != null) {
            int n2;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(currentDate);
            Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"");
            this.TQ(calendar);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date);
            Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"");
            this.TQ(calendar2);
            Date date2 = calendar.getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"");
            Date date3 = calendar2.getTime();
            Intrinsics.checkNotNullExpressionValue((Object)date3, (String)"");
            n = n2 = this.TQ(date2, date3);
        } else {
            n = 0;
        }
        return n;
    }

    public static /* synthetic */ int daysUntilFirmwareUpdateCritical$ChipDnaMobileSDK_release$default(FirmwareUpdateProperty firmwareUpdateProperty, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            date = new Date();
        }
        return firmwareUpdateProperty.daysUntilFirmwareUpdateCritical$ChipDnaMobileSDK_release(date);
    }

    private final Date TQ() {
        if (this.TQ == 0L) {
            return null;
        }
        Date date = new Date(this.TQ);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, this.cL);
        return calendar.getTime();
    }

    private final void TQ(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private final int TQ(Date date, Date date2) {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"");
        this.TQ(calendar);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTime(date2);
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"");
        this.TQ(calendar2);
        long l = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
        int n = (int)(l / (long)86400000);
        return Math.max(n - 1, 0);
    }

    private final FirmwareUpdateRequest EL() {
        FirmwareUpdateRequest firmwareUpdateRequest = new FirmwareUpdateRequest(this.EL, String.valueOf(this.TQ), this.dR, this.isFirmwareUpdateIncomplete(), this.zv, String.valueOf(this.NE), String.valueOf(this.dC), CollectionsKt.joinToString$default((Iterable)this.VT, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), this.cL);
        return firmwareUpdateRequest;
    }

    @NotNull
    public final FirmwareUpdateStatus getFirmwareUpdateStatus() {
        String string;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateTimeFormat, Locale.getDefault());
        Date date = this.TQ();
        if (date != null) {
            Date date2 = date;
            boolean bl = false;
            string = simpleDateFormat.format(date2);
        } else {
            string = null;
        }
        Object object = string;
        String string2 = object == null ? "" : object;
        object = new FirmwareUpdateStatus(DateTimeFormat, String.valueOf(FirmwareUpdateProperty.daysUntilFirmwareUpdateCritical$ChipDnaMobileSDK_release$default(this, null, 1, null)), string2, this.VT);
        return object;
    }

    @VisibleForTesting
    public FirmwareUpdateProperty() {
        this(0L, null, 0, false, false, false, false, 0L, 0L, null, 1023, null);
    }

    @JvmStatic
    public static final synchronized void initialise() {
        Companion.initialise();
    }

    @JvmStatic
    public static final synchronized void dispose() {
        Companion.dispose();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\r\u0010\u0003R\u0014\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012"}, d2={"Lcom/creditcall/chipdnamobile/FirmwareUpdateProperty$Companion;", "", "<init>", "()V", "Lcom/creditcall/chipdnamobile/FirmwareUpdateProperty;", "instance", "newProperties", "", "copyInstanceVariables", "(Lcom/creditcall/chipdnamobile/FirmwareUpdateProperty;Lcom/creditcall/chipdnamobile/FirmwareUpdateProperty;)V", "dispose", "getInstance", "()Lcom/creditcall/chipdnamobile/FirmwareUpdateProperty;", "initialise", "", "DateTimeFormat", "Ljava/lang/String;", "uq", "Lcom/creditcall/chipdnamobile/FirmwareUpdateProperty;", "TQ"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final synchronized void initialise() {
            if (uq == null) {
                uq = new FirmwareUpdateProperty(0L, null, 0, false, false, false, false, 0L, 0L, null, 1023, null);
            }
        }

        @JvmStatic
        public final synchronized void dispose() {
            uq = null;
        }

        @NotNull
        public final FirmwareUpdateProperty getInstance() {
            FirmwareUpdateProperty firmwareUpdateProperty = uq;
            if (firmwareUpdateProperty == null) {
                throw new IllegalStateException("FirmwareUpdateProperty not initialized");
            }
            return firmwareUpdateProperty;
        }

        public final void copyInstanceVariables(@NotNull FirmwareUpdateProperty instance, @NotNull FirmwareUpdateProperty newProperties) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"");
            Intrinsics.checkNotNullParameter((Object)newProperties, (String)"");
            newProperties.dR = instance.dR;
            newProperties.rE = instance.rE;
            newProperties.dY = instance.dY;
            newProperties.zv = instance.zv;
            newProperties.NE = instance.NE;
            newProperties.dC = instance.dC;
            newProperties.cL = instance.cL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

