/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Handler;
import android.os.Process;
import androidx.annotation.VisibleForTesting;
import com.creditcall.ICCTag;
import com.creditcall.chipdnamobile.AbstractChipDnaMobileErrorCode;
import com.creditcall.chipdnamobile.Application;
import com.creditcall.chipdnamobile.CI;
import com.creditcall.chipdnamobile.CardSchemeID;
import com.creditcall.chipdnamobile.CardSchemeIdEnum;
import com.creditcall.chipdnamobile.ChipDnaMobile;
import com.creditcall.chipdnamobile.ChipDnaMobileException;
import com.creditcall.chipdnamobile.ChipDnaMobileProperties;
import com.creditcall.chipdnamobile.ChipDnaMobileUtils;
import com.creditcall.chipdnamobile.CompletionDetails;
import com.creditcall.chipdnamobile.ConfigurationErrorCode;
import com.creditcall.chipdnamobile.ConfigurationException;
import com.creditcall.chipdnamobile.De;
import com.creditcall.chipdnamobile.FirmwareUpdateProperty;
import com.creditcall.chipdnamobile.Gf;
import com.creditcall.chipdnamobile.Hk;
import com.creditcall.chipdnamobile.IdTechApplicationData;
import com.creditcall.chipdnamobile.IdTechCAPublicKeyData;
import com.creditcall.chipdnamobile.IdTechCardRemovalNotification;
import com.creditcall.chipdnamobile.IdTechConfigurationErrorCode;
import com.creditcall.chipdnamobile.IdTechConfigurationException;
import com.creditcall.chipdnamobile.IdTechConfigurationGenerator;
import com.creditcall.chipdnamobile.IdTechStateManager;
import com.creditcall.chipdnamobile.IdTechTerminalData;
import com.creditcall.chipdnamobile.ListenerCallback;
import com.creditcall.chipdnamobile.MY;
import com.creditcall.chipdnamobile.OnlineResult;
import com.creditcall.chipdnamobile.Parameters;
import com.creditcall.chipdnamobile.PaymentDeviceErrorCode;
import com.creditcall.chipdnamobile.PaymentDeviceException;
import com.creditcall.chipdnamobile.PinPad;
import com.creditcall.chipdnamobile.RequestResponse;
import com.creditcall.chipdnamobile.Sb;
import com.creditcall.chipdnamobile.TransactionDetails;
import com.creditcall.chipdnamobile.TransactionErrorCode;
import com.creditcall.chipdnamobile.TransactionException;
import com.creditcall.chipdnamobile.TransactionRegisterEntry;
import com.creditcall.chipdnamobile.TransactionResultEnum;
import com.creditcall.chipdnamobile.TransactionStateEnum;
import com.creditcall.chipdnamobile.TransactionTypeEnum;
import com.creditcall.chipdnamobile.TransactionUpdate;
import com.creditcall.chipdnamobile.UserNotification;
import com.creditcall.chipdnamobile.XO;
import com.creditcall.chipdnamobile.Yy;
import com.creditcall.chipdnamobile.bk;
import com.creditcall.chipdnamobile.hW;
import com.creditcall.chipdnamobile.mm;
import com.creditcall.chipdnamobile.qD;
import com.idtechproducts.device.Common;
import com.idtechproducts.device.ICCReaderStatusStruct;
import com.idtechproducts.device.IDTEMVData;
import com.idtechproducts.device.IDTMSRData;
import com.idtechproducts.device.IDT_NEO2;
import com.idtechproducts.device.OnReceiverListener;
import com.idtechproducts.device.ReaderInfo;
import com.idtechproducts.device.ResDataStruct;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateTool;
import com.idtechproducts.device.audiojack.tools.FirmwareUpdateToolMsg;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import timber.log.Timber;

class IdTechPinPad
extends PinPad
implements FirmwareUpdateToolMsg {
    private IDT_NEO2 dR;
    IDT_NEO2 TQ;
    private final EL NE;
    final IdTechStateManager EL = new IdTechStateManager();
    private final Object dC = new Object();
    protected int cL = 0;
    private final Object VT = new Object();
    ArrayList<Application> zv;
    ArrayList<Integer> dY = null;
    private volatile boolean uq = false;
    volatile boolean rE = true;
    private final int sw;
    private De De = new De();
    private boolean iQ = false;
    private cL Yy = new cL();
    private final hW.TQ Ai = new hW.TQ(){

        @Override
        public void TQ() {
            IdTechPinPad.this.pd();
        }

        @Override
        public void EL() {
            IdTechPinPad.this.dh();
        }

        @Override
        public void cL() {
            IdTechPinPad.this.iW();
        }
    };
    private final Object DU = new Object();
    private cL OI;
    private cL lz;
    private TimerTask Kx;
    private static HashMap<String, String> zB;
    private Integer eF;

    EL dC() {
        return this.NE;
    }

    IdTechPinPad(String pinpadName, Context context, PinPad.ConnectionType connectionType, int productId) throws PaymentDeviceException {
        super(pinpadName, context, connectionType);
        this.sw = productId;
        this.NE = new EL();
        this.Mx.EL(pinpadName);
        this.EL(context);
    }

    protected IDT_NEO2 TQ(hW hW2, Context context) {
        return new IDT_NEO2((OnReceiverListener)hW2, null, null, null, context);
    }

    protected Handler TQ(Context context) {
        return new Handler(context.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void EL(Context context) throws PaymentDeviceException {
        hW hW2 = new hW(this, this.Ai);
        Object object = new Object();
        Handler handler = this.TQ(context);
        Object object2 = object;
        synchronized (object2) {
            Runnable runnable = () -> {
                Object object2 = object;
                synchronized (object2) {
                    this.dR = this.TQ(hW2, context);
                    Timber.i((String)"ID Tech SDK Version: %s", (Object[])new Object[]{this.dR.config_getSDKVersion()});
                    object.notify();
                }
            };
            handler.post(runnable);
            try {
                object.wait(2000L);
            }
            catch (InterruptedException interruptedException) {
                Timber.w((Throwable)interruptedException, (String)"ID Tech device creation lock interrupted", (Object[])new Object[0]);
                throw new PaymentDeviceException(PaymentDeviceErrorCode.ConnectionFailed);
            }
        }
        if (this.dR == null) {
            Timber.w((String)"ID Tech device creation timed out", (Object[])new Object[0]);
            throw new PaymentDeviceException(PaymentDeviceErrorCode.ConnectionFailed);
        }
    }

    IDT_NEO2 Ut() {
        return this.dR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dh() {
        Timber.d((String)"Connected in State: %s", (Object[])new Object[]{this.EL.getCurrentState()});
        Object object = this.VT;
        synchronized (object) {
            if (this.EL.getCurrentState() != IdTechStateManager.State.Connecting) {
                Timber.d((String)"Connection Callback Ignored", (Object[])new Object[0]);
                return;
            }
            if (this.NE()) {
                this.VT.notifyAll();
                this.NE.TQ();
                this.TQ(true, (PaymentDeviceErrorCode)null);
                this.EL.setCurrentState(IdTechStateManager.State.Idle);
            } else {
                this.TQ(false, PaymentDeviceErrorCode.ConnectionFailed);
                this.EL.setCurrentState(IdTechStateManager.State.NotConnected);
            }
        }
    }

    private void pd() {
        Timber.d((String)"Disconnected in State: %s", (Object[])new Object[]{this.EL.getCurrentState().name()});
        if (this.EL.getCurrentState() == IdTechStateManager.State.Firmware) {
            Timber.d((String)"Disconnection Callback Ignored during Firmware Update", (Object[])new Object[0]);
            return;
        }
        if (this.rE) {
            Timber.d((String)"Disconnection Callback Ignored", (Object[])new Object[0]);
            return;
        }
        this.rE = true;
        this.yS.add(TransactionErrorCode.PinpadConnectionClosed);
        if (this.EL.getCurrentState() == IdTechStateManager.State.Connecting) {
            this.TQ(false, PaymentDeviceErrorCode.ConnectionFailed);
            this.EL.setCurrentState(IdTechStateManager.State.NotConnected);
        } else if (this.NE.EL != null) {
            this.NE.EL.clear();
            this.NE.TQ(new TQ(ActionType.Disconnected));
        }
        if (this.OI != null) {
            this.OI.EL = true;
        }
        if (this.lz != null) {
            this.lz.EL = true;
        }
        this.a_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void TQ(boolean bl, boolean bl2) throws ConfigurationException {
        Timber.i((String)"Configuring", (Object[])new Object[0]);
        Object object = this.dC;
        synchronized (object) {
            if (this.EL.getCurrentState() != IdTechStateManager.State.Idle && this.EL.getCurrentState() != IdTechStateManager.State.NotConnected) {
                throw new ConfigurationException(ConfigurationErrorCode.DeviceBusy);
            }
            this.EL.setCurrentState(IdTechStateManager.State.Configuring);
        }
        object = new FirmwareUpdateProperty(this.Mx.getName());
        if (this.Ai()) {
            ArrayList<String> arrayList = this.DU();
            if (bl) {
                ((FirmwareUpdateProperty)object).setTimeFrame(this.Gf.LH());
                ((FirmwareUpdateProperty)object).setFilesRequiringUpdate(arrayList);
                ((FirmwareUpdateProperty)object).save();
            }
            if (bl2 || ((FirmwareUpdateProperty)object).isFirmwareUpdateIncomplete()) {
                Timber.i((String)"Firmware required to update", (Object[])new Object[0]);
                this.NE.TQ(new TQ(ActionType.PinPadSoftwareUpdate, arrayList));
            } else if (((FirmwareUpdateProperty)object).isFirmwareUpdateCritical()) {
                Timber.i((String)"Firmware Update is critical and you are required to update before using PinPad", (Object[])new Object[0]);
                this.TQ((Boolean)false, (AbstractChipDnaMobileErrorCode)ConfigurationErrorCode.FirmwareUpdateRequired);
                this.EL.setCurrentState(IdTechStateManager.State.Idle);
            } else {
                Timber.d((String)"Continue with configuration", (Object[])new Object[0]);
                this.NE.TQ(new TQ(ActionType.PinPadConfiguring, bl));
            }
        } else {
            if (((FirmwareUpdateProperty)object).isFirmwareUpdateAvailable()) {
                ((FirmwareUpdateProperty)object).setFirmwareUpdateComplete();
                ((FirmwareUpdateProperty)object).save();
            }
            Timber.i((String)"Firmware update is not required. Continue to configure pin pad", (Object[])new Object[0]);
            this.NE.TQ(new TQ(ActionType.PinPadConfiguring, bl));
        }
    }

    private List<String> TQ(boolean bl) throws IdTechConfigurationException {
        ArrayList<String> arrayList = null;
        try {
            int n = -1;
            ResDataStruct resDataStruct = new ResDataStruct();
            n = bl ? this.dR.ctls_retrieveAidList(resDataStruct) : this.dR.emv_retrieveAidList(resDataStruct);
            if (n == 61024 || resDataStruct.stringArray == null) {
                Timber.i((String)"No AID List to retrieve", (Object[])new Object[0]);
                return new ArrayList<String>();
            }
            if (n != 0) {
                Timber.w((String)("Failed to get AID List, Error: " + this.dR.device_getResponseCodeString(n)), (Object[])new Object[0]);
                throw new IdTechConfigurationException(IdTechConfigurationErrorCode.FAILED_TO_RETRIEVE_DEVICE_CONFIGURATION);
            }
            arrayList = new ArrayList<String>(Arrays.asList(resDataStruct.stringArray));
        }
        catch (Exception exception) {
            Timber.w((Throwable)exception, (String)"Failed to get AID List", (Object[])new Object[0]);
            throw new IdTechConfigurationException(IdTechConfigurationErrorCode.FAILED_TO_RETRIEVE_DEVICE_CONFIGURATION);
        }
        return arrayList;
    }

    private ArrayList<MY> dY(boolean bl) {
        ArrayList<MY> arrayList;
        block8: {
            arrayList = new ArrayList<MY>();
            try {
                if (!this.NE()) {
                    throw new Exception("Device is not connected");
                }
                ResDataStruct resDataStruct = new ResDataStruct();
                int n = bl ? this.dR.ctls_retrieveCAPKList(resDataStruct) : this.dR.emv_retrieveCAPKList(resDataStruct);
                if (n == 0) {
                    if (resDataStruct.statusCode == 0) {
                        if (resDataStruct.resData != null) {
                            byte[] byArray = new byte[6];
                            for (int i = 0; i < resDataStruct.resData.length; i += 6) {
                                System.arraycopy(resDataStruct.resData, i, byArray, 0, 6);
                                byte[] byArray2 = new byte[byArray.length - 1];
                                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                                byte by2 = byArray[byArray.length - 1];
                                arrayList.add(new MY(com.creditcall.chipdnamobile.Yy.TQ(byArray2, byArray2.length), null, String.format("%02X", by2), null, null, null, null));
                            }
                        }
                        break block8;
                    }
                    throw new Exception(String.format(Locale.US, "%02X ", resDataStruct.statusCode));
                }
                if (n == 61024) {
                    Timber.i((String)"No CAPK List to retrieve", (Object[])new Object[0]);
                    return new ArrayList<MY>();
                }
                throw new Exception(this.dR.device_getResponseCodeString(n));
            }
            catch (Exception exception) {
                Timber.w((Throwable)exception, (String)"Failed to get Capk List", (Object[])new Object[0]);
            }
        }
        return arrayList;
    }

    @SuppressLint(value={"TimberArgCount"})
    private void TQ(Boolean bl) {
        if (!bl.booleanValue()) {
            Timber.i((String)"Not updating configuration as no TMS Update took place", (Object[])new Object[0]);
            this.EL.setCurrentState(IdTechStateManager.State.Idle);
            this.TQ((Boolean)true, (AbstractChipDnaMobileErrorCode)null);
            return;
        }
        Timber.i((String)"Updating configuration", (Object[])new Object[0]);
        this.Vo();
        IdTechConfigurationGenerator idTechConfigurationGenerator = new IdTechConfigurationGenerator(this.Gf);
        try {
            boolean bl2;
            String string = this.Gf.Kx().rE;
            String string2 = this.Gf.zB().EL;
            Map<String, String> map = this.mm();
            boolean bl3 = this.cL(map.get("Terminal Configuration"), string);
            if (!bl3) {
                this.EL(idTechConfigurationGenerator);
            }
            if (!(bl2 = this.cL(map.get("CAP Keys"), string2))) {
                this.TQ(idTechConfigurationGenerator);
            }
            if (!bl3 || !bl2) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Terminal Configuration", string);
                hashMap.put("CAP Keys", string2);
                this.TQ(hashMap);
            }
            this.tP();
            this.PG();
            this.EL.setCurrentState(IdTechStateManager.State.Idle);
            this.TQ((Boolean)true, (AbstractChipDnaMobileErrorCode)null);
        }
        catch (IdTechConfigurationException idTechConfigurationException) {
            Timber.w((Throwable)idTechConfigurationException, (String)"Failed to configure. Error %s", (Object[])new Object[]{idTechConfigurationException.getIdTechConfigurationErrorCode()});
            this.zV();
        }
        catch (NullPointerException nullPointerException) {
            Timber.w((Throwable)nullPointerException, (String)"Failed to configure. Error %s", (Object[])new Object[]{nullPointerException.getMessage()});
            this.zV();
        }
    }

    private void EL(IdTechConfigurationGenerator idTechConfigurationGenerator) throws IdTechConfigurationException {
        String string;
        Object object;
        Object object2;
        IdTechTerminalData idTechTerminalData = idTechConfigurationGenerator.getTerminalData(false);
        int n = idTechTerminalData.getTerminalMajorConfiguration();
        if (n <= 0) {
            throw new IdTechConfigurationException(IdTechConfigurationErrorCode.INVALID_TERMINAL_MAJOR_CONFIGURATION);
        }
        Timber.i((String)"Setting terminal major configuration to %s", (Object[])new Object[]{n});
        this.dR.emv_setTerminalMajorConfiguration(n);
        ResDataStruct resDataStruct = new ResDataStruct();
        this.dR.emv_removeTerminalData(resDataStruct);
        if (resDataStruct.statusCode == 0) {
            Timber.i((String)"Successfully removed EMV Terminal Data", (Object[])new Object[0]);
        } else if (resDataStruct.statusCode == 61024) {
            Timber.i((String)"No EMV Terminal Data to remove", (Object[])new Object[0]);
        } else {
            Timber.w((String)"Failed to remove EMV Terminal Data %s", (Object[])new Object[]{this.dR.device_getResponseCodeString(resDataStruct.statusCode)});
            throw new IdTechConfigurationException(IdTechConfigurationErrorCode.FAILED_TO_REMOVE_CONFIGURATION_DATA);
        }
        String string2 = ChipDnaMobileUtils.TQ(idTechTerminalData.getTlvStringHashMap());
        byte[] byArray = Common.getByteArray((String)string2);
        this.dR.emv_setTerminalData(byArray, resDataStruct);
        if (resDataStruct.statusCode != 0) {
            Timber.w((String)"Failed to load EMV Terminal Data %s", (Object[])new Object[]{this.dR.device_getResponseCodeString(resDataStruct.statusCode)});
            throw new IdTechConfigurationException(IdTechConfigurationErrorCode.FAILED_TO_UPLOAD_CONFIGURATION_DATA);
        }
        Timber.i((String)"Successfully loaded EMV Terminal Data", (Object[])new Object[0]);
        IdTechTerminalData idTechTerminalData2 = idTechConfigurationGenerator.getTerminalData(true);
        ResDataStruct resDataStruct2 = new ResDataStruct();
        string2 = ChipDnaMobileUtils.TQ(idTechTerminalData2.getTlvStringHashMap());
        byte[] byArray2 = Common.getByteArray((String)string2);
        int n2 = this.dR.ctls_setTerminalData(byArray2, resDataStruct2);
        if (resDataStruct2.statusCode != 0) {
            Timber.w((String)"Failed to load Ctls Terminal Data %s", (Object[])new Object[]{this.dR.device_getResponseCodeString(n2)});
            throw new IdTechConfigurationException(IdTechConfigurationErrorCode.FAILED_TO_UPLOAD_CONFIGURATION_DATA);
        }
        Timber.i((String)"Successfully loaded Ctls Terminal Data", (Object[])new Object[0]);
        List<IdTechApplicationData> list2 = idTechConfigurationGenerator.getEmvApplicationData();
        List<String> list3 = this.TQ(false);
        ArrayList arrayList = new ArrayList();
        for (String list4 : list3) {
            object2 = new ResDataStruct();
            this.dR.emv_removeApplicationData(list4, (ResDataStruct)object2);
            if (((ResDataStruct)object2).statusCode == 0 || ((ResDataStruct)object2).statusCode == 61024) {
                Timber.i((String)"Successfully delete emv application data", (Object[])new Object[0]);
                continue;
            }
            Timber.w((String)"Failed to delete EMV Application Data: %s. Status Code %s", (Object[])new Object[]{list4, ((ResDataStruct)object2).statusCode});
            throw new IdTechConfigurationException(IdTechConfigurationErrorCode.FAILED_TO_REMOVE_CONFIGURATION_DATA);
        }
        for (IdTechApplicationData idTechApplicationData : list2) {
            object2 = new ResDataStruct();
            this.dR.emv_setApplicationData(idTechApplicationData.getAid(), idTechApplicationData.getTlvData(), (ResDataStruct)object2);
            if (((ResDataStruct)object2).statusCode != 0) {
                Timber.w((String)"Failed to load EMV Application Data: %s. Status Code %s", (Object[])new Object[]{idTechApplicationData.getAid(), ((ResDataStruct)object2).statusCode});
                throw new IdTechConfigurationException(IdTechConfigurationErrorCode.FAILED_TO_UPLOAD_CONFIGURATION_DATA);
            }
            Timber.i((String)"Successfully loaded EMV Application Data: %s", (Object[])new Object[]{idTechApplicationData.getAid()});
        }
        List<IdTechApplicationData> list5 = idTechConfigurationGenerator.getContactlessApplicationData();
        List<IdTechApplicationData> list = idTechConfigurationGenerator.getContactlessGroupData();
        object2 = this.TQ(true);
        for (IdTechApplicationData idTechApplicationData : list) {
            object = new ArrayList<Yy.TQ>(com.creditcall.chipdnamobile.Yy.TQ(idTechApplicationData.getTlvData(), 0, idTechApplicationData.getTlvData().length));
            Timber.i((String)"Updating CTLS Group Data: %s", (Object[])new Object[]{idTechApplicationData.getAid()});
            string = idTechConfigurationGenerator.getIDTechTlvHex((ArrayList<Yy.TQ>)object);
            byte[] byArray3 = Common.getByteArray((String)string);
            ResDataStruct resDataStruct3 = new ResDataStruct();
            this.dR.ctls_setConfigurationGroup(byArray3, resDataStruct3);
            if (resDataStruct3.statusCode != 0) {
                Timber.w((String)"Failed to update CTLS Group Data: %s. Status Code %s", (Object[])new Object[]{idTechApplicationData.getAid(), resDataStruct3.statusCode});
                throw new IdTechConfigurationException(IdTechConfigurationErrorCode.FAILED_TO_UPLOAD_CONFIGURATION_DATA);
            }
            Timber.i((String)"Successfully updated CTLS Application Data: %s", (Object[])new Object[]{idTechApplicationData.getAid()});
        }
        Iterator<IdTechApplicationData> iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)((Object)iterator.next());
            object = new ResDataStruct();
            this.dR.ctls_removeApplicationData(string3, object);
            if (object.statusCode == 0 || object.statusCode == 61024) {
                Timber.i((String)"Successfully delete CTLS application data: %s", (Object[])new Object[]{string3});
                continue;
            }
            Timber.w((String)"Failed to delete CTLS Application Data: %s. Status Code %s", (Object[])new Object[]{string3, object.statusCode});
            throw new IdTechConfigurationException(IdTechConfigurationErrorCode.FAILED_TO_REMOVE_CONFIGURATION_DATA);
        }
        iterator = list5.iterator();
        while (iterator.hasNext()) {
            IdTechApplicationData idTechApplicationData = iterator.next();
            Timber.i((String)"Adding CTLS Application Data: %s", (Object[])new Object[]{idTechApplicationData.getAid()});
            object = idTechApplicationData.getTlvData();
            string = new ResDataStruct();
            this.dR.ctls_setApplicationData((byte[])object, (ResDataStruct)string);
            if (((ResDataStruct)string).statusCode != 0) {
                Timber.w((String)"Failed to add CTLS Application Data: %s. Status Code %s", (Object[])new Object[]{idTechApplicationData.getAid(), ((ResDataStruct)string).statusCode});
                throw new IdTechConfigurationException(IdTechConfigurationErrorCode.FAILED_TO_UPLOAD_CONFIGURATION_DATA);
            }
            Timber.i((String)"Successfully added CTLS Application Data: %s", (Object[])new Object[]{idTechApplicationData.getAid()});
        }
    }

    public void TQ(IdTechConfigurationGenerator idTechConfigurationGenerator) throws IdTechConfigurationException {
        ResDataStruct resDataStruct;
        IdTechCAPublicKeyData idTechCAPublicKeyData2;
        Object object;
        List<IdTechCAPublicKeyData> list2 = idTechConfigurationGenerator.getEMVCAPublicKeyData(false);
        List<IdTechCAPublicKeyData> list3 = idTechConfigurationGenerator.getEMVDeviceCAPublicKeyData(this.dY(false));
        ResDataStruct resDataStruct2 = new ResDataStruct();
        if (list2 != list3) {
            object = new ResDataStruct();
            for (IdTechCAPublicKeyData idTechCAPublicKeyData2 : list3) {
                if (list2.contains(idTechCAPublicKeyData2)) continue;
                Timber.i((String)"CAPublicKey to remove: (RID:%s Index:%02X)", (Object[])new Object[]{com.creditcall.chipdnamobile.Yy.TQ(idTechCAPublicKeyData2.ridIndexArray(), idTechCAPublicKeyData2.ridIndexArray().length), idTechCAPublicKeyData2.getIndex()});
                this.dR.emv_removeCAPK(idTechCAPublicKeyData2.ridIndexArray(), (ResDataStruct)object);
                if (((ResDataStruct)object).statusCode != 0 && ((ResDataStruct)object).statusCode != 61024) {
                    Timber.w((String)"Failed to delete EMV CAPublicKey Data: (RID:%s Index:%02X). Status Code %s", (Object[])new Object[]{com.creditcall.chipdnamobile.Yy.TQ(idTechCAPublicKeyData2.getRid(), idTechCAPublicKeyData2.getRid().length), idTechCAPublicKeyData2.getIndex(), ((ResDataStruct)object).statusCode});
                    this.zV();
                    return;
                }
                Timber.i((String)"Successfully deleted EMV CAPublicKey Data: (RID:%s Index:%02X)", (Object[])new Object[]{com.creditcall.chipdnamobile.Yy.TQ(idTechCAPublicKeyData2.getRid(), idTechCAPublicKeyData2.getRid().length), idTechCAPublicKeyData2.getIndex()});
            }
        }
        for (IdTechCAPublicKeyData idTechCAPublicKeyData3 : list2) {
            if (list3.size() == 0) {
                this.dR.emv_setCAPK(idTechCAPublicKeyData3.asByteArray(), resDataStruct2);
            } else {
                if (list3.contains(idTechCAPublicKeyData3)) continue;
                this.dR.emv_setCAPK(idTechCAPublicKeyData3.asByteArray(), resDataStruct2);
            }
            if (resDataStruct2.statusCode != 0) {
                Timber.w((String)"Failed to load EMV CAPublicKey Data: (RID:%s Index:%02X). Status Code %s", (Object[])new Object[]{com.creditcall.chipdnamobile.Yy.TQ(idTechCAPublicKeyData3.getRid(), idTechCAPublicKeyData3.getRid().length), idTechCAPublicKeyData3.getIndex(), resDataStruct2.statusCode});
                this.zV();
                return;
            }
            Timber.i((String)"Successfully loaded EMV CAPublicKey Data: (RID:%s Index:%02X)", (Object[])new Object[]{com.creditcall.chipdnamobile.Yy.TQ(idTechCAPublicKeyData3.getRid(), idTechCAPublicKeyData3.getRid().length), idTechCAPublicKeyData3.getIndex()});
        }
        object = idTechConfigurationGenerator.getEMVCAPublicKeyData(true);
        List<IdTechCAPublicKeyData> list = idTechConfigurationGenerator.getEMVDeviceCAPublicKeyData(this.dY(true));
        idTechCAPublicKeyData2 = new ResDataStruct();
        if (object != list) {
            resDataStruct = new ResDataStruct();
            for (IdTechCAPublicKeyData idTechCAPublicKeyData4 : list) {
                if (object.contains(idTechCAPublicKeyData4)) continue;
                Timber.i((String)"CTLS CAPublicKey to remove: (RID:%s Index:%02X)", (Object[])new Object[]{com.creditcall.chipdnamobile.Yy.TQ(idTechCAPublicKeyData4.ridIndexArray(), idTechCAPublicKeyData4.ridIndexArray().length), idTechCAPublicKeyData4.getIndex()});
                this.dR.ctls_removeCAPK(idTechCAPublicKeyData4.ridIndexArray(), (ResDataStruct)idTechCAPublicKeyData2);
                if (((ResDataStruct)idTechCAPublicKeyData2).statusCode != 0 && ((ResDataStruct)idTechCAPublicKeyData2).statusCode != 61024) {
                    Timber.w((String)"Failed to delete CTLS CAPublicKey Data: (RID:%s Index:%02X). Status Code %s", (Object[])new Object[]{com.creditcall.chipdnamobile.Yy.TQ(idTechCAPublicKeyData4.getRid(), idTechCAPublicKeyData4.getRid().length), idTechCAPublicKeyData4.getIndex(), resDataStruct.statusCode});
                    this.zV();
                    return;
                }
                Timber.i((String)"Successfully deleted CTLS CAPublicKey Data: (RID:%s Index:%02X)", (Object[])new Object[]{com.creditcall.chipdnamobile.Yy.TQ(idTechCAPublicKeyData4.getRid(), idTechCAPublicKeyData4.getRid().length), idTechCAPublicKeyData4.getIndex()});
            }
        }
        resDataStruct = object.iterator();
        while (resDataStruct.hasNext()) {
            IdTechCAPublicKeyData idTechCAPublicKeyData5 = (IdTechCAPublicKeyData)resDataStruct.next();
            if (list.size() == 0) {
                this.dR.ctls_setCAPK(idTechCAPublicKeyData5.asByteArray(), (ResDataStruct)idTechCAPublicKeyData2);
            } else {
                if (list.contains(idTechCAPublicKeyData5)) continue;
                this.dR.ctls_setCAPK(idTechCAPublicKeyData5.asByteArray(), (ResDataStruct)idTechCAPublicKeyData2);
            }
            if (((ResDataStruct)idTechCAPublicKeyData2).statusCode != 0) {
                Timber.w((String)"Failed to load CTLS CAPublicKey Data: (RID:%s Index:%02X). Status Code %s", (Object[])new Object[]{com.creditcall.chipdnamobile.Yy.TQ(idTechCAPublicKeyData5.getRid(), idTechCAPublicKeyData5.getRid().length), idTechCAPublicKeyData5.getIndex(), ((ResDataStruct)idTechCAPublicKeyData2).statusCode});
                this.zV();
                return;
            }
            Timber.i((String)"Successfully loaded CTLS CAPublicKey Data: (RID:%s Index:%02X)", (Object[])new Object[]{com.creditcall.chipdnamobile.Yy.TQ(idTechCAPublicKeyData5.getRid(), idTechCAPublicKeyData5.getRid().length), idTechCAPublicKeyData5.getIndex()});
        }
    }

    public Map<String, String> mm() {
        Timber.i((String)"Getting device config versions", (Object[])new Object[0]);
        Object var1_1 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<Yy.TQ> arrayList = this.cL(0);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Yy.TQ tQ = arrayList.get(i);
                if (!tQ.TQ().equalsIgnoreCase("DFEF58")) continue;
                String string = new String(tQ.cL());
                Timber.i((String)("Current device configuration versions: " + string), (Object[])new Object[0]);
                String[] stringArray = string.split(",");
                if (stringArray.length > 0) {
                    hashMap.put("Terminal Configuration", stringArray[0]);
                }
                if (stringArray.length == 2) {
                    hashMap.put("CAP Keys", stringArray[1]);
                }
                return hashMap;
            }
        }
        return hashMap;
    }

    private boolean cL(String string, String string2) {
        Timber.i((String)"Device Version: %s, TMS Version: %s", (Object[])new Object[]{string, string2});
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public void TQ(Map<String, String> map) {
        ResDataStruct resDataStruct = new ResDataStruct();
        String string = String.format("%s,%s", map.get("Terminal Configuration"), map.get("CAP Keys"));
        String string2 = com.creditcall.chipdnamobile.Yy.zv(string);
        int n = com.creditcall.chipdnamobile.Yy.TQ(string2).length;
        String string3 = String.format("%X", n);
        string3 = ChipDnaMobileUtils.TQ(string3, '0', 2);
        string2 = string3 + string2;
        String string4 = "DFEF58" + string2;
        this.dR.device_sendDataCommand("0400", false, string4, resDataStruct);
        if (resDataStruct.statusCode != 0) {
            Timber.w((String)"Failed to set configuration version error: %d", (Object[])new Object[]{resDataStruct.statusCode});
            return;
        }
        Timber.i((String)"Updated configuration version on device to: %s", (Object[])new Object[]{string});
    }

    private void PG() {
        String string = Integer.toHexString(this.Gf.pZ());
        String string2 = "DF7F01";
        string = ChipDnaMobileUtils.TQ(string, '0', 2);
        String string3 = string2 + string;
        Timber.i((String)"ID Tech SDK set collision detection request: %s", (Object[])new Object[]{string3});
        ResDataStruct resDataStruct = new ResDataStruct();
        try {
            this.dR.device_sendDataCommand("0400", false, string3, resDataStruct);
        }
        catch (Exception exception) {
            Timber.w((Throwable)exception, (String)"Failed to set collision detection", (Object[])new Object[0]);
            return;
        }
        if (resDataStruct.statusCode != 0) {
            Timber.w((String)"Failed to set collision detection, error: %s", (Object[])new Object[]{this.dR.device_getResponseCodeString(resDataStruct.statusCode)});
        }
        Timber.i((String)"ID Tech SDK set collision detection to %s, response: %s", (Object[])new Object[]{this.Gf.pZ(), this.dR.device_getResponseCodeString(resDataStruct.statusCode)});
    }

    private void tP() {
        String string;
        String string2;
        String string3;
        String string4;
        if (!this.Gf.sM()) {
            string4 = "030000";
            Timber.i((String)"ID Tech SDK turn off low power mode request: %s", (Object[])new Object[]{string4});
            string3 = "turn off low power mode";
        } else {
            string2 = Integer.toHexString(this.Gf.lP());
            string = "03";
            string2 = ChipDnaMobileUtils.TQ(string2, '0', 4);
            string4 = string + string2;
            Timber.i((String)"ID Tech SDK set standby time request: %s", (Object[])new Object[]{string4});
            string3 = "set standby time to " + this.Gf.lP();
        }
        this.zv(string4, string3);
        string2 = Integer.toHexString(this.Gf.vE());
        string = "04";
        string2 = ChipDnaMobileUtils.TQ(string2, '0', 4);
        string4 = string + string2;
        Timber.i((String)"ID Tech SDK set sleep time request: %s", (Object[])new Object[]{string4});
        string3 = "set sleep time to " + this.Gf.vE();
        this.zv(string4, string3);
    }

    private void zv(String string, String string2) {
        ResDataStruct resDataStruct = new ResDataStruct();
        int n = this.dR.device_sendDataCommand("F004", false, string, resDataStruct);
        if (resDataStruct.statusCode != 0) {
            Timber.w((String)"Failed to %s, error: %s", (Object[])new Object[]{string2, this.dR.device_getResponseCodeString(resDataStruct.statusCode)});
        }
        Timber.i((String)"ID Tech SDK %s response: %s", (Object[])new Object[]{string2, this.dR.device_getResponseCodeString(resDataStruct.statusCode)});
    }

    void XO() {
        IdTechCardRemovalNotification idTechCardRemovalNotification = this.Gf.Ff();
        if (idTechCardRemovalNotification == null) {
            Timber.i((String)"No card removal notification", (Object[])new Object[0]);
            return;
        }
        ResDataStruct resDataStruct = new ResDataStruct();
        String string = idTechCardRemovalNotification.constructCommand();
        Timber.d((String)"ID Tech SDK card removal notification request: %s", (Object[])new Object[]{string});
        this.dR.device_sendDataCommand("0102", false, string, resDataStruct);
        if (resDataStruct.statusCode != 0) {
            Timber.w((String)"Failed to send card removal notification, error code: %s", (Object[])new Object[]{this.dR.device_getResponseCodeString(resDataStruct.statusCode)});
        }
        Timber.d((String)"Sent card removal notification, response: %s", (Object[])new Object[]{this.dR.device_getResponseCodeString(resDataStruct.statusCode)});
    }

    private void zV() {
        this.Yy();
        if (this.NE()) {
            this.TQ((Boolean)false, (AbstractChipDnaMobileErrorCode)ConfigurationErrorCode.IncompatibleDeviceConfiguration);
            this.rE();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void EL() throws PaymentDeviceException {
        Object object = this.dC;
        synchronized (object) {
            if (this.EL.getCurrentState() != IdTechStateManager.State.Idle && this.EL.getCurrentState() != IdTechStateManager.State.NotConnected && this.EL.getCurrentState() != IdTechStateManager.State.Connecting) {
                throw new PaymentDeviceException(PaymentDeviceErrorCode.DeviceBusy);
            }
            this.EL.setCurrentState(IdTechStateManager.State.CheckingPinPadInfo);
        }
        this.NE.TQ(new TQ(ActionType.GetPinPadInformation));
    }

    private void Tk() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean bl = false;
                PaymentDeviceErrorCode paymentDeviceErrorCode = null;
                try {
                    Timber.i((String)"Getting pin pad info", (Object[])new Object[0]);
                    IdTechPinPad.this.Mx.rE("IDTech");
                    IdTechPinPad.this.Mx.dR("VP3350");
                    IdTechPinPad.this.Mx.NE("VP3350 FW");
                    IdTechPinPad.this.Mx.dC(IdTechPinPad.this.BW());
                    IdTechPinPad.this.Mx.VT(IdTechPinPad.this.Ra());
                    IdTechPinPad.this.Mx.uq(IdTechPinPad.this.TQ(IdTechPinPad.this.Mx.getFirmwareVersion(), IdTechPinPad.this.LO()));
                    IdTechPinPad.this.iQ();
                    IdTechPinPad.this.zv();
                    bl = true;
                }
                catch (Exception exception) {
                    Timber.w((Throwable)exception, (String)"Failed to get pin pad info", (Object[])new Object[0]);
                    bl = false;
                    paymentDeviceErrorCode = PaymentDeviceErrorCode.tA;
                }
                finally {
                    if (IdTechPinPad.this.NE()) {
                        IdTechPinPad.this.EL.setCurrentState(IdTechStateManager.State.Idle);
                        IdTechPinPad.this.EL(bl, paymentDeviceErrorCode);
                        if (!bl) {
                            IdTechPinPad.this.rE();
                        }
                    }
                }
            }
        }.start();
    }

    @VisibleForTesting
    public String TQ(String string, String string2) throws Exception {
        String string3;
        if (string == null || string.isEmpty()) {
            throw new Exception("Firmware version is null or empty when trying to create device revision");
        }
        String string4 = "";
        String string5 = "PRJ_";
        Timber.d((String)"Device tree: %s", (Object[])new Object[]{string2});
        if (string2 != null && !string2.isEmpty()) {
            if (string2.contains(string5 + "C")) {
                string4 = string4 + "BLE";
            } else if (string2.contains(string5 + "F")) {
                string4 = string4 + "USB";
            } else if (string2.contains(string5 + "D")) {
                string4 = string4 + "USB-FEMALE";
            } else {
                throw new Exception("Unrecognised device tree " + string2 + ", when trying to create device revision");
            }
        }
        if ((string3 = string.substring(string.length() - 2)).equals(".T") || string3.equals(".S")) {
            string4 = string4 + "-SRED";
        } else if (string3.equals(".D") || !string3.contains(".")) {
            string4 = string4 + "-NON-SRED";
        } else {
            throw new Exception("Unrecognised firmware suffix " + string3 + ", when trying to create device revision");
        }
        Timber.d((String)"Device revision: %s", (Object[])new Object[]{string4});
        return string4;
    }

    @Override
    protected void TQ(int n) throws PaymentDeviceException {
        Timber.i((String)"connect to pin pad", (Object[])new Object[0]);
        if (this.dR.device_setDeviceType(ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB, this.sw)) {
            this.dR.device_setNEOGen(3);
        }
        this.EL.setCurrentState(IdTechStateManager.State.Connecting);
        this.rE = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                IdTechPinPad.this.dR.registerListen();
            }
        }).start();
    }

    private void Oh() {
        if (this.TQ != null) {
            Timber.i((String)"Closing last device on connect", (Object[])new Object[0]);
            try {
                this.TQ.unregisterListen();
                this.TQ.release();
            }
            catch (Exception exception) {
                Timber.w((Throwable)exception, (String)"Error closing last device on connect", (Object[])new Object[0]);
            }
            this.TQ = null;
        }
    }

    @Override
    protected void TQ(final BluetoothManager bluetoothManager, final int n, final int n2) throws PaymentDeviceException {
        Timber.i((String)"Connecting to pin pad", (Object[])new Object[0]);
        this.Oh();
        this.rE = false;
        if (this.dR == null) {
            this.EL(this.Vo);
        }
        this.EL.setCurrentState(IdTechStateManager.State.Connecting);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = IdTechPinPad.this.VT;
                synchronized (object) {
                    int n5;
                    int n22;
                    try {
                        if (IdTechPinPad.this.dR.device_setDeviceType(ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT)) {
                            IdTechPinPad.this.dR.device_setNEOGen(3);
                        }
                    }
                    catch (Exception exception) {
                        Timber.w((Throwable)exception, (String)"Error setting device type", (Object[])new Object[0]);
                        IdTechPinPad.this.pl();
                        IdTechPinPad.this.TQ(false, PaymentDeviceErrorCode.ConnectionFailed);
                        IdTechPinPad.this.EL.setCurrentState(IdTechStateManager.State.NotConnected);
                        return;
                    }
                    int n3 = n22 = n != 0 ? n : 5000;
                    if (com.creditcall.chipdnamobile.Gf.TQ(bluetoothManager, IdTechPinPad.this.Qg)) {
                        Timber.d((String)"Selected device paired", (Object[])new Object[0]);
                        n5 = IdTechPinPad.this.dR.device_enableBLESearch(IdTechPinPad.this.dR.device_getDeviceType(), IdTechPinPad.this.Qg, n22);
                    } else {
                        int n4 = IdTechPinPad.this.EL(n22);
                        if (n4 == -1) {
                            Timber.d((String)"Selected device not found in scan list", (Object[])new Object[0]);
                            IdTechPinPad.this.pl();
                            IdTechPinPad.this.TQ(false, PaymentDeviceErrorCode.ConnectionFailed);
                            return;
                        }
                        n5 = IdTechPinPad.this.dR.device_enableBLESearch(IdTechPinPad.this.dR.device_getDeviceType(), n4, n22);
                    }
                    IdTechPinPad.this.TQ(n5, n2);
                }
            }
        }.start();
    }

    private int EL(int n) {
        ArrayList arrayList = this.dR.device_scanDevices(n);
        if (arrayList.isEmpty()) {
            Timber.d((String)"No devices found", (Object[])new Object[0]);
            return -1;
        }
        for (String string : arrayList) {
            if (!string.equals(this.Qg)) continue;
            Timber.d((String)"Found device %s", (Object[])new Object[]{string});
            return arrayList.indexOf(string);
        }
        return -1;
    }

    private void TQ(int n, int n2) {
        switch (n) {
            case 0: {
                Timber.i((String)"BLE search successful", (Object[])new Object[0]);
                if (this.EL.getCurrentState() != IdTechStateManager.State.Idle) {
                    try {
                        this.VT.wait(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        Timber.w((Throwable)interruptedException, (String)"Connection Timeout Interrupted", (Object[])new Object[0]);
                    }
                }
                if (this.EL.getCurrentState() == IdTechStateManager.State.Idle) break;
                Timber.w((String)"BLE search timed out", (Object[])new Object[0]);
                this.pl();
                this.TQ(false, PaymentDeviceErrorCode.TimeOut);
                break;
            }
            case 1: {
                this.pl();
                this.TQ(false, PaymentDeviceErrorCode.InvalidDevice);
                break;
            }
            case 2: {
                this.pl();
                this.TQ(false, PaymentDeviceErrorCode.BluetoothNotSupported);
                break;
            }
            case 3: {
                this.pl();
                this.TQ(false, PaymentDeviceErrorCode.DeviceBusy);
                break;
            }
            case 4: {
                this.pl();
                this.TQ(false, PaymentDeviceErrorCode.BluetoothNotEnabled);
                break;
            }
            case 5: {
                this.pl();
                this.TQ(false, PaymentDeviceErrorCode.DeviceNotPaired);
                break;
            }
            default: {
                this.pl();
                this.TQ(false, PaymentDeviceErrorCode.General);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void rE() {
        Timber.i((String)"Close connection", (Object[])new Object[0]);
        Object object = this.DU;
        synchronized (object) {
            if (this.dR != null) {
                this.pl();
            }
            this.EL.setCurrentState(IdTechStateManager.State.NotConnected);
            this.yS();
        }
    }

    @Override
    void dR() {
        Timber.i((String)"Close connection without listener call", (Object[])new Object[0]);
        if (this.dR != null) {
            this.pl();
        }
        this.EL.setCurrentState(IdTechStateManager.State.NotConnected);
    }

    private void pl() {
        try {
            if (this.dR.device_getDeviceType().equals((Object)ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) && this.NE()) {
                this.dR.device_disconnectBLE();
                this.dR.unregisterListen();
                this.dR.release();
            } else if (this.dR.device_getDeviceType().equals((Object)ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_USB)) {
                this.dR.unregisterListen();
                this.dR.release();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Timber.w((Throwable)illegalArgumentException, (String)"Error closing connection", (Object[])new Object[0]);
        }
        if (this.Pb == PinPad.ConnectionType.BluetoothLowEnergy) {
            this.TQ = this.dR;
        }
        this.dR = null;
        this.De = null;
    }

    void iW() {
        if (this.TQ == null) {
            Timber.d((String)"No last device to close", (Object[])new Object[0]);
            return;
        }
        Timber.i((String)"Close last BLE connection", (Object[])new Object[0]);
        try {
            if (this.TQ.device_getDeviceType().equals((Object)ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) && this.TQ.device_isConnected()) {
                this.TQ.device_disconnectBLE();
                this.TQ.unregisterListen();
                this.TQ.release();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Timber.w((Throwable)illegalArgumentException, (String)"Error closing last BLE connection", (Object[])new Object[0]);
        }
        this.TQ = null;
    }

    @Override
    boolean NE() {
        if (this.dR != null && !this.rE) {
            return this.dR.device_isConnected();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void VT() {
        Object object = this.dC;
        synchronized (object) {
            if (this.EL.getCurrentState() != IdTechStateManager.State.Idle) {
                this.TQ(TransactionErrorCode.UnableToStartPinpadTransaction);
                return;
            }
            this.uq = false;
            this.zv = null;
            this.EL.setCurrentState(IdTechStateManager.State.StartingTransaction);
        }
        if (this.lz != null) {
            this.lz.TQ();
        }
        this.dY = null;
        this.cL = 0;
        this.NE.TQ(new TQ(ActionType.StartTransaction));
    }

    private void Wa() {
        Timber.i((String)"Begin transaction", (Object[])new Object[0]);
        this.TQ(TransactionUpdate.StartingTransaction);
        IDT_NEO2.emv_allowFallback((boolean)true);
        if (!(this.Gf.CI() || this.Gf.vU() || this.Gf.CV())) {
            this.TQ(TransactionErrorCode.NoInterfacesEnabled);
            this.EL.setCurrentState(IdTechStateManager.State.Idle);
            return;
        }
        if (this.jk.Ao) {
            this.TQ(this.TQ(true, false, false));
        } else {
            this.TQ(this.TQ(this.Gf.CI(), this.Gf.vU(), this.Gf.CV()));
        }
    }

    private void rE(boolean bl) {
        Timber.i((String)"Begin MSR Fallback transaction", (Object[])new Object[0]);
        if (bl) {
            this.dR.device_cancelTransaction();
        }
        if (this.Gf.CI()) {
            this.jk.EL = true;
            this.OI = new cL();
            this.TQ(TransactionUpdate.SmartcardRemovePrompted);
            this.XO();
            try {
                if (!this.OI.TQ(30000L, 1000L)) {
                    this.yS.add(TransactionErrorCode.TimeOutError);
                    this.NE.TQ(new TQ(ActionType.TransactionTerminated));
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                this.yS.add(TransactionErrorCode.TransactionAbortedError);
                this.NE.TQ(new TQ(ActionType.TransactionTerminated));
                return;
            }
            this.TQ(UserNotification.MSRFallback);
            if (!(this.Gf.CI() || this.Gf.vU() || this.Gf.CV())) {
                this.TQ(TransactionErrorCode.NoInterfacesEnabled);
                this.EL.setCurrentState(IdTechStateManager.State.Idle);
                return;
            }
            this.TQ(this.TQ(this.Gf.CI(), false, false));
        } else {
            this.yS.add(TransactionErrorCode.MagstripeInterfaceNotEnabledEMVFallbackNotPossible);
            this.NE.TQ(new TQ(ActionType.TransactionTerminated));
        }
    }

    private void TQ(ArrayList<Integer> arrayList) {
        if (this.Su == PinPad.InterfaceType.ContactMag) {
            Timber.d((String)"Not updating Mastercard contactless TAC Denial for refund as we are using contact mag", (Object[])new Object[0]);
            return;
        }
        IdTechConfigurationGenerator idTechConfigurationGenerator = new IdTechConfigurationGenerator(this.Gf);
        ArrayList<Yy.TQ> arrayList2 = this.cL(128);
        if (arrayList2 == null) {
            Timber.w((String)"Failed to get Mastercard contactless configuration group", (Object[])new Object[0]);
            return;
        }
        ArrayList<Yy.TQ> arrayList3 = new ArrayList<Yy.TQ>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (arrayList2.get(i).TQ().equalsIgnoreCase("DF8121")) {
                this.dY = arrayList2.get(i).EL();
                arrayList3.add(new Yy.TQ("DF8121", arrayList));
                continue;
            }
            arrayList3.add(arrayList2.get(i));
        }
        String string = idTechConfigurationGenerator.getIDTechTlvHex(arrayList3);
        byte[] byArray = Common.getByteArray((String)string);
        int n = this.dR.ctls_setConfigurationGroup(byArray, new ResDataStruct());
        if (n != 0) {
            Timber.w((String)"Failed to updatd Mastercard contactless TAC Denial for refund; Error code: %s", (Object[])new Object[]{n});
        } else {
            Timber.d((String)"Updated Mastercard contactless TAC Denial for refund", (Object[])new Object[0]);
        }
    }

    private ArrayList<Yy.TQ> cL(int n) {
        ResDataStruct resDataStruct = new ResDataStruct();
        int n2 = this.dR.ctls_getConfigurationGroup(n, resDataStruct);
        if (n2 != 0) {
            Timber.w((String)"Failed to get contactless configuration group %d; Error code: %s", (Object[])new Object[]{n, n2});
            return null;
        }
        return new ArrayList<Yy.TQ>(com.creditcall.chipdnamobile.Yy.TQ(resDataStruct.resData, 0, resDataStruct.resData.length));
    }

    private void TQ(byte[] byArray) {
        int n;
        Timber.i((String)"Prompting for card", (Object[])new Object[0]);
        this.EL.setCurrentState(IdTechStateManager.State.PromptingForCard);
        this.jk.dC = true;
        if (this.uD == TransactionTypeEnum.ACCOUNT_VERIFICATION || this.jk.CA) {
            this.Sy = "0";
        }
        if (this.uD == TransactionTypeEnum.REFUND) {
            this.TQ(com.creditcall.chipdnamobile.Yy.EL("FFFFFFFFFF"));
            n = this.dR.device_startTransaction(Double.parseDouble(Hk.TQ(this.Sy, this.Gf.Ut().getExponent(), this.gd)), 0.0, 32, 30, byArray);
        } else {
            n = this.dR.device_startTransaction(Double.parseDouble(Hk.TQ(this.Sy, this.Gf.Ut().getExponent(), this.gd)), 0.0, 0, 30, byArray);
        }
        if (n == 0) {
            this.TQ(TransactionUpdate.CardEntryPrompted);
        } else {
            Timber.w((String)"Failed to start transaction with error: %s", (Object[])new Object[]{this.dR.device_getResponseCodeString(n)});
            if (n == 61024) {
                this.TQ(TransactionErrorCode.ConfigurationError);
            } else {
                this.TQ(TransactionErrorCode.TransactionAbortedError);
            }
            this.EL.setCurrentState(IdTechStateManager.State.Idle);
        }
    }

    private byte[] TQ(boolean bl, boolean bl2, boolean bl3) {
        byte by2 = 0;
        if (bl) {
            by2 = (byte)(by2 + 1);
        }
        if (bl3) {
            by2 = (byte)(by2 + 2);
        }
        if (bl2) {
            by2 = (byte)(by2 + 4);
        }
        XO xO = new XO(14675767, new byte[]{by2});
        return com.creditcall.chipdnamobile.mm.TQ(xO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void TQ(Application application) {
        Object object = this.OI.TQ;
        synchronized (object) {
            this.dR.emv_lcdControlResponse((byte)1, (byte)application.getPriority());
        }
    }

    private void RH() {
        Timber.i((String)"Language selection", (Object[])new Object[0]);
        this.EL.setCurrentState(IdTechStateManager.State.LanguageSelection);
        this.dR.emv_lcdControlResponse((byte)8, (byte)1);
        this.EL.setCurrentState(this.EL.getLastState() != null ? this.EL.getLastState() : IdTechStateManager.State.NotConnected);
    }

    private void EL(IDTEMVData iDTEMVData) {
        this.De.EL(1);
        Boolean bl = this.TQ(iDTEMVData);
        if (this.EL.getCurrentState() == IdTechStateManager.State.Callback) {
            this.yS.add(TransactionErrorCode.TimeOutError);
            this.NE.TQ(new TQ(ActionType.TransactionTerminated));
            return;
        }
        Timber.i((String)"Processing EMV card read", (Object[])new Object[0]);
        this.EL.setCurrentState(IdTechStateManager.State.EmvCardRead);
        if (!bl.booleanValue()) {
            Timber.w((String)"Unable to create encrypted card details", (Object[])new Object[0]);
            this.dR.device_cancelTransaction();
            this.yS.add(TransactionErrorCode.RequestEncryptionFailed);
            this.NE.TQ(new TQ(ActionType.TransactionTerminated));
            return;
        }
        if (this.jk.CA) {
            this.NE.TQ(new TQ(ActionType.CompleteGetCardDetails));
            return;
        }
        Hashtable<String, ArrayList<Integer>> hashtable = new Hashtable<String, ArrayList<Integer>>();
        for (ICCTag iCCTag : this.tP) {
            hashtable.put(iCCTag.getID().replace("0x", "").toLowerCase(), com.creditcall.chipdnamobile.Yy.EL(iCCTag.getValue()));
        }
        this.TQ(hashtable);
        if (Hk.NE(Hk.NE(this.tP))) {
            this.yS.add(TransactionErrorCode.AtmCashOnlyCard);
            this.NE.TQ(new TQ(ActionType.TransactionTerminated));
            return;
        }
        if (this.jk.Mx) {
            this.NE.TQ(new TQ(ActionType.ProcessOfflineApproved));
        } else {
            this.NE.TQ(new TQ(ActionType.OnlineAuthorisation));
        }
    }

    private void EL(Map<String, byte[]> map) {
        if (map != null) {
            byte[] byArray;
            byte[] byArray2 = map.get("5A");
            if (byArray2 != null) {
                int n = byArray2.length;
                this.wj = Hk.TQ(com.creditcall.chipdnamobile.Yy.TQ(byArray2, n), 6);
            }
            if ((byArray = map.get("57")) != null) {
                int n = byArray.length;
                this.rS = Hk.TQ(com.creditcall.chipdnamobile.Yy.TQ(byArray, n));
            }
        }
        if (this.wj != null) {
            this.wj = this.TQ(this.wj);
        }
        if (this.rS != null) {
            this.rS = this.TQ(this.rS);
        }
    }

    private String TQ(String string) {
        return string.replace("c", "*");
    }

    private void EL(IDTMSRData iDTMSRData) {
        this.De.EL(1);
        Timber.i((String)"Processing Magstripe Card Read", (Object[])new Object[0]);
        if (this.EL.getCurrentState() != IdTechStateManager.State.PromptingForCard) {
            Timber.w((String)"Received Magstripe Card Read outside of a transaction", (Object[])new Object[0]);
            return;
        }
        this.TQ(TransactionUpdate.CardSwiped);
        this.EL.setCurrentState(IdTechStateManager.State.MagstripeCardRead);
        this.Su = PinPad.InterfaceType.ContactMag;
        this.LP();
        if (iDTMSRData.unencryptedTags != null && com.creditcall.chipdnamobile.Yy.TQ((byte[])iDTMSRData.unencryptedTags.get("DFEE25"), 2).equalsIgnoreCase("3012")) {
            this.yS.add(TransactionErrorCode.SwipeReadFailure);
            this.NE.TQ(new TQ(ActionType.TransactionTerminated));
            return;
        }
        if (iDTMSRData.encTrack2 == null || iDTMSRData.KSN == null || iDTMSRData.track2 == null) {
            if (iDTMSRData.track2 != null && Hk.dC(iDTMSRData.track2) && (iDTMSRData.KSN == null || iDTMSRData.KSN.length == 0)) {
                if (this.Gf.Yy()) {
                    this.PT = iDTMSRData.track2;
                    this.dC(this.PT);
                    this.jk.Nu = true;
                    if (this.jk.CA) {
                        this.NE.TQ(new TQ(ActionType.CompleteGetCardDetails));
                        return;
                    }
                }
                this.yS.add(TransactionErrorCode.AllowlistedCardPresented);
                this.NE.TQ(new TQ(ActionType.TransactionTerminated));
                return;
            }
            Timber.w((String)"Failed to retrieve magstripe data", (Object[])new Object[0]);
            this.yS.add(TransactionErrorCode.CardDetailsUnavailable);
            this.NE.TQ(new TQ(ActionType.TransactionTerminated));
            return;
        }
        this.Sd = com.creditcall.chipdnamobile.Yy.TQ(iDTMSRData.encTrack2, iDTMSRData.encTrack2.length);
        this.rS = iDTMSRData.track2;
        this.dh = com.creditcall.chipdnamobile.Yy.TQ(iDTMSRData.KSN, iDTMSRData.KSN.length);
        this.wj = Hk.EL(iDTMSRData.track2);
        if (iDTMSRData.track1 != null) {
            this.HZ = iDTMSRData.track1;
            this.Uw = Hk.cL(iDTMSRData.track1);
            this.an = Hk.dY(this.Uw);
            this.LP = Hk.rE(this.Uw);
        }
        this.HD = ChipDnaMobileUtils.og(iDTMSRData.track2);
        this.TQ(this.wj, this.rS, this.HD, true, null);
        this.jk.Nu = true;
        if (this.jk.CA) {
            this.NE.TQ(new TQ(ActionType.CompleteGetCardDetails));
            return;
        }
        if (Hk.NE(Hk.De(iDTMSRData.track2))) {
            this.yS.add(TransactionErrorCode.AtmCashOnlyCard);
            this.NE.TQ(new TQ(ActionType.TransactionTerminated));
            return;
        }
        this.NE.TQ(new TQ(ActionType.OnlineAuthorisation));
    }

    private void re() {
        if (this.jk.Ut && this.Gf.Su() && this.fG == null && !this.bj()) {
            this.OJ = TransactionResultEnum.Declined;
        } else {
            Timber.i((String)"Processing online", (Object[])new Object[0]);
            this.EL.setCurrentState(IdTechStateManager.State.OnlineAuthorisation);
            this.Sd();
            this.yS.addAll(this.Fx.LO());
            Timber.i((String)"Processing online complete", (Object[])new Object[0]);
        }
        if (this.HD == null && this.Fx != null && this.Fx.Pb() != null) {
            this.HD = this.Fx.Pb();
        }
        if (this.Su == PinPad.InterfaceType.ContactEMV) {
            this.CV();
        } else if (this.Fx == null) {
            this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
        } else if (this.Su == PinPad.InterfaceType.ContactMag && this.Fx.mm() == OnlineResult.Empty) {
            this.NE.TQ(new TQ(ActionType.ProcessMagstripeOffline));
        } else if (this.Fx.mm() == OnlineResult.Empty) {
            this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
        } else if (this.Fx.mm() == OnlineResult.Approved) {
            this.NE.TQ(new TQ(ActionType.ProcessOnlineApproved));
        } else if (this.Fx.mm() == OnlineResult.PartialApproval) {
            this.NE.TQ(new TQ(ActionType.ProcessPartialApproval));
        } else if (this.Fx.mm() == OnlineResult.Declined) {
            this.OJ = TransactionResultEnum.Declined;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
        }
        this.jk.iW = true;
    }

    private void cL(IDTEMVData iDTEMVData) {
        Timber.i((String)"Process approved online", (Object[])new Object[0]);
        if (this.EL.getCurrentState() == IdTechStateManager.State.Idle) {
            Timber.w((String)"Transaction already completed, no need to process approved online", (Object[])new Object[0]);
            return;
        }
        this.TQ(iDTEMVData);
        if (this.Ya()) {
            this.OJ = TransactionResultEnum.Approved;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionApproved));
        } else {
            this.OJ = TransactionResultEnum.Declined;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
        }
    }

    private void cL(IDTMSRData iDTMSRData) {
        this.De.EL(1);
        this.TQ(iDTMSRData);
        this.dR((IDTEMVData)null);
    }

    private void zv(IDTEMVData iDTEMVData) {
        this.De.EL(1);
        this.TQ(iDTEMVData);
        if (this.uD == TransactionTypeEnum.REFUND) {
            try {
                CardSchemeID cardSchemeID;
                if (this.wj != null && this.tP != null && !this.tP.isEmpty() && (cardSchemeID = CardSchemeID.EL(this.wj.substring(0, 6))) == CardSchemeID.MasterCard) {
                    this.TQ(TransactionUpdate.CardTapped);
                    this.dC().TQ(new TQ(ActionType.OnlineAuthorisation));
                    return;
                }
            }
            catch (Exception exception) {
                Timber.w((String)"Error creating transaction data. Just continue.", (Object[])new Object[0]);
            }
        }
        this.dC().TQ(new TQ(ActionType.ResetContactlessCardInterface, true));
    }

    private void AN() {
        Timber.i((String)"Process Magstripe Offline", (Object[])new Object[0]);
        if (this.uD == TransactionTypeEnum.ACCOUNT_VERIFICATION) {
            this.yS.add(TransactionErrorCode.AccountVerificationOfflineNotAllowed);
            this.OJ = TransactionResultEnum.Declined;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
        } else if (this.jk.Ao) {
            if (this.Ya()) {
                this.OJ = TransactionResultEnum.Approved;
                this.NE.TQ(new TQ(ActionType.CompleteTransactionApproved));
            } else {
                this.OJ = TransactionResultEnum.Declined;
                this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
            }
        } else if (!this.Gf.re() && this.uD == TransactionTypeEnum.SALE) {
            this.OJ = TransactionResultEnum.Declined;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
        } else if (!this.rE(this.HD)) {
            this.OJ = TransactionResultEnum.Declined;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
        } else {
            String string = Hk.TQ(this.Sy, this.gd);
            if (this.Gf.zV() && com.creditcall.chipdnamobile.bk.TQ(string, this.Gf.Tk())) {
                if (this.Ya()) {
                    this.jk.Gf = true;
                    this.OJ = TransactionResultEnum.Approved;
                    this.jk.Mx = true;
                    this.NE.TQ(new TQ(ActionType.CompleteTransactionApproved));
                } else {
                    this.OJ = TransactionResultEnum.Declined;
                    this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
                }
            } else if (this.wj()) {
                this.NE.TQ(new TQ(ActionType.ProcessDeferredAuth));
            } else if (this.Gf.AN() && !this.jk.oF) {
                this.NE.TQ(new TQ(ActionType.ProcessForcedAcceptance));
            } else {
                this.OJ = TransactionResultEnum.Declined;
                this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
            }
        }
    }

    private void IA() {
        this.De.EL(1);
        Timber.i((String)"Process deferred auth", (Object[])new Object[0]);
        this.jk.dC = true;
        this.jk.BW = true;
        this.jk.Mx = true;
        this.uq = true;
        if (Hk.NE(Hk.NE(this.tP))) {
            this.yS.add(TransactionErrorCode.AtmCashOnlyCard);
            this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
            return;
        }
        this.Ya();
        if (this.vU()) {
            this.yS.clear();
            this.jk.Mx = true;
            this.jk.Gf = true;
            this.OJ = TransactionResultEnum.Approved;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionApproved));
        } else {
            this.OJ = TransactionResultEnum.Declined;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
        }
    }

    private void ft() {
        this.De.EL(1);
        Timber.i((String)"Process forced acceptance", (Object[])new Object[0]);
        this.jk.dC = true;
        this.jk.tA = true;
        this.uq = true;
        this.Ya();
        if (this.CI()) {
            this.yS.clear();
            this.jk.Mx = true;
            this.jk.Gf = true;
            this.OJ = TransactionResultEnum.Approved;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionApproved));
        } else {
            this.OJ = TransactionResultEnum.Declined;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean vU() {
        Timber.i((String)"Deferred auth callback", (Object[])new Object[0]);
        this.EL.setCurrentState(IdTechStateManager.State.Callback);
        Object object = this.Ra;
        synchronized (object) {
            if (!this.jk.NE) {
                this.TQ(TransactionUpdate.DeferredAuthorizationStarted);
                this.oF = true;
                this.Ao = 0;
                this.Ao();
                this.kJ();
                this.TQ(TransactionUpdate.DeferredAuthorizationCompleted);
            }
        }
        this.EL.setCurrentState(this.EL.getLastState() != null ? this.EL.getLastState() : IdTechStateManager.State.NotConnected);
        return this.jk.Ra;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean CI() {
        Timber.i((String)"Forced acceptance callback", (Object[])new Object[0]);
        this.EL.setCurrentState(IdTechStateManager.State.Callback);
        Object object = this.Ra;
        synchronized (object) {
            if (!this.jk.NE) {
                this.TQ(TransactionUpdate.ForcedAcceptanceStarted);
                this.Nu = true;
                this.Ao = 0;
                this.om();
                this.Zb();
                this.TQ(TransactionUpdate.ForcedAcceptanceCompleted);
            }
        }
        this.EL.setCurrentState(this.EL.getLastState() != null ? this.EL.getLastState() : IdTechStateManager.State.NotConnected);
        return this.jk.De;
    }

    private void dY(IDTEMVData iDTEMVData) {
        this.De.EL(1);
        Timber.i((String)"Process approved offline", (Object[])new Object[0]);
        this.TQ(iDTEMVData);
        if ((this.jk.Mx || this.Fx == null || this.Fx.mm() == OnlineResult.Empty) && this.uD == TransactionTypeEnum.ACCOUNT_VERIFICATION) {
            this.yS.add(TransactionErrorCode.AccountVerificationOfflineNotAllowed);
            this.hS();
            return;
        }
        if (!this.Gf.re() && this.uD == TransactionTypeEnum.SALE) {
            this.hS();
            return;
        }
        if (this.Ya()) {
            this.OJ = TransactionResultEnum.Approved;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionApproved));
        } else {
            this.hS();
        }
    }

    private void hS() {
        this.OJ = TransactionResultEnum.Declined;
        this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
    }

    private void rE(IDTEMVData iDTEMVData) {
        this.TQ(iDTEMVData);
        if (this.Gf.Qg() && (this.Gf.bj() || this.jk.my || this.gx()) && this.Ya()) {
            this.jk.Gf = true;
        }
        if (this.jk.Gf) {
            this.OJ = TransactionResultEnum.PartialApproval;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionApproved));
        } else {
            this.OJ = TransactionResultEnum.Declined;
            this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
        }
    }

    private void CV() {
        int n;
        List<ICCTag> list;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (this.Fx != null && (list = this.Fx.EL()) != null && !list.isEmpty()) {
            for (ICCTag iCCTag : list) {
                if ("0x8a".compareToIgnoreCase(iCCTag.getID()) == 0) {
                    byArray = com.creditcall.chipdnamobile.Yy.TQ(iCCTag.getValue());
                }
                if ("0x91".compareToIgnoreCase(iCCTag.getID()) == 0) {
                    byArray2 = com.creditcall.chipdnamobile.Yy.TQ(iCCTag.getValue());
                    continue;
                }
                if ("IssuerScriptData".compareToIgnoreCase(iCCTag.getID()) != 0) continue;
                byArray3 = com.creditcall.chipdnamobile.Yy.TQ(iCCTag.getValue());
            }
        }
        if ((n = this.dR.emv_completeTransaction(this.Fx == null || this.Fx.mm() == OnlineResult.Empty, byArray, byArray2, byArray3, null)) != 0 && n != 61027) {
            Timber.w((String)"Complete Transaction error: %s", (Object[])new Object[]{this.dR.device_getResponseCodeString(n)});
            if (!this.rE && this.Fx != null && this.Fx.mm() != OnlineResult.Empty) {
                this.yS.add(TransactionErrorCode.ChipCompletionFailure);
            }
            this.NE.TQ(new TQ(ActionType.CompleteTransactionDeclined));
        }
    }

    private void rf() {
        if (this.EL.getCurrentState() == IdTechStateManager.State.Idle) {
            Timber.d((String)"Transaction already completed. Ignoring complete transaction approved.", (Object[])new Object[0]);
            return;
        }
        Timber.i((String)"Complete transaction approved", (Object[])new Object[0]);
        this.EL.setCurrentState(IdTechStateManager.State.CompletingTransaction);
        this.jk.dC = false;
        this.jk.Gf = true;
        PinPad.OnlineDataType onlineDataType = this.jk.Ra ? PinPad.OnlineDataType.DeferredAuth : (this.jk.Mx ? PinPad.OnlineDataType.Offline : (this.jk.Ao ? PinPad.OnlineDataType.Delayed : PinPad.OnlineDataType.Conf));
        CompletionDetails completionDetails = this.EL(onlineDataType);
        this.TQ(completionDetails);
        TransactionDetails transactionDetails = this.TQ((PinPad.TQ)null);
        Sb sb = this.TQ(transactionDetails);
        if (this.dY != null) {
            this.TQ(this.dY);
            this.dY = null;
        }
        if (!this.Yy.EL()) {
            this.XO();
        } else {
            this.jk.cL = false;
        }
        this.Kx();
        this.CA();
        this.TQ(sb, transactionDetails, this.yS);
        this.EL.setCurrentState(IdTechStateManager.State.Idle);
    }

    protected boolean TQ(IDTEMVData iDTEMVData) {
        if (iDTEMVData == null) {
            return true;
        }
        try {
            if (iDTEMVData.unencryptedTags == null || iDTEMVData.unencryptedTags.isEmpty() || iDTEMVData.maskedTags == null || iDTEMVData.maskedTags.isEmpty() || iDTEMVData.encryptedTags == null || iDTEMVData.encryptedTags.isEmpty()) {
                this.TQ(iDTEMVData.msr_cardData.unencryptedTags, iDTEMVData.msr_cardData.maskedTags, iDTEMVData.msr_cardData.encryptedTags, iDTEMVData.msr_cardData.isCTLS);
            } else {
                this.TQ(iDTEMVData.unencryptedTags, iDTEMVData.maskedTags, iDTEMVData.encryptedTags, iDTEMVData.msr_cardData.isCTLS);
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    protected boolean TQ(IDTMSRData iDTMSRData) {
        if (iDTMSRData == null) {
            return true;
        }
        try {
            this.TQ(iDTMSRData.unencryptedTags, iDTMSRData.maskedTags, iDTMSRData.encryptedTags, iDTMSRData.isCTLS);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void TQ(Map<String, byte[]> map, Map<String, byte[]> map2, Map<String, byte[]> map3, boolean bl) throws IOException {
        Object object;
        Object object2;
        Object object3;
        this.Su = bl ? PinPad.InterfaceType.ContactlessEMV : PinPad.InterfaceType.ContactEMV;
        ArrayList<ICCTag> arrayList = new ArrayList<ICCTag>();
        if (map != null && !map.isEmpty()) {
            Object object4;
            object3 = map.get("FF8105");
            if (object3 != null && ((byte[])object3).length != 0) {
                object2 = com.creditcall.chipdnamobile.Yy.TQ(object3, 0, ((Object)object3).length, (Map<String, Integer>)new HashMap<String, Integer>(){
                    {
                        this.put("56", 2);
                        this.put("57", 2);
                        this.put("58", 2);
                        this.put("5a", 2);
                        this.put("5f21", 3);
                        this.put("5f22", 3);
                        this.put("5f23", 3);
                        this.put("9f6b", 3);
                        this.put("9f1f", 3);
                    }
                });
                object = ((ArrayList)object2).iterator();
                while (object.hasNext()) {
                    object4 = (Yy.TQ)object.next();
                    if (((Yy.TQ)object4).TQ().equalsIgnoreCase("57A1")) {
                        this.rS = com.creditcall.chipdnamobile.Yy.TQ(((Yy.TQ)object4).cL(), ((Yy.TQ)object4).cL().length);
                        continue;
                    }
                    if (((Yy.TQ)object4).TQ().equalsIgnoreCase("5AA1")) {
                        this.wj = com.creditcall.chipdnamobile.Yy.TQ(((Yy.TQ)object4).cL(), ((Yy.TQ)object4).cL().length);
                        continue;
                    }
                    if (((Yy.TQ)object4).TQ().equalsIgnoreCase("57C1") && !map3.containsKey("57")) {
                        map3.put("57", ((Yy.TQ)object4).cL());
                        continue;
                    }
                    if (((Yy.TQ)object4).TQ().equalsIgnoreCase("5AC1") && !map3.containsKey("5A")) {
                        map3.put("5A", ((Yy.TQ)object4).cL());
                        continue;
                    }
                    arrayList.add(new ICCTag("0x" + ((Yy.TQ)object4).TQ(), com.creditcall.chipdnamobile.Yy.TQ(((Yy.TQ)object4).cL(), ((Yy.TQ)object4).cL().length)));
                }
            }
            if ((object2 = map.get("FF8106")) != null && ((byte[])object2).length != 0) {
                object = com.creditcall.chipdnamobile.Yy.TQ((byte[])object2, 0, ((Object)object2).length);
                object4 = ((ArrayList)object).iterator();
                while (object4.hasNext()) {
                    Yy.TQ tQ = (Yy.TQ)object4.next();
                    arrayList.add(new ICCTag("0x" + tQ.TQ(), com.creditcall.chipdnamobile.Yy.TQ(tQ.cL(), tQ.cL().length)));
                }
            }
            arrayList.addAll(com.creditcall.chipdnamobile.Yy.TQ(map));
        }
        if (map2 != null && !map2.isEmpty()) {
            arrayList.addAll(com.creditcall.chipdnamobile.Yy.TQ(map2));
        }
        this.EL(arrayList);
        if (map3 != null && !map3.isEmpty()) {
            object3 = new ByteArrayOutputStream();
            object2 = map3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                object3.write(com.creditcall.chipdnamobile.Yy.TQ((String)object.getKey()));
                object3.write(com.creditcall.chipdnamobile.Yy.TQ(((byte[])object.getValue()).length));
                object3.write((byte[])object.getValue());
            }
            if (object3.toByteArray().length % 4 != 0) {
                object3.write(new byte[]{-1, -1});
            }
            object2 = new ArrayList();
            ((ArrayList)object2).add(new ICCTag("ENCRYPTEDCARDDETAILS", com.creditcall.chipdnamobile.Yy.TQ(object3.toByteArray(), object3.size())));
            this.EL((ArrayList<ICCTag>)object2);
        }
        this.XO = null;
        object3 = this.tP.iterator();
        while (object3.hasNext()) {
            object2 = (ICCTag)object3.next();
            if (object2.getID().equalsIgnoreCase("0x5F24")) {
                this.HD = object2.getValue();
            }
            if (!object2.getID().equalsIgnoreCase("0x9F34") || this.Su != PinPad.InterfaceType.ContactlessEMV || (object = this.Bm()) != CardSchemeIdEnum.VISA && object != CardSchemeIdEnum.DINERS && object != CardSchemeIdEnum.DISCOVER) continue;
            this.XO = new ICCTag(object2.getID(), object2.getValue());
            object2.setValue("000000");
        }
        if (!this.jk.Nu) {
            this.EL(map2);
            if (this.HD == null && this.rS != null) {
                this.HD = ChipDnaMobileUtils.og(this.rS);
            }
            if (this.wj == null && this.rS != null) {
                this.wj = Hk.EL(this.rS);
            }
            this.TQ(this.wj, this.rS, this.HD, true, null);
            this.jk.Nu = true;
        }
    }

    private void EL(ArrayList<ICCTag> arrayList) {
        if (this.tP == null) {
            this.tP = new ArrayList();
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        HashMap<String, ICCTag> hashMap = new HashMap<String, ICCTag>();
        for (ICCTag iCCTag3 : this.tP) {
            if (iCCTag3 == null) continue;
            hashMap.put(iCCTag3.getID(), iCCTag3);
        }
        for (ICCTag iCCTag3 : arrayList) {
            if (iCCTag3 == null) continue;
            hashMap.put(iCCTag3.getID(), iCCTag3);
        }
        this.tP.clear();
        this.tP.addAll(hashMap.values());
        Collections.sort(this.tP, (iCCTag, iCCTag2) -> iCCTag.getID().compareTo(iCCTag2.getID()));
    }

    private void dR(IDTEMVData iDTEMVData) {
        if (this.EL.getCurrentState() == IdTechStateManager.State.Idle) {
            Timber.d((String)"Transaction already completed. Ignoring complete transaction declined.", (Object[])new Object[0]);
            return;
        }
        Timber.i((String)"Complete transaction declined", (Object[])new Object[0]);
        this.TQ(iDTEMVData);
        this.EL.setCurrentState(IdTechStateManager.State.CompletingTransaction);
        this.jk.Gf = false;
        this.Et = TransactionStateEnum.UnCommitted;
        if ((this.jk.Mx || this.Fx == null || this.Fx.mm() == OnlineResult.Empty) && this.uD == TransactionTypeEnum.ACCOUNT_VERIFICATION) {
            this.yS.add(TransactionErrorCode.AccountVerificationOfflineNotAllowed);
        } else {
            boolean bl;
            if (!(this.jk.NE || this.Fx != null && this.Fx.mm() != OnlineResult.Empty || this.tP.isEmpty() || !this.wj() || this.uq)) {
                this.NE.TQ(new TQ(ActionType.ProcessDeferredAuth));
                return;
            }
            boolean bl2 = bl = this.Su == PinPad.InterfaceType.ContactEMV && this.tA() || this.Su.isContactless() && this.Pb();
            if (!this.jk.NE && !this.jk.tA && (this.Fx == null || this.Fx.mm() == OnlineResult.Empty) && this.Gf.re() && bl && this.Gf.AN() && this.uD != TransactionTypeEnum.REFUND && !this.uq) {
                this.NE.TQ(new TQ(ActionType.ProcessForcedAcceptance));
                return;
            }
        }
        this.jk.dC = false;
        this.OJ = TransactionResultEnum.Declined;
        if (this.Qg()) {
            this.Et = TransactionStateEnum.Void;
            CompletionDetails completionDetails = this.EL(PinPad.OnlineDataType.Void);
            this.TQ(completionDetails);
        }
        if (this.Fx == null || this.Fx.mm() == OnlineResult.Empty) {
            this.jk.Mx = true;
        }
        this.RX();
        if (this.Su.isContactless() && Hk.TQ(this.Fx, this.tP) && !this.jk.BW && this.uD == TransactionTypeEnum.SALE && !this.jk.tA && !this.jk.NE) {
            this.Uw();
            this.NE.TQ(new TQ(ActionType.FallForward));
            return;
        }
        if (!this.Yy.EL()) {
            this.XO();
        } else {
            this.jk.cL = false;
        }
        this.Kx();
        if (this.tP != null && !this.tP.isEmpty() || this.wj != null && !this.wj.isEmpty() && this.Sd != null && !this.Sd.isEmpty()) {
            this.OJ = TransactionResultEnum.Declined;
            TransactionDetails transactionDetails = this.TQ((PinPad.TQ)null);
            Sb sb = this.TQ(transactionDetails);
            this.TQ(sb, transactionDetails, this.yS);
        } else {
            this.TQ(null, null, this.yS);
        }
        if (this.dY != null) {
            this.TQ(this.dY);
            this.dY = null;
        }
        this.EL.setCurrentState(IdTechStateManager.State.Idle);
    }

    private String ns() {
        ICCTag iCCTag;
        if (this.Fx != null && this.Fx.EL() != null && (iCCTag = this.TQ(this.Fx.EL(), "0X8A")) != null && iCCTag.getValue() != null && iCCTag.getValue().length() > 0) {
            return iCCTag.getValue();
        }
        if (this.Fx == null) {
            return "5A31";
        }
        if (this.Fx.mm() == OnlineResult.Empty) {
            return "5A33";
        }
        return "3035";
    }

    private void RX() {
        if (this.tP == null || this.Su == PinPad.InterfaceType.ContactMag || this.jk.Gf) {
            return;
        }
        if (this.TQ(this.tP, "0X8A") != null) {
            return;
        }
        this.tP.add(new ICCTag("0X8A", this.ns()));
    }

    private ICCTag TQ(List<ICCTag> list, String string) {
        if (list != null) {
            for (ICCTag iCCTag : list) {
                if (!iCCTag.getID().equalsIgnoreCase(string)) continue;
                return iCCTag;
            }
        }
        return null;
    }

    private boolean Qg() {
        return this.Fx != null && (this.Fx.mm() == OnlineResult.Approved || this.Fx.mm() == OnlineResult.PartialApproval) && this.uD != TransactionTypeEnum.ACCOUNT_VERIFICATION;
    }

    private CompletionDetails EL(PinPad.OnlineDataType onlineDataType) {
        CompletionDetails completionDetails = new CompletionDetails();
        PinPad.OnlineData onlineData = this.TQ(onlineDataType);
        completionDetails.a(this.Fp);
        completionDetails.a(this.wj);
        switch (onlineDataType) {
            case Void: {
                completionDetails.a(TransactionRegisterEntry.CompletionDetailsType.Void);
                break;
            }
            case DeferredAuth: {
                completionDetails.a(TransactionRegisterEntry.CompletionDetailsType.DeferredAuth);
                break;
            }
            case Delayed: {
                completionDetails.a(TransactionRegisterEntry.CompletionDetailsType.DelayOnline);
                break;
            }
            case Offline: {
                completionDetails.a(TransactionRegisterEntry.CompletionDetailsType.Offline);
                break;
            }
            case Conf: {
                completionDetails.a(TransactionRegisterEntry.CompletionDetailsType.Conf);
            }
        }
        completionDetails.a(onlineData.getIccTags());
        completionDetails.d(this.Sd);
        if (!onlineData.getExtendedProperties().isEmpty()) {
            completionDetails.b(onlineData.getExtendedProperties());
        }
        if (this.Fx != null) {
            completionDetails.c(this.Fx.XO());
        }
        if (this.jk.Ra || this.jk.Mx) {
            String string = Hk.TQ(this.Sy, this.gd);
            this.WM = com.creditcall.chipdnamobile.bk.TQ(com.creditcall.chipdnamobile.bk.EL(new Date()), string, this.Sy());
        }
        return completionDetails;
    }

    private Sb TQ(TransactionDetails transactionDetails) {
        CI cI = com.creditcall.chipdnamobile.CI.cL(transactionDetails);
        Sb sb = new Sb(this.OJ, this.Et, this.xB(), this.uD, this.mE(), this.Sy(), this.gd(), Hk.TQ(this.Sy, this.gd), this.rS(), Hk.TQ((RequestResponse)this.Fx, this.EF), Hk.TQ((RequestResponse)this.Fx), cI, this.uD(), this.Et(), this.Gf.Ut(), this.HD);
        sb.TQ(this.Bm());
        sb.EL(this.Fx != null ? this.Fx.Ut() : null);
        sb.TQ(this.xB);
        if (this.Fx != null && this.Fx.sw() != null && (this.Fx.sw().getFirstName() != null || this.Fx.sw().getLastName() != null)) {
            sb.TQ(this.Fx.sw().getFirstName(), this.Fx.sw().getLastName());
        } else {
            sb.TQ(this.an, this.LP);
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bj() {
        TransactionDetails transactionDetails = this.TQ((PinPad.TQ)null);
        this.EL.setCurrentState(IdTechStateManager.State.Callback);
        Object object = this.Ra;
        synchronized (object) {
            if (!this.jk.NE) {
                this.TQ(TransactionUpdate.SignatureCaptureStarted);
                this.om = true;
                this.TQ(com.creditcall.chipdnamobile.CI.cL(transactionDetails));
                this.cm();
                this.TQ(TransactionUpdate.SignatureCaptureComplete);
            }
        }
        this.EL.setCurrentState(this.EL.getLastState());
        return this.fG != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean Ya() {
        Timber.i((String)"Starting signature verification", (Object[])new Object[0]);
        if (this.jk.Ut && !this.jk.og) {
            if (!this.jk.iW && this.Gf.Su() && this.fG == null && !this.bj()) {
                return false;
            }
            TransactionDetails transactionDetails = this.TQ((PinPad.TQ)null);
            Object object = this.Ra;
            synchronized (object) {
                this.EL.setCurrentState(IdTechStateManager.State.Callback);
                if (!this.jk.NE) {
                    this.TQ(TransactionUpdate.SignatureVerificationStarted);
                    this.LO = true;
                    this.Ao = 0;
                    this.TQ(true, this.Gf.bk(), com.creditcall.chipdnamobile.CI.cL(transactionDetails));
                    this.Fd();
                }
            }
            this.jk.og = true;
            this.TQ(TransactionUpdate.SignatureVerificationCompleted);
            return this.lT;
        }
        return true;
    }

    @Override
    protected void TQ(Hashtable<String, ArrayList<Integer>> hashtable) {
        Timber.i((String)"Check EMV signature required", (Object[])new Object[0]);
        if (this.Su == PinPad.InterfaceType.Unknown) {
            this.Su = this.GH();
        }
        if (this.Gf.jk()) {
            int n = -1;
            if (hashtable.containsKey("9f34") && this.XO == null) {
                n = hashtable.get("9f34").get(0) & 0x3F;
            } else if (this.XO != null) {
                n = com.creditcall.chipdnamobile.Yy.EL(this.XO.getValue()).get(0) & 0x3F;
            }
            if (n > -1) {
                if (n == 30 || n == 5 || n == 3) {
                    this.jk.Ut = true;
                } else if (n == 31) {
                    this.jk.Ut = this.Gf.Et();
                }
            }
            super.TQ(hashtable);
        }
    }

    private PinPad.InterfaceType GH() {
        for (ICCTag iCCTag : this.tP) {
            String string;
            if (!iCCTag.getID().equalsIgnoreCase("0x9f39")) continue;
            switch (string = iCCTag.getValue()) {
                case "05": {
                    return PinPad.InterfaceType.ContactEMV;
                }
                case "90": {
                    return PinPad.InterfaceType.ContactMag;
                }
                case "07": {
                    return PinPad.InterfaceType.ContactlessEMV;
                }
                case "91": {
                    return PinPad.InterfaceType.ContactlessMag;
                }
            }
        }
        return PinPad.InterfaceType.Unknown;
    }

    private void EL(Boolean bl) {
        Timber.i((String)"Resetting card interface", (Object[])new Object[0]);
        this.TQ(TransactionUpdate.SmartcardRemovePrompted);
        this.EL.setCurrentState(IdTechStateManager.State.ResettingCardInterface);
        if (bl.booleanValue()) {
            this.dR.device_cancelTransaction();
        }
        this.XO();
        this.OI = new cL();
        try {
            if (this.OI.TQ(30000L, 1000L)) {
                this.TQ(this.TQ(this.Gf.CI(), this.Gf.vU(), this.Gf.CV()));
            } else {
                this.yS.add(TransactionErrorCode.TimeOutError);
                this.NE.TQ(new TQ(ActionType.TransactionTerminated));
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    private void cL(Boolean bl) {
        Timber.i((String)"Resetting contactless card interface", (Object[])new Object[0]);
        this.TQ(UserNotification.ChipReadErrorApplicationNotSupportedPleaseRetry);
        this.EL.setCurrentState(IdTechStateManager.State.ResettingCardInterface);
        Object object = new Object();
        new Thread(() -> {
            try {
                Object object2 = object;
                synchronized (object2) {
                    object.wait(1500L);
                    if (bl.booleanValue()) {
                        this.dR.device_cancelTransaction();
                    }
                    this.TQ(this.TQ(this.Gf.CI(), this.Gf.vU(), this.Gf.CV()));
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }).start();
    }

    private void NE(IDTEMVData iDTEMVData) {
        Timber.i((String)"Terminated", (Object[])new Object[0]);
        this.TQ(iDTEMVData);
        if (!this.EL.getCurrentState().getCanTerminate()) {
            Timber.d((String)"Can't terminate in current state of %s, termination bypassed", (Object[])new Object[]{this.EL.getCurrentState().name()});
            return;
        }
        if (!this.jk.dC) {
            Timber.d((String)"Merchant unable to terminate, termination bypassed", (Object[])new Object[0]);
            return;
        }
        this.a_();
        if (this.OI != null) {
            this.OI.TQ();
        }
        if (this.lz != null) {
            this.lz.TQ();
        }
        if (this.Kx != null) {
            this.Kx.cancel();
        }
        if (!this.rE && !this.jk.iW) {
            if (!this.yS.contains(TransactionErrorCode.NoSmartcardInSlotError)) {
                Timber.d((String)"Terminated: Calling device_cancelTransaction", (Object[])new Object[0]);
                this.dR.device_cancelTransaction();
                Timber.d((String)"Terminated: device_cancelTransaction completed", (Object[])new Object[0]);
            } else {
                Timber.d((String)"Terminated: Skipping device_cancelTransaction due to card communication error", (Object[])new Object[0]);
            }
        }
        if (this.jk.NE) {
            this.yS.add(TransactionErrorCode.MerchantTerminatedTransaction);
        } else {
            this.jk.NE = true;
        }
        if (this.jk.CA) {
            this.NE.TQ(new TQ(ActionType.CompleteGetCardDetails));
            return;
        }
        if (this.tP == null && (this.EL.getCurrentState() == IdTechStateManager.State.FallForward || this.EL.getLastState() == IdTechStateManager.State.FallForward)) {
            this.tP = this.mE;
            this.Su = this.bk;
        }
        if (this.tP != null && !this.tP.isEmpty() || this.wj != null && !this.wj.isEmpty() && this.Sd != null && !this.Sd.isEmpty()) {
            this.dR((IDTEMVData)null);
        } else {
            if (!this.Yy.EL()) {
                this.XO();
            } else {
                this.jk.cL = false;
            }
            this.Kx();
            this.TQ(null, null, this.yS);
        }
        this.NE.EL.clear();
        this.EL.setCurrentState(IdTechStateManager.State.Idle);
    }

    private void Sb() {
        if (this.EL.getCurrentState() == IdTechStateManager.State.PromptingForCard) {
            Timber.i((String)"Transaction timeout during card prompt", (Object[])new Object[0]);
            this.TQ(TransactionUpdate.CardEntryTimedOut);
            this.TQ(TransactionErrorCode.TimeOutError);
            this.EL.setCurrentState(IdTechStateManager.State.Idle);
        }
    }

    @Override
    protected void zv() {
        Timber.i((String)"Setting Pin Pad terminal properties", (Object[])new Object[0]);
        this.dY();
        this.Fp.setMake(this.Mx.getMake());
        this.Fp.setModel(this.Mx.getModel());
        this.Fp.setPrinter(this.b_().De);
        this.Fp.setScreen(this.b_().tA);
        this.Fp.setDigitalSignature(this.b_().Pb);
        this.Fp.setOnDeviceTipping(this.b_().Ut);
    }

    @Override
    protected void dY() {
        if (this.Mx.getModel() != null && this.Mx.getModel().toLowerCase().equalsIgnoreCase("vp3350")) {
            this.b_().De = false;
            this.b_().tA = false;
            this.b_().Pb = false;
            this.b_().Ut = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean gx() {
        Timber.i((String)"Partial approval callback", (Object[])new Object[0]);
        this.EL.setCurrentState(IdTechStateManager.State.Callback);
        Object object = this.Ra;
        synchronized (object) {
            if (!this.jk.NE) {
                this.TQ(TransactionUpdate.PartialApprovalConfirmationStarted);
                this.my = true;
                this.Ao = 0;
                this.dR(this.Fx.oF());
                this.Fx();
                this.TQ(TransactionUpdate.PartialApprovalConfirmationCompleted);
            }
        }
        return this.jk.Pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zv(int n) {
        this.EL.setCurrentState(IdTechStateManager.State.ApplicationSelection);
        Timber.i((String)"Application selection callback: Timeout %s", (Object[])new Object[]{n});
        this.OI = new cL();
        Object object = this.Ra;
        synchronized (object) {
            if (!this.jk.NE) {
                this.TQ(TransactionUpdate.ApplicationSelectionStarted);
                this.mr = true;
                this.VT(this.zv);
            }
        }
        this.dY(n);
    }

    private void dY(int n) {
        this.Kx = new TimerTask(){

            @Override
            public void run() {
                if (IdTechPinPad.this.mr) {
                    Timber.w((String)"Application selection timed out. Terminating transaction", (Object[])new Object[0]);
                    IdTechPinPad.this.dR.device_cancelTransaction();
                    IdTechPinPad.this.yS.add(TransactionErrorCode.TimeOutError);
                    IdTechPinPad.this.OI.TQ();
                    IdTechPinPad.this.dC().TQ(new TQ(ActionType.TransactionTerminated));
                }
            }
        };
        Timer timer = new Timer("Timer");
        timer.schedule(this.Kx, (long)n * 1000L);
    }

    @Override
    void TQ(boolean bl, String string) throws TransactionException {
        Timber.i((String)"Application selected", (Object[])new Object[0]);
        if (!this.mr) {
            return;
        }
        this.OI.TQ();
        if (this.Kx.cancel()) {
            Timber.d((String)"Application selection timer cancelled", (Object[])new Object[0]);
        }
        for (int i = 0; i < this.zv.size(); ++i) {
            Application application = this.zv.get(i);
            if (!application.getName().equalsIgnoreCase(string)) continue;
            this.EL.setCurrentState(this.EL.getLastState() != null ? this.EL.getLastState() : IdTechStateManager.State.NotConnected);
            this.mr = false;
            this.dC().TQ(new TQ(ActionType.SendSelectedApplication, application));
            this.zv = null;
            return;
        }
        this.zv = null;
        this.yS.add(TransactionErrorCode.ApplicationNotSelected);
        this.dC().TQ(new TQ(ActionType.TransactionTerminated));
    }

    @Override
    void TQ(String string, int n) throws PaymentDeviceException {
        throw new PaymentDeviceException(PaymentDeviceErrorCode.UnsupportedCommand);
    }

    @Override
    void og() throws PaymentDeviceException {
        throw new PaymentDeviceException(PaymentDeviceErrorCode.UnsupportedCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void sw() throws PaymentDeviceException {
        Timber.i((String)"Terminate transaction", (Object[])new Object[0]);
        Object object = this.Ra;
        synchronized (object) {
            if (this.EL.getCurrentState().getCanTerminate() && !this.jk.NE && this.jk.dC) {
                this.jk.NE = true;
                this.a_();
                this.NE.EL.clear();
                if (this.EL.getCurrentState() == IdTechStateManager.State.Callback) {
                    this.yS.add(TransactionErrorCode.MerchantTerminatedTransaction);
                    return;
                }
            } else {
                throw new PaymentDeviceException(PaymentDeviceErrorCode.InvalidState);
            }
            this.NE.TQ(new TQ(ActionType.TransactionTerminated));
        }
    }

    @Override
    void De() throws PaymentDeviceException {
        if (this.EL.getCurrentState() != IdTechStateManager.State.Idle) {
            HashSet<AbstractChipDnaMobileErrorCode> hashSet = new HashSet<AbstractChipDnaMobileErrorCode>();
            hashSet.add(PaymentDeviceErrorCode.UnableToStartGetCardDetails);
            this.TQ(null, null, null, false, hashSet);
            return;
        }
        if (this.lz != null) {
            this.lz.TQ();
        }
        this.jk.CA = true;
        this.NE.TQ(new TQ(ActionType.GetCardDetails));
    }

    private void wQ() {
        Timber.i((String)"Get card details", (Object[])new Object[0]);
        IDT_NEO2.emv_allowFallback((boolean)true);
        this.EL.setCurrentState(IdTechStateManager.State.StartingGetCardDetails);
        this.TQ(TransactionUpdate.GetCardDetailsStarted);
        this.TQ(this.TQ(this.Gf.CI(), this.Gf.vU(), this.Gf.CV()));
    }

    private void kG() {
        if (!(!this.jk.NE && this.yS.isEmpty() || this.jk.Nu)) {
            this.TQ(null, null, null, false, this.yS);
        } else if (!this.jk.Nu) {
            HashSet<AbstractChipDnaMobileErrorCode> hashSet = new HashSet<AbstractChipDnaMobileErrorCode>();
            hashSet.add(PaymentDeviceErrorCode.General);
            this.TQ(null, null, null, false, hashSet);
        }
        this.TQ(TransactionUpdate.GetCardDetailsCompleted);
        if (this.Su == PinPad.InterfaceType.ContactEMV) {
            this.dR.device_cancelTransaction();
            this.TQ(TransactionUpdate.SmartcardRemovePrompted);
            this.XO();
            this.Kx();
        }
        this.uq();
        this.EL.setCurrentState(IdTechStateManager.State.Idle);
    }

    @Override
    protected boolean tA() {
        String string = null;
        String string2 = null;
        for (ICCTag iCCTag : this.tP) {
            if (iCCTag.getID().equalsIgnoreCase("0x5f24")) {
                string = iCCTag.getValue();
            } else if (iCCTag.getID().equalsIgnoreCase("0x5f25")) {
                string2 = iCCTag.getValue();
            }
            if (string2 == null || string == null) continue;
            break;
        }
        if (string == null) {
            this.yS.add(TransactionErrorCode.ExpiryDateMissing);
            return false;
        }
        try {
            ChipDnaMobileUtils.cL(string, string2);
        }
        catch (TransactionException transactionException) {
            this.yS.add(transactionException.TQ());
            return false;
        }
        return true;
    }

    @Override
    protected boolean Pb() {
        String string = null;
        String string2 = null;
        for (ICCTag iCCTag : this.tP) {
            if (iCCTag.getID().equalsIgnoreCase("0x5f24")) {
                string = iCCTag.getValue();
            } else if (iCCTag.getID().equalsIgnoreCase("0x5f25")) {
                string2 = iCCTag.getValue();
            }
            if (string2 == null || string == null) continue;
            break;
        }
        if (string2 == null && string == null && this.Sd == null) {
            return true;
        }
        if (string != null) {
            try {
                ChipDnaMobileUtils.cL(string, string2);
                return true;
            }
            catch (TransactionException transactionException) {
                this.yS.add(transactionException.TQ());
                return false;
            }
        }
        if (this.Sd != null) {
            String string3 = ChipDnaMobileUtils.og(this.Sd);
            if (string3 == null) {
                this.yS.add(TransactionErrorCode.ExpiryDateMissing);
                return false;
            }
            try {
                ChipDnaMobileUtils.cL(string3, null);
            }
            catch (TransactionException transactionException) {
                this.yS.add(transactionException.TQ());
                return false;
            }
        }
        return true;
    }

    @Override
    protected HashMap<String, String> Fp() {
        if (zB == null) {
            zB = new HashMap();
            zB.put("0xdfee12", "dukptksn");
            zB.put("0x5a", "masked-pan");
            zB.put("0x57", "icc-masked-track2");
        }
        return zB;
    }

    @Override
    protected HashMap<String, Boolean> Gf() {
        return new HashMap<String, Boolean>();
    }

    @Override
    protected String fG() {
        return "ID01";
    }

    @Override
    protected String lT() {
        return null;
    }

    @Override
    protected String Mx() {
        return null;
    }

    @Override
    protected boolean MY() {
        return false;
    }

    protected String BW() throws Exception {
        if (this.dR == null) {
            throw new Exception("Device is not connected");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.dR.device_getFirmwareVersion(stringBuilder);
        if (n != 0) {
            throw new Exception("Device Response " + this.dR.device_getResponseCodeString(n));
        }
        return stringBuilder.toString();
    }

    protected String Ra() throws Exception {
        if (this.dR == null) {
            throw new Exception("Device is not connected");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.dR.config_getSerialNumber(stringBuilder);
        if (n != 0) {
            throw new Exception("Device Response " + this.dR.device_getResponseCodeString(n));
        }
        return stringBuilder.toString();
    }

    private void iQ() throws Exception {
        if (this.Pb == PinPad.ConnectionType.Bluetooth || this.Pb == PinPad.ConnectionType.BluetoothLowEnergy) {
            int n = Integer.parseInt(this.oF());
            this.De.TQ(n);
            int n2 = this.De.TQ();
            int n3 = this.De.cL();
            int n4 = this.De.EL();
            Timber.i((String)"Battery Percentage: %s, Predicted Percentage: %s, Number of Actions: %s, Number of Readings: %s", (Object[])new Object[]{n, n2, n3, n4});
            this.Mx.TQ(n);
            this.Mx.EL(n2);
            this.Mx.zv(com.creditcall.chipdnamobile.bk.TQ(new Date()));
            this.Mx.dY("dd/MM/yyyy HH:mm:ss");
        }
    }

    protected String oF() throws Exception {
        if (null == this.dR) {
            throw new Exception("Device is not connected");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.dR.device_getBatteryPercentage(stringBuilder);
        if (n != 0) {
            throw new Exception("Device Response " + this.dR.device_getResponseCodeString(n));
        }
        return stringBuilder.toString();
    }

    protected String LO() throws Exception {
        if (this.dR == null) {
            throw new Exception("Device is not connected");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.dR.device_getDeviceTreeVersion(stringBuilder);
        if (n != 0) {
            throw new Exception("Get Device Tree Response " + this.dR.device_getResponseCodeString(n));
        }
        return stringBuilder.toString();
    }

    @Override
    protected PinPad.DeviceCapabilities b_() {
        Timber.i((String)"Get VP3350 device capabilities", (Object[])new Object[0]);
        if (this.MY == null) {
            this.MY = new PinPad.DeviceCapabilities(this);
            this.MY.dY = true;
            this.MY.VT = true;
            this.MY.uq = true;
            this.MY.sw = true;
            this.MY.zv = false;
        }
        return this.MY;
    }

    public void onReceiveMsgUpdateFirmwareProgress(int i) {
        Object object;
        if (i % 20 == 0) {
            Timber.d((String)"Firmware update progress: %s", (Object[])new Object[]{i});
        }
        if (this.eF == -1) {
            this.NE("DOWNLOADING_FIRMWARE_TO_DEVICE");
            object = new FirmwareUpdateProperty(this.Mx.getName());
            ((FirmwareUpdateProperty)object).setFirmwareUpdateAttempted();
            ((FirmwareUpdateProperty)object).save();
        }
        if (i != this.eF) {
            this.eF = i;
            object = new Parameters();
            ((Parameters)object).add("FIRMWARE_DOWNLOAD_PERCENTAGE", i);
            if (ChipDnaMobile.isInitialized()) {
                ChipDnaMobile.getInstance().TQ(new ListenerCallback(ListenerCallback.CallbackType.FirmwareUpdate, (Parameters)object));
            }
        }
    }

    private void Yy() {
        qD qD2 = qD.cL();
        qD2.zv("true");
        try {
            qD2.rE();
        }
        catch (ChipDnaMobileException chipDnaMobileException) {
            Timber.w((Throwable)chipDnaMobileException, (String)"Failed to set flag for TMS update", (Object[])new Object[0]);
        }
    }

    public void onReceiveMsgUpdateFirmwareResult(int i) {
        Timber.i((String)"Firmware update result: %s", (Object[])new Object[]{i});
        this.Yy();
        FirmwareUpdateProperty firmwareUpdateProperty = new FirmwareUpdateProperty(this.Mx.getName());
        switch (i) {
            case 301: {
                this.NE("APPLYING_FIRMWARE_TO_DEVICE");
                firmwareUpdateProperty.setFirmwareUpdateComplete();
                Timber.i((String)"Firmware update successful", (Object[])new Object[0]);
                this.cL(true);
                this.NE("FIRMWARE_UPDATE_COMPLETE");
                this.EL.setCurrentState(IdTechStateManager.State.NotConnected);
                break;
            }
            case 303: {
                Timber.w((String)"Firmware update was interrupted previously, please try again", (Object[])new Object[0]);
                this.EL.setCurrentState(IdTechStateManager.State.NotConnected);
                this.TQ((Boolean)false, (AbstractChipDnaMobileErrorCode)ConfigurationErrorCode.FirmwareFileParsingFailed);
                firmwareUpdateProperty.setFirmwareUpdateIncomplete();
                break;
            }
            default: {
                Timber.w((String)"Failed to update firmware: %s", (Object[])new Object[]{i});
                this.EL.setCurrentState(IdTechStateManager.State.NotConnected);
                this.TQ((Boolean)false, (AbstractChipDnaMobileErrorCode)ConfigurationErrorCode.FirmwareFileParsingFailed);
                firmwareUpdateProperty.setFirmwareUpdateIncomplete();
            }
        }
        if (this.Pb == PinPad.ConnectionType.BluetoothLowEnergy) {
            this.TQ = this.dR;
        }
        firmwareUpdateProperty.save();
        this.pd();
        this.rE();
    }

    public void onReceiveMsgChallengeResult(int i, byte[] bytes) {
        Timber.i((String)"Challenge result: %s", (Object[])new Object[]{i});
    }

    private void cL(ArrayList<String> arrayList) {
        try {
            Timber.i((String)"Process Software Update", (Object[])new Object[0]);
            this.EL(false);
            this.EL.setCurrentState(IdTechStateManager.State.Firmware);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Terminal Configuration", "");
            hashMap.put("CAP Keys", "");
            this.TQ(hashMap);
            FirmwareUpdateTool firmwareUpdateTool = new FirmwareUpdateTool((FirmwareUpdateToolMsg)this, this.Vo);
            this.dR.setIDT_Device(firmwareUpdateTool);
            if (this.dR.device_getDeviceType() != ReaderInfo.DEVICE_TYPE.DEVICE_NEO2_BT) {
                this.dR.registerListen();
            }
            Timber.i((String)"Update IDTech Firmware, firmware file to update \n%s", (Object[])new Object[]{arrayList.toString()});
            for (String string : arrayList) {
                Timber.i((String)"Updating firmware file [identifier=%s]", (Object[])new Object[]{string});
                byte[] byArray = this.Gf.TQ(string, ChipDnaMobileProperties.FileCategory.Software, null);
                int n = this.dR.device_updateFirmware(byArray, ReaderInfo.FIRMWARE_UPDATE_TYPES.FU_PACKAGE_DOWNLOAD);
                if (byArray.length == 0) {
                    throw new PaymentDeviceException(PaymentDeviceErrorCode.UnsupportedFirmwareVersion);
                }
                if (n == 0) {
                    Timber.i((String)"Firmware Update Started Successfully.", (Object[])new Object[0]);
                    this.eF = -1;
                    Parameters parameters = new Parameters();
                    parameters.add("FIRMWARE_UPDATE", "STARTING_FIRMWARE_UPDATE");
                    parameters.add("FIRMWARE_FILE", string);
                    if (!ChipDnaMobile.isInitialized()) continue;
                    ChipDnaMobile.getInstance().TQ(new ListenerCallback(ListenerCallback.CallbackType.FirmwareUpdate, parameters));
                    continue;
                }
                throw new PaymentDeviceException(PaymentDeviceErrorCode.HardwareError);
            }
        }
        catch (PaymentDeviceException paymentDeviceException) {
            Timber.w((Throwable)paymentDeviceException, (String)paymentDeviceException.TQ.getErrorString(), (Object[])new Object[0]);
            this.EL.setCurrentState(IdTechStateManager.State.Idle);
            this.dR();
            this.TQ((Boolean)false, (AbstractChipDnaMobileErrorCode)ConfigurationErrorCode.FirmwareFileParsingFailed);
        }
    }

    private boolean Ai() {
        return !this.DU().isEmpty() && this.b_().VT && this.DU().contains("IDTechSoftware_Firmware");
    }

    private ArrayList<String> DU() {
        Timber.i((String)"Getting software files to update", (Object[])new Object[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            HashMap<String, String> hashMap = this.Gf.EL(ChipDnaMobileProperties.FileCategory.Software);
            if (hashMap.get("IDTechSoftware_Firmware") != null && hashMap.get("IDTechSoftware_Firmware").length() > 0) {
                String string = hashMap.get("IDTechSoftware_Firmware");
                String string2 = this.BW();
                Timber.d((String)"Firmware version on device: %s", (Object[])new Object[]{string2});
                Timber.d((String)"Firmware version online: %s", (Object[])new Object[]{string});
                if (string2.equalsIgnoreCase("") || string.equalsIgnoreCase("")) {
                    throw new Exception("Failed to get firmware version");
                }
                if (!string.equals(string2)) {
                    arrayList.add("IDTechSoftware_Firmware");
                } else {
                    Timber.i((String)"Firmware version on device is up to date", (Object[])new Object[0]);
                }
                if (!this.EL(string2, string)) {
                    Timber.w((String)"Firmware version mismatch, firmware update bypassed", (Object[])new Object[0]);
                    this.iQ = true;
                    return new ArrayList<String>();
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            Timber.w((String)"Exception caught getting firmware files: %s", (Object[])new Object[]{exception.getMessage()});
            return arrayList;
        }
    }

    @VisibleForTesting
    public boolean EL(String string, String string2) {
        String string3 = string.substring(string.length() - 2);
        String string4 = string2.substring(string2.length() - 2);
        if (string3.contains(".")) {
            return string3.equals(string4);
        }
        return !string4.contains(".");
    }

    private void TQ(Boolean bl, AbstractChipDnaMobileErrorCode abstractChipDnaMobileErrorCode) {
        if (this.iQ && abstractChipDnaMobileErrorCode == null) {
            abstractChipDnaMobileErrorCode = ConfigurationErrorCode.FirmwareFileIncompatible;
        }
        this.iQ = false;
        this.TQ((boolean)bl, abstractChipDnaMobileErrorCode);
    }

    private void OI() {
        Timber.i((String)"Fall forward process started", (Object[])new Object[0]);
        this.EL.setCurrentState(IdTechStateManager.State.FallForward);
        if (!this.Gf.vU() && !this.Gf.CI()) {
            this.yS.add(TransactionErrorCode.EMVAndMagstripeInterfacesNotEnabledContactlessFallForwardNotPossible);
            this.NE.TQ(new TQ(ActionType.TransactionTerminated));
            return;
        }
        this.lz();
        this.TQ(this.TQ(this.Gf.CI(), this.Gf.vU(), false));
    }

    private void lz() {
        if (this.Gf.vU() && this.Gf.CI()) {
            this.TQ(UserNotification.ICCMSRFallforward);
        } else if (this.Gf.vU()) {
            this.TQ(UserNotification.ICCFallforward);
        } else if (this.Gf.CI()) {
            this.TQ(UserNotification.MSRFallforward);
        }
    }

    private void Kx() {
        if (this.Su == PinPad.InterfaceType.ContactEMV && !this.Yy.EL()) {
            this.lz = new cL();
            new Thread(() -> {
                Timber.d((String)"Monitoring for card removal...", (Object[])new Object[0]);
                try {
                    if (this.lz.TQ(30000L, 1000L)) {
                        this.jk.cL = false;
                        Timber.d((String)"Card removed at end of transaction - SmartcardRemoved event sent", (Object[])new Object[0]);
                    } else {
                        Timber.d((String)"Timeout waiting for card removal at end of transaction", (Object[])new Object[0]);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Timber.d((String)"Card removal monitoring interrupted at end of transaction", (Object[])new Object[0]);
                }
            }).start();
        } else if (this.Su == PinPad.InterfaceType.ContactEMV) {
            Timber.d((String)"Card already removed", (Object[])new Object[0]);
            this.jk.cL = false;
        }
    }

    class EL {
        private BlockingQueue<TQ> EL;
        private volatile boolean cL = false;

        EL() {
        }

        private void EL() {
            new Thread(){

                @Override
                public void run() {
                    block11: {
                        EL.this.cL = true;
                        Process.setThreadPriority((int)-2);
                        Thread.currentThread().setName("IDTech - [ActionThread]");
                        block7: while (true) {
                            try {
                                while (IdTechPinPad.this.NE()) {
                                    TQ tQ = EL.this.EL.take();
                                    try {
                                        EL.this.EL(tQ);
                                        continue block7;
                                    }
                                    catch (PaymentDeviceException paymentDeviceException) {
                                        Timber.w((Throwable)paymentDeviceException, (String)paymentDeviceException.TQ.getErrorString(), (Object[])new Object[0]);
                                    }
                                }
                                break block11;
                            }
                            catch (InterruptedException interruptedException) {
                                Timber.w((Throwable)interruptedException, (String)"Action queue interrupted", (Object[])new Object[0]);
                                break block11;
                            }
                        }
                        finally {
                            if (IdTechPinPad.this.EL.getCurrentState() != IdTechStateManager.State.NotConnected) {
                                Timber.i((String)"Unexpected Disconnection", (Object[])new Object[0]);
                                if (IdTechPinPad.this.EL.getCurrentState() != IdTechStateManager.State.Idle) {
                                    IdTechPinPad.this.NE((IDTEMVData)null);
                                }
                                IdTechPinPad.this.rE();
                            }
                        }
                    }
                    Timber.i((String)"Exiting Action Thread", (Object[])new Object[0]);
                    EL.this.cL = false;
                }
            }.start();
        }

        private void EL(TQ tQ) throws PaymentDeviceException {
            Timber.i((String)"Performing action: %s from Thread: %s", (Object[])new Object[]{tQ.TQ.name(), Thread.currentThread().getName()});
            switch (tQ.TQ) {
                case GetPinPadInformation: {
                    IdTechPinPad.this.Tk();
                    break;
                }
                case PinPadConfiguring: {
                    IdTechPinPad.this.TQ((Boolean)tQ.EL);
                    break;
                }
                case PinPadSoftwareUpdate: {
                    IdTechPinPad.this.cL((ArrayList)tQ.EL);
                    break;
                }
                case StartTransaction: {
                    IdTechPinPad.this.Wa();
                    break;
                }
                case TransactionTimeout: {
                    IdTechPinPad.this.Sb();
                    break;
                }
                case SelectApplication: {
                    IdTechPinPad.this.zv((Integer)tQ.EL);
                    break;
                }
                case SelectTransactionLanguage: {
                    IdTechPinPad.this.RH();
                    break;
                }
                case SendSelectedApplication: {
                    IdTechPinPad.this.TQ((Application)tQ.EL);
                    break;
                }
                case ProcessEmvCardRead: {
                    IdTechPinPad.this.EL((IDTEMVData)tQ.EL);
                    break;
                }
                case ProcessMagstripeCardRead: {
                    IdTechPinPad.this.EL((IDTMSRData)tQ.EL);
                    break;
                }
                case OnlineAuthorisation: {
                    IdTechPinPad.this.re();
                    break;
                }
                case ResetCardInterface: {
                    IdTechPinPad.this.EL((Boolean)tQ.EL);
                    break;
                }
                case ResetContactlessCardInterface: {
                    IdTechPinPad.this.cL((Boolean)tQ.EL);
                    break;
                }
                case CompleteTransactionApproved: {
                    IdTechPinPad.this.rf();
                    break;
                }
                case CompleteTransactionDeclined: {
                    IdTechPinPad.this.dR((IDTEMVData)tQ.EL);
                    break;
                }
                case ProcessOnlineApproved: {
                    IdTechPinPad.this.cL((IDTEMVData)tQ.EL);
                    break;
                }
                case ProcessMagstripeOffline: {
                    IdTechPinPad.this.AN();
                    break;
                }
                case ProcessPartialApproval: {
                    IdTechPinPad.this.rE((IDTEMVData)tQ.EL);
                    break;
                }
                case TransactionTerminated: {
                    IdTechPinPad.this.NE((IDTEMVData)tQ.EL);
                    break;
                }
                case CompleteMSRTransactionDeclined: {
                    IdTechPinPad.this.cL((IDTMSRData)tQ.EL);
                    break;
                }
                case CheckMastercardContactlessRefundElseReset: {
                    IdTechPinPad.this.zv((IDTEMVData)tQ.EL);
                    break;
                }
                case Disconnected: {
                    break;
                }
                case ProcessFallback: {
                    IdTechPinPad.this.rE((Boolean)tQ.EL);
                    break;
                }
                case FallForward: {
                    IdTechPinPad.this.OI();
                    break;
                }
                case ProcessDeferredAuth: {
                    IdTechPinPad.this.IA();
                    break;
                }
                case ProcessForcedAcceptance: {
                    IdTechPinPad.this.ft();
                    break;
                }
                case ProcessOfflineApproved: {
                    IdTechPinPad.this.dY((IDTEMVData)tQ.EL);
                    break;
                }
                case GetCardDetails: {
                    IdTechPinPad.this.wQ();
                    break;
                }
                case CompleteGetCardDetails: {
                    IdTechPinPad.this.kG();
                    break;
                }
                default: {
                    Timber.w((String)"Action Type %s not recognised", (Object[])new Object[]{tQ.TQ.name()});
                }
            }
        }

        synchronized void TQ() {
            Timber.d((String)"Init Action Threads %s", (Object[])new Object[]{Thread.currentThread().getId()});
            if (!this.cL) {
                Timber.d((String)"Init Action Queue created %s", (Object[])new Object[]{Thread.currentThread().getId()});
                this.EL = new LinkedBlockingQueue<TQ>();
                this.EL();
            }
            IdTechPinPad.this.De = new De();
        }

        void TQ(TQ tQ) {
            this.EL.add(tQ);
        }
    }

    private class cL {
        final Object TQ = new Object();
        volatile boolean EL = false;

        private cL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void TQ() {
            Object object = this.TQ;
            synchronized (object) {
                this.EL = true;
                this.TQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean TQ(long l, long l2) throws InterruptedException {
            Object object = this.TQ;
            synchronized (object) {
                long l3 = System.currentTimeMillis();
                long l4 = 0L;
                while (!this.EL && l4 < l) {
                    this.TQ.wait(l2);
                    if (!this.EL && this.cL()) {
                        this.TQ();
                        IdTechPinPad.this.jk.cL = false;
                        IdTechPinPad.this.TQ(TransactionUpdate.SmartcardRemoved);
                        return true;
                    }
                    l4 = System.currentTimeMillis() - l3;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cL() {
            Object object = this.TQ;
            synchronized (object) {
                if (!this.EL) {
                    return this.EL();
                }
            }
            return false;
        }

        public boolean EL() {
            int n;
            ICCReaderStatusStruct iCCReaderStatusStruct = new ICCReaderStatusStruct();
            if (IdTechPinPad.this.Pb == PinPad.ConnectionType.Usb) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if ((n = IdTechPinPad.this.dR.icc_getICCReaderStatus(iCCReaderStatusStruct)) == 0) {
                return !iCCReaderStatusStruct.cardSeated;
            }
            return false;
        }
    }

    static class TQ {
        ActionType TQ;
        Object EL;

        TQ(ActionType actionType) {
            this.TQ = actionType;
        }

        TQ(ActionType actionType, Object object) {
            this.TQ = actionType;
            this.EL = object;
        }
    }

    static enum ActionType {
        GetPinPadInformation,
        PinPadConfiguring,
        StartTransaction,
        TransactionTimeout,
        SelectApplication,
        SelectTransactionLanguage,
        SendSelectedApplication,
        ProcessEmvCardRead,
        ProcessMagstripeCardRead,
        OnlineAuthorisation,
        ResetCardInterface,
        ResetContactlessCardInterface,
        ProcessOnlineApproved,
        CompleteTransactionApproved,
        CompleteTransactionDeclined,
        ProcessMagstripeOffline,
        ProcessPartialApproval,
        TransactionTerminated,
        Disconnected,
        FallForward,
        ProcessDeferredAuth,
        ProcessForcedAcceptance,
        ProcessOfflineApproved,
        GetCardDetails,
        CompleteGetCardDetails,
        ProcessFallback,
        PinPadSoftwareUpdate,
        CompleteMSRTransactionDeclined,
        CheckMastercardContactlessRefundElseReset;

    }

    private class zv {
        static final String TQ = "IDTech";
        static final String EL = "VP3350";
        static final String cL = "IDTechSoftware_Firmware";
        static final String zv = "Terminal Configuration";
        static final String dY = "CAP Keys";

        private zv() {
        }
    }
}

