/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import com.creditcall.TLSSocketFactory;
import com.creditcall.chipdnamobile.ChipDnaMobileErrorCode;
import com.creditcall.chipdnamobile.ChipDnaMobileException;
import com.creditcall.chipdnamobile.JwtToken;
import com.creditcall.chipdnamobile.JwtUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000b\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\r2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a2\u0006\u0004\b\b\u0010\u000fJ\u001f\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\u0011J#\u0010\u0013\u001a\u00020\u00122\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J+\u0010\u0019\u001a\u00020\u00182\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0013\u0010\u000b\u001a\u00020\u0006*\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\tR\u0014\u0010\b\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001b"}, d2={"Lcom/creditcall/chipdnamobile/JwtClient;", "", "Ljava/util/concurrent/Semaphore;", "semaphore", "<init>", "(Ljava/util/concurrent/Semaphore;)V", "", "p0", "TQ", "(Ljava/lang/String;)Ljava/lang/String;", "", "EL", "(Ljava/util/Map;)Ljava/lang/String;", "Lkotlin/Pair;", "Ljava/net/URL;", "(Ljava/util/Map;)Lkotlin/Pair;", "p1", "(Ljava/net/URL;Ljava/lang/String;)Ljava/lang/String;", "", "cL", "(Ljava/util/Map;)Z", "bodyMap", "", "buffer", "Lcom/creditcall/chipdnamobile/JwtToken;", "sendFormURLEncodedRequest", "(Ljava/util/Map;I)Lcom/creditcall/chipdnamobile/JwtToken;", "Ljava/util/concurrent/Semaphore;", "Companion"})
public final class JwtClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Semaphore TQ;
    @NotNull
    public static final String AUTH_URL = "auth_url";
    @NotNull
    public static final String CLIENT_ID = "client_id";
    @NotNull
    public static final String CLIENT_SECRET = "client_secret";
    @NotNull
    public static final String API_KEY = "api_key";
    @NotNull
    public static final String DEVICE_SERIAL = "device_serial";
    @NotNull
    private static final String EL = "access_token";
    @NotNull
    private static final String cL = "POST";
    @NotNull
    private static final String zv = "Content-Type";
    @NotNull
    private static final String dY = "application/x-www-form-urlencoded";

    public JwtClient(@NotNull Semaphore semaphore) {
        Intrinsics.checkNotNullParameter((Object)semaphore, (String)"");
        this.TQ = semaphore;
    }

    public /* synthetic */ JwtClient(Semaphore semaphore, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            semaphore = new Semaphore(1);
        }
        this(semaphore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JwtToken sendFormURLEncodedRequest(@NotNull Map<String, String> bodyMap, int buffer) throws ChipDnaMobileException {
        Intrinsics.checkNotNullParameter(bodyMap, (String)"");
        try {
            this.TQ.acquire();
            Pair<URL, String> pair = this.TQ(bodyMap);
            URL uRL = (URL)pair.component1();
            String string = (String)pair.component2();
            String string2 = this.TQ(uRL, string);
            String string3 = this.TQ(string2);
            Timber.d((String)"sendFormURLEncodedRequest retrieved new access token with success.", (Object[])new Object[0]);
            JwtToken jwtToken = new JwtToken(string3, buffer);
            return jwtToken;
        }
        catch (ChipDnaMobileException chipDnaMobileException) {
            Timber.d((String)("sendFormURLEncodedRequest failed with " + chipDnaMobileException.chipDnaMobileErrorCode.getErrorString() + "."), (Object[])new Object[0]);
            throw chipDnaMobileException;
        }
        finally {
            this.TQ.release();
        }
    }

    private final Pair<URL, String> TQ(Map<String, String> map) {
        URL uRL = JwtUtils.INSTANCE.createURL(map.get(AUTH_URL));
        String string = this.EL(map);
        return new Pair((Object)uRL, (Object)string);
    }

    private final String EL(Map<String, String> map) {
        if (map.isEmpty() || !this.cL(map)) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnexpectedChipDnaError);
        }
        String string = CollectionsKt.joinToString$default((Iterable)map.entrySet(), (CharSequence)"&", null, null, (int)0, null, (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends String>, CharSequence>(this){
            final /* synthetic */ JwtClient TQ;
            {
                this.TQ = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence TQ(@NotNull Map.Entry<String, String> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"");
                String string = entry.getKey();
                String string2 = entry.getValue();
                return JwtClient.access$urlEncode(this.TQ, string) + "=" + JwtClient.access$urlEncode(this.TQ, string2);
            }

            public /* synthetic */ Object invoke(Object p1) {
                return this.TQ((Map.Entry)p1);
            }
        }), (int)30, null);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String TQ(URL uRL, String string) {
        Object object;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection);
            object = (HttpsURLConnection)uRLConnection;
        }
        catch (IOException iOException) {
            Timber.w((String)("makeRequest opening the connection failed with IOException - " + iOException + "."), (Object[])new Object[0]);
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnableToOpenURL);
        }
        HttpsURLConnection httpsURLConnection = object;
        try {
            Object object2;
            Object object3;
            try {
                httpsURLConnection.setSSLSocketFactory((SSLSocketFactory)new TLSSocketFactory());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Timber.w((String)("makeRequest setting the ssl socket factory failed with IllegalArgumentException - " + illegalArgumentException + "."), (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnableToCreateTLSSockets);
            }
            catch (SecurityException securityException) {
                Timber.w((String)("makeRequest setting the ssl socket factory failed with SecurityException - " + securityException + "."), (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnableToCreateTLSSockets);
            }
            try {
                object3 = object = httpsURLConnection;
                boolean bl = false;
                ((URLConnection)object3).setConnectTimeout(10000);
                ((URLConnection)object3).setReadTimeout(45000);
                ((URLConnection)object3).setDoOutput(true);
                ((HttpURLConnection)object3).setRequestMethod(cL);
                ((URLConnection)object3).setRequestProperty(zv, dY);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Timber.w((String)("makeRequest applying connection configurations failed with IllegalArgumentException - " + illegalArgumentException + "."), (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnableToSpecifyCommunicationProtocol);
            }
            catch (IllegalStateException illegalStateException) {
                Timber.w((String)("makeRequest applying connection configurations failed with IllegalStateException - " + illegalStateException + "."), (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnableToSpecifyCommunicationProtocol);
            }
            catch (ProtocolException protocolException) {
                Timber.w((String)("makeRequest applying connection configurations failed with ProtocolException - " + protocolException + "."), (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnableToSpecifyCommunicationProtocol);
            }
            catch (SecurityException securityException) {
                Timber.w((String)("makeRequest applying connection configurations failed with SecurityException - " + securityException + "."), (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnableToSpecifyCommunicationProtocol);
            }
            try {
                object = httpsURLConnection.getOutputStream();
                object2 = object3 = new OutputStreamWriter((OutputStream)object);
                boolean bl = false;
                ((Writer)object2).write(string);
                ((OutputStreamWriter)object2).flush();
                ((OutputStreamWriter)object2).close();
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {
                Timber.w((String)("makeRequest output stream failed with IOException - " + iOException + "."), (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnableToSendRequest);
            }
            try {
                int n = httpsURLConnection.getResponseCode();
                if (n != 200) {
                    throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnsuccessfulHttpRequest);
                }
            }
            catch (IOException iOException) {
                Timber.w((String)("makeRequest getting the response code failed with IOException - " + iOException + "."), (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnableToGetHttpResponseCode);
            }
            String string2 = null;
            try {
                InputStream inputStream = httpsURLConnection.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"");
                object2 = inputStream;
                Charset charset = Charsets.UTF_8;
                Reader reader = new InputStreamReader((InputStream)object2, charset);
                int n = 8192;
                object3 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                string2 = TextStreamsKt.readText((Reader)((Reader)object3));
                ((BufferedReader)object3).close();
            }
            catch (IOException iOException) {
                Timber.w((String)("makeRequest input stream failed with IOException - " + iOException + "."), (Object[])new Object[0]);
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnableToReadResponse);
            }
            object3 = string2;
            return object3;
        }
        finally {
            httpsURLConnection.disconnect();
        }
    }

    private final String TQ(String string) {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            Timber.w((String)("getAccessTokenFromResponse creating new JSONObject failed with JSONException - " + jSONException + "."), (Object[])new Object[0]);
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnableToReadResponse);
        }
        if (!jSONObject.has(EL) || !(jSONObject.get(EL) instanceof String)) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnexpectedChipDnaError);
        }
        Object object = jSONObject.get(EL);
        Intrinsics.checkNotNull((Object)object);
        return (String)object;
    }

    private final boolean cL(Map<String, String> map) {
        Map<String, String> map2 = map;
        boolean bl = false;
        return map2.containsKey(API_KEY) && map2.containsKey(CLIENT_ID) && map2.containsKey(CLIENT_SECRET) && map2.containsKey(DEVICE_SERIAL);
    }

    private final String EL(String string) {
        String string2 = URLEncoder.encode(string, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return string2;
    }

    public JwtClient() {
        this(null, 1, null);
    }

    public static final /* synthetic */ String access$urlEncode(JwtClient $this, String $receiver) {
        return $this.EL($receiver);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0006"}, d2={"Lcom/creditcall/chipdnamobile/JwtClient$Companion;", "", "<init>", "()V", "", "EL", "Ljava/lang/String;", "TQ", "API_KEY", "AUTH_URL", "CLIENT_ID", "CLIENT_SECRET", "DEVICE_SERIAL", "zv", "dY", "cL"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

