/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import com.creditcall.chipdnamobile.ChipDnaMobileErrorCode;
import com.creditcall.chipdnamobile.ChipDnaMobileException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JK\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0015\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0016"}, d2={"Lcom/creditcall/chipdnamobile/JwtUtils;", "", "<init>", "()V", "", "authenticationUrl", "apiKey", "clientId", "clientSecret", "deviceSerial", "", "expirationTime", "", "createRequestBodyMap", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)Ljava/util/Map;", "Ljava/net/URL;", "createURL", "(Ljava/lang/String;)Ljava/net/URL;", "", "getCurrentTimeInSeconds", "()J", "zv", "Ljava/lang/String;", "TQ", "EL", "cL"})
public final class JwtUtils {
    @NotNull
    public static final JwtUtils INSTANCE = new JwtUtils();
    @NotNull
    private static final String TQ = "grant_type";
    @NotNull
    private static final String EL = "scope";
    @NotNull
    private static final String cL = "transaction.process.all transaction.query.email_receipt transaction.query.all";
    @NotNull
    private static final String zv = "expiration_seconds";

    private JwtUtils() {
    }

    @NotNull
    public final URL createURL(@Nullable String authenticationUrl) throws ChipDnaMobileException {
        try {
            return new URL(authenticationUrl);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.UnexpectedChipDnaError);
        }
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> createRequestBodyMap(@NotNull String authenticationUrl, @NotNull String apiKey, @NotNull String clientId, @NotNull String clientSecret, @NotNull String deviceSerial, int expirationTime) {
        Intrinsics.checkNotNullParameter((Object)authenticationUrl, (String)"");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"");
        Intrinsics.checkNotNullParameter((Object)deviceSerial, (String)"");
        Map map = new LinkedHashMap();
        map.put("auth_url", authenticationUrl);
        map.put("client_id", clientId);
        map.put("client_secret", clientSecret);
        map.put("api_key", apiKey);
        map.put("device_serial", deviceSerial);
        map.put(EL, cL);
        map.put(TQ, "api_key");
        if (expirationTime > 0) {
            map.put(zv, String.valueOf(expirationTime));
        }
        return map;
    }

    public final long getCurrentTimeInSeconds() {
        return System.currentTimeMillis() / (long)1000;
    }
}

