/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import Base64.Base64;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import com.creditcall.chipdnamobile.ChipDnaMobileErrorCode;
import com.creditcall.chipdnamobile.ChipDnaMobileException;
import com.creditcall.chipdnamobile.SignatureFormatEnum;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import timber.log.Timber;

class Signature
implements Serializable {
    private static final long serialVersionUID = -1926327885941089579L;
    private static byte[] TQ;
    private static int EL;
    private static int cL;
    private SignatureFormatEnum zv;
    private static final int dY = 150;
    private static final int rE = 25;
    private static final int dR = 0;
    private static final int NE = 1;

    public Signature(byte[] data, int width, int height, SignatureFormatEnum format) throws ChipDnaMobileException {
        this.TQ(data, width, height, SignatureFormatEnum.MONO);
    }

    public Signature(Bitmap signatureBitmap) throws ChipDnaMobileException {
        int n;
        int n2;
        try {
            n2 = signatureBitmap.getWidth();
            n = signatureBitmap.getHeight();
        }
        catch (RuntimeException runtimeException) {
            Timber.w((Throwable)runtimeException);
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.ProvidedSignatureInvalidFormat, (Throwable)runtimeException);
        }
        if (Signature.TQ(signatureBitmap)) {
            this.TQ(this.EL(signatureBitmap), n2, n, SignatureFormatEnum.MONO);
        } else {
            byte[] byArray = new byte[n2 * n];
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n4 = Color.alpha((int)signatureBitmap.getPixel(j, i));
                    byArray[n3] = n4 > 0 ? (byte)1 : 0;
                    ++n3;
                }
            }
            this.TQ(byArray, n2, n, SignatureFormatEnum.MONO);
        }
    }

    public Signature(String base64SignatureData) throws ChipDnaMobileException {
        Bitmap bitmap = Signature.TQ(base64SignatureData);
        this.TQ(this.EL(bitmap), bitmap.getWidth(), bitmap.getHeight(), SignatureFormatEnum.MONO);
    }

    static Bitmap TQ(String string) throws ChipDnaMobileException {
        Bitmap bitmap;
        try {
            byte[] byArray = Base64.decode(string, 0);
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        }
        catch (IOException iOException) {
            Timber.w((Throwable)iOException);
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.ProvidedSignatureInvalidFormat);
        }
        return bitmap;
    }

    private void TQ(byte[] byArray, int n, int n2, SignatureFormatEnum signatureFormatEnum) throws ChipDnaMobileException {
        TQ = byArray;
        EL = n;
        cL = n2;
        this.zv = signatureFormatEnum;
        if (TQ == null || TQ.length == 0 || EL <= 0 || cL <= 0 || signatureFormatEnum == null) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.ProvidedSignatureInvalidFormat);
        }
        int n3 = 0;
        switch (signatureFormatEnum) {
            case MONO: {
                n3 = 1;
                break;
            }
            default: {
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.ProvidedSignatureUnsupportedFormat);
            }
        }
        if (EL * cL * n3 != TQ.length) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.ProvidedSignatureInvalidFormat);
        }
        if (EL < 150 && cL < 150 || EL < 25 || cL < 25) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.ProvidedSignatureTooSmall);
        }
        int n4 = 0;
        byte[] byArray2 = byArray;
        int n5 = byArray2.length;
        for (int i = 0; i < n5; ++i) {
            byte by2 = byArray2[i];
            n4 += by2;
        }
        if (n4 == 0) {
            throw new ChipDnaMobileException(ChipDnaMobileErrorCode.ProvidedSignatureOnlyContainsWhiteSpace);
        }
        boolean bl = this.dR();
        if (bl) {
            if (EL < 150 && cL < 150 || EL < 25 || cL < 25) {
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.CroppedSignatureTooSmall);
            }
            if (!(EL <= 150 && cL <= 150 || (n5 = (int)(this.dC() ? 1 : 0)) == 0 || EL >= 25 && cL >= 25)) {
                throw new ChipDnaMobileException(ChipDnaMobileErrorCode.ResizedSignatureTooSmall);
            }
        }
    }

    private boolean dR() {
        int n;
        int n2 = EL;
        int n3 = cL;
        byte[][] byArray = this.NE();
        int n4 = EL;
        int n5 = cL;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            for (n = 0; n < byArray[0].length; ++n) {
                if (byArray[i][n] != 1) continue;
                if (n < n4) {
                    n4 = n;
                }
                if (i < n5) {
                    n5 = i;
                }
                if (n > n6) {
                    n6 = n;
                }
                if (i <= n7) continue;
                n7 = i;
            }
        }
        if (n7 - n5 + 1 > 0 && n6 - n4 + 1 > 0) {
            byte[][] byArray2 = new byte[n7 - n5 + 1][n6 - n4 + 1];
            for (n = n5; n <= n7; ++n) {
                System.arraycopy(byArray[n], n4, byArray2[n - n5], 0, n6 + 1 - n4);
            }
            byArray = byArray2;
            EL = byArray[0].length;
            cL = byArray.length;
        }
        this.TQ(byArray);
        return n2 != EL && n3 != cL;
    }

    private void TQ(byte[][] byArray) {
        TQ = new byte[cL * EL];
        int n = byArray.length;
        int n2 = byArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Signature.TQ[i * n2 + j] = byArray[i][j];
            }
        }
    }

    private byte[][] NE() {
        byte[][] byArray = new byte[cL][EL];
        for (int i = 0; i < cL; ++i) {
            for (int j = 0; j < EL; ++j) {
                byArray[i][j] = TQ[i * EL + j];
            }
        }
        return byArray;
    }

    private boolean dC() {
        int n = EL;
        int n2 = cL;
        Bitmap bitmap = this.TQ();
        bitmap = this.cL(bitmap);
        TQ = this.EL(bitmap);
        EL = bitmap.getWidth();
        cL = bitmap.getHeight();
        return n != EL && n2 != cL;
    }

    private static boolean TQ(Bitmap bitmap) {
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = bitmap.getPixel(j, i);
                int n4 = Color.red((int)n3);
                int n5 = Color.green((int)n3);
                int n6 = Color.blue((int)n3);
                if (n4 == 0 || n5 == 0 || n6 == 0 || n4 == 255 || n5 == 255 || n6 == 255) continue;
                return false;
            }
        }
        return true;
    }

    private byte[] EL(Bitmap bitmap) {
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        byte[] byArray = new byte[n * n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = bitmap.getPixel(j, i);
                int n5 = Color.red((int)n4);
                int n6 = Color.green((int)n4);
                int n7 = Color.blue((int)n4);
                byArray[n3] = n5 == 0 || n6 == 0 || n7 == 0 ? (byte)1 : 0;
                ++n3;
            }
        }
        return byArray;
    }

    private Bitmap cL(Bitmap bitmap) {
        int n;
        int n2;
        int n3;
        int n4 = bitmap.getHeight();
        if (n4 > (n3 = bitmap.getWidth())) {
            n2 = 150;
            n = 150 * n3 / n4;
        } else if (n4 < n3) {
            n = 150;
            n2 = 150 * n4 / n3;
        } else {
            n = 150;
            n2 = 150;
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n, (int)n2, (boolean)true);
    }

    Bitmap TQ() {
        Bitmap bitmap = Bitmap.createBitmap((int)EL, (int)cL, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int n = 0;
        for (int i = 0; i < cL; ++i) {
            for (int j = 0; j < EL; ++j) {
                if (TQ[n] == 0) {
                    bitmap.setPixel(j, i, -1);
                } else {
                    bitmap.setPixel(j, i, -16777216);
                }
                ++n;
            }
        }
        return bitmap;
    }

    public byte[] EL() {
        return TQ;
    }

    public int cL() {
        return EL;
    }

    public int zv() {
        return cL;
    }

    public SignatureFormatEnum dY() {
        return this.zv;
    }

    String rE() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64.OutputStream outputStream = new Base64.OutputStream(byteArrayOutputStream);
        Bitmap bitmap = null;
        switch (this.zv) {
            case MONO: {
                bitmap = this.TQ();
            }
        }
        if (bitmap == null || bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)outputStream)) {
            // empty if block
        }
        try {
            byteArrayOutputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            Timber.w((Throwable)iOException);
        }
        return byteArrayOutputStream.toString();
    }
}

