/*
 * Decompiled with CFR 0.152.
 */
package com.creditcall.chipdnamobile;

import com.creditcall.chipdnamobile.ChipDnaMobileErrorCode;
import com.creditcall.chipdnamobile.ISOAPListener;
import com.creditcall.chipdnamobile.SOAPExtendedTransaction;
import com.creditcall.chipdnamobile.SOAPService;
import com.creditcall.chipdnamobile.SOAPTransaction;
import com.creditcall.chipdnamobile.SOAPTransactionStatistics;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

class Ya {
    private static final String TQ = "yyyy-MM-dd-HH-mm-ss";
    private static final String EL = "dd/MM/yyyy HH:mm:ss";
    private static final TimeZone cL = TimeZone.getTimeZone("UTC");
    private static final Locale zv = Locale.US;

    Ya() {
    }

    static String TQ(Date date) {
        Calendar calendar = Calendar.getInstance(cL, zv);
        calendar.setTime(date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TQ, zv);
        simpleDateFormat.setTimeZone(cL);
        return simpleDateFormat.format(calendar.getTime());
    }

    static String EL(Date date) {
        Calendar calendar = Calendar.getInstance(cL, zv);
        calendar.setTime(date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(EL, zv);
        simpleDateFormat.setTimeZone(cL);
        return simpleDateFormat.format(calendar.getTime());
    }

    static Date TQ(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TQ, zv);
            simpleDateFormat.setTimeZone(cL);
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Date string must be in \"yyyy-MM-dd-HH-mm-ss\" format, could not parse: " + string, parseException);
        }
    }

    static Date EL(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(EL, zv);
            simpleDateFormat.setTimeZone(cL);
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Date string must be in \"dd/MM/yyyy HH:mm:ss\" format, could not parse: " + string, parseException);
        }
    }

    static String cL(String string) {
        Date date = Ya.TQ(string);
        return Ya.EL(date);
    }

    static String zv(String string) {
        Date date = Ya.EL(string);
        return Ya.TQ(date);
    }

    public static void TQ(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("fromDate should not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("toDate should not be null");
        }
        Date date = Ya.EL(string);
        Date date2 = Ya.EL(string2);
        if (date2.before(date)) {
            throw new IllegalArgumentException("fromDate should be before toDate");
        }
        if (date2.equals(date)) {
            throw new IllegalArgumentException("fromDate and toDate should be different");
        }
        long l = date2.getTime() - date.getTime();
        double d = (double)l / 8.64E7;
        if (d > 31.0) {
            throw new IllegalArgumentException("The range between fromDate and toDate cannot be longer than 31 days");
        }
    }

    static ChipDnaMobileErrorCode dY(String string) {
        if (string.equals("InvalidTimeZoneOffset")) {
            return ChipDnaMobileErrorCode.InvalidTimeZoneOffset;
        }
        if (string.equals("LogOnDenied")) {
            return ChipDnaMobileErrorCode.LogOnDenied;
        }
        if (string.equals("LogOnManuallyDisabled")) {
            return ChipDnaMobileErrorCode.LogOnManuallyDisabled;
        }
        if (string.equals("LogOnAutomaticallyDisabled")) {
            return ChipDnaMobileErrorCode.LogOnAutomaticallyDisabled;
        }
        if (string.equals("LogOnLocked")) {
            return ChipDnaMobileErrorCode.LogOnLocked;
        }
        if (string.equals("InvalidLoginPlatform")) {
            return ChipDnaMobileErrorCode.InvalidLoginPlatform;
        }
        return ChipDnaMobileErrorCode.SOAPError;
    }

    static void TQ(ISOAPListener iSOAPListener, SOAPService.SOAPReturnType sOAPReturnType, ChipDnaMobileErrorCode chipDnaMobileErrorCode) {
        if (sOAPReturnType == SOAPService.SOAPReturnType.TransactionStatistics) {
            Ya.EL(iSOAPListener, null, chipDnaMobileErrorCode);
        } else if (sOAPReturnType == SOAPService.SOAPReturnType.Transactions) {
            Ya.TQ(iSOAPListener, null, chipDnaMobileErrorCode);
        } else if (sOAPReturnType == SOAPService.SOAPReturnType.ExtendedTransaction) {
            Ya.TQ(iSOAPListener, null, chipDnaMobileErrorCode);
        }
    }

    static void TQ(final ISOAPListener iSOAPListener, final List<SOAPTransaction> list, final ChipDnaMobileErrorCode chipDnaMobileErrorCode) {
        new Thread(){

            @Override
            public void run() {
                iSOAPListener.retrievedTransactions(list, chipDnaMobileErrorCode);
            }
        }.start();
    }

    static void EL(final ISOAPListener iSOAPListener, final List<SOAPTransactionStatistics> list, final ChipDnaMobileErrorCode chipDnaMobileErrorCode) {
        new Thread(){

            @Override
            public void run() {
                iSOAPListener.retrievedTransactionStatistics(list, chipDnaMobileErrorCode);
            }
        }.start();
    }

    static void TQ(final ISOAPListener iSOAPListener, final SOAPExtendedTransaction sOAPExtendedTransaction, final ChipDnaMobileErrorCode chipDnaMobileErrorCode) {
        new Thread(){

            @Override
            public void run() {
                iSOAPListener.retrievedTransaction(sOAPExtendedTransaction, chipDnaMobileErrorCode);
            }
        }.start();
    }
}

